#ifndef TRANSKODE_KDECSPINBOX_H
#define TRANSKODE_KDECSPINBOX_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <knuminput.h>
#include "kdecvalidator.h"

#include <qwidget.h>
#include <qwidgetplugin.h>

class QT_WIDGET_PLUGIN_EXPORT KDecSpinBox : public KIntSpinBox
{
	Q_OBJECT

	Q_PROPERTY( int precision READ precision WRITE setPrecision )
	Q_PROPERTY( int minValue READ minValue WRITE setMinValue )
	Q_PROPERTY( int maxValue READ maxValue WRITE setMaxValue )

	public:

		KDecSpinBox( QWidget *parent = 0, const char *name = 0 );

		int precision() const;
		int minValue() const;
		int maxValue() const;

		// NOTE: NOT PROPERTIES because the value set depends on the precision value
		// and we can rely on the precision property to be set before the other ones
		// wich makes things completely unreliable when working with Qt Designer.
		double decimalValue();
		void setDecimalValue( double value );

	public slots:

		void setPrecision( int precision );
		void setMinValue( int minValue );
		void setMaxValue( int maxValue );

	protected:
		virtual QString mapValueToText( int v ); // Redefined
		virtual int mapTextToValue( bool* ok ); // Redefined

		static double positivePower( int value, unsigned power );

	private:
		unsigned m_precision;
		double m_precisionConstant;
		KDecValidator* m_validator;
};

#endif
