/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kdecvalidator.h"

#include <limits>

KDecValidator::KDecValidator( QObject* parent, const char* name ):
	QValidator( parent, name ),
	m_minimum( std::numeric_limits<double>::min() ),
	m_maximum( std::numeric_limits<double>::max() )
{
}


KDecValidator::KDecValidator( double min, double max, QObject* parent, const char* name ):
	QValidator( parent, name ),
	m_minimum( min ),
	m_maximum( max )
{
}

double KDecValidator::minimum()
{
	return m_minimum;
}

void KDecValidator::setMinimum( double min )
{
	m_minimum = min;
}

double KDecValidator::maximum()
{
	return m_maximum;
}

void KDecValidator::setMaximum( double max )
{
	m_maximum = max;
}

QValidator::State KDecValidator::validate( QString& input, int& ) const
{
	bool ok;
	double number = input.toDouble( &ok );
	if ( ok && number >= m_minimum && number <= m_maximum )
		return QValidator::Acceptable;
	else if ( ok )
		return QValidator::Intermediate;
	else
		return QValidator::Invalid;
}
