#ifndef _QEMBED_1804289383
#define _QEMBED_1804289383
#include <qimage.h>
#include <qdict.h>
static const unsigned char kdecspinbox_data[] = {
    0x00,0x01,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x04,0x05,0x06,0x00,0x00,0x00,0x01,0x07,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x09,0x0a,0x00,0x00,0x00,0x02,0x0b,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0d,0x0c,0x0c,0x0e,0x0f,0x00,
    0x00,0x00,0x03,0x10,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x12,0x0f,0x12,0x11,0x13,0x0f,0x00,0x00,0x00,0x03,0x14,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x09,0x0f,
    0x0f,0x0f,0x09,0x09,0x0f,0x00,0x00,0x00,0x03,0x15,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x0f,0x0f,0x0f,0x0f,0x0f,0x17,
    0x0f,0x00,0x00,0x00,0x03,0x16,0x18,0x0f,0x0f,0x18,0x19,0x19,0x19,0x18,
    0x0f,0x0f,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1a,0x0f,0x00,0x00,0x00,
    0x03,0x1b,0x0f,0x1c,0x1c,0x0f,0x1c,0x1c,0x1c,0x0f,0x1c,0x1c,0x0f,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1d,0x0f,0x00,0x00,0x00,0x03,0x1e,0x1f,0x0f,
    0x0f,0x1f,0x20,0x20,0x20,0x20,0x0f,0x0f,0x0f,0x20,0x20,0x20,0x20,0x20,
    0x20,0x21,0x0f,0x00,0x00,0x00,0x03,0x22,0x0f,0x23,0x23,0x0f,0x23,0x24,
    0x23,0x23,0x23,0x23,0x0f,0x23,0x23,0x23,0x23,0x23,0x23,0x25,0x0f,0x00,
    0x00,0x00,0x03,0x26,0x24,0x0f,0x0f,0x24,0x27,0x0f,0x27,0x24,0x0f,0x0f,
    0x24,0x27,0x27,0x27,0x27,0x27,0x27,0x28,0x0f,0x00,0x00,0x00,0x03,0x29,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x18,0x0f,0x00,0x00,0x00,0x03,0x27,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2c,0x0f,0x0f,0x0f,0x2c,0x2d,
    0x0f,0x00,0x00,0x00,0x03,0x2e,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x30,0x0f,0x30,0x2f,0x31,0x0f,0x00,0x00,0x00,
    0x03,0x32,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
    0x33,0x33,0x34,0x33,0x33,0x35,0x0f,0x00,0x00,0x00,0x03,0x2b,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x36,0x0f,0x00,0x00,0x00,0x04,0x2f,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x37,0x38,0x0f,0x00,
    0x00,0x00,0x05,0x38,0x39,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,
    0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3b,0x3c,0x3d,0x00,0x00,0x00,0x06,0x0a,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x3d,0x3e,0x00,0x00,0x00
};

static const QRgb kdecspinbox_ctable[] = {
    0xffb9b7b1,0xff999896,0xff737373,0xff676767,0xff585858,0xff4f4e4c,0xff7e7c77,0xffdcdcdc,0xfffdfdfd,0xffc1c1c1,0xff292826,0xfffcfcfc,0xfffafafa,0xffc6c6c6,
    0xffcacaca,0xff000000,0xfff8f8f8,0xfff7f7f7,0xffc3c3c3,0xffc4c4c4,0xfff6f6f6,0xfff3f3f3,0xfff0f0f0,0xffbfbfbf,0xffaaaaaa,0xffececec,0xffbcbcbc,0xffededed,
    0xffe8e8e8,0xffb9b9b9,0xffe9e9e9,0xffa3a3a3,0xffe3e3e3,0xffb4b4b4,0xffe5e5e5,0xffdfdfdf,0xff9d9d9d,0xffb1b1b1,0xffe1e1e1,0xffd9d9d9,0xffadadad,0xffdedede,
    0xffd5d5d5,0xffd0d0d0,0xffa5a5a5,0xffa6a6a6,0xffd6d6d6,0xffcccccc,0xffa1a1a1,0xffa2a2a2,0xffd3d3d3,0xffc7c7c7,0xff9e9e9e,0xff9f9f9f,0xff9c9c9c,0xffbababa,
    0xff909090,0xff999999,0xff969696,0xff8d8d8d,0xff595959,0xff20201f,0xff605e5a
};

/* Generated by qembed */
static struct EmbedImage {
    int width, height, depth;
    const unsigned char *data;
    int numColors;
    const QRgb *colorTable;
    bool alpha;
    const char *name;
} embed_image_vec[] = {
    { 21, 19, 8, (const unsigned char*)kdecspinbox_data, 63, kdecspinbox_ctable, FALSE, "kdecspinbox" },
    { 0, 0, 0, 0, 0, 0, 0, 0 }
};

static const QImage& qembed_findImage( const QString& name )
{
    static QDict<QImage> dict;
    QImage* img = dict.find( name );
    if ( !img ) {
	for ( int i = 0; embed_image_vec[i].data; i++ ) {
	    if ( strcmp(embed_image_vec[i].name, name.latin1()) == 0 ) {
		img = new QImage((uchar*)embed_image_vec[i].data,
			    embed_image_vec[i].width,
			    embed_image_vec[i].height,
			    embed_image_vec[i].depth,
			    (QRgb*)embed_image_vec[i].colorTable,
			    embed_image_vec[i].numColors,
			    QImage::BigEndian );
		if ( embed_image_vec[i].alpha )
		    img->setAlphaBuffer( TRUE );
		dict.insert( name, img );
		break;
	    }
	}
	if ( !img ) {
	    static QImage dummy;
	    return dummy;
	}
    }
    return *img;
}

#endif
