/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetsplugin.h"
#include "images.h"
#include <kdecspinbox.h>

TransKode::WidgetsPlugin::WidgetsPlugin()
{
}

QStringList TransKode::WidgetsPlugin::keys() const
{
	QStringList list;
	list << "KDecSpinBox";
	return list;
}

QWidget* TransKode::WidgetsPlugin::create( const QString &key, QWidget* parent, const char* name )
{
	if ( key == "KDecSpinBox" )
		return new KDecSpinBox( parent, name );
	return 0;
}

QString TransKode::WidgetsPlugin::includeFile( const QString& feature ) const
{
	if ( feature == "KDecSpinBox" )
		return "kdecspinbox.h";
	return QString::null;
}

QString TransKode::WidgetsPlugin::group( const QString& feature ) const
{
	if ( feature == "KDecSpinBox" )
		return "Input";
	return QString::null;
}

QIconSet TransKode::WidgetsPlugin::iconSet( const QString& ) const
{
	return QIconSet( QPixmap( qembed_findImage( "kdecspinbox" ) ) );
}

QString TransKode::WidgetsPlugin::toolTip( const QString& feature ) const
{
	if ( feature == "KDecSpinBox" )
		return "Decimal Spin Box";
	return QString::null;
}

QString TransKode::WidgetsPlugin::whatsThis( const QString& feature ) const
{
	if ( feature == "KDecSpinBox" )
		return "<qt>A spin box widget with decimals emulation (spin button).</qt>";
	return QString::null;
}

bool TransKode::WidgetsPlugin::isContainer( const QString& ) const
{
	return FALSE;
}

Q_EXPORT_PLUGIN( TransKode::WidgetsPlugin )
