#!/bin/sh


config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config /etc/tunapie.config.new




( echo -e "\E[0;32m+----------------------------------------------------------------------+\E[0;0m" )
( echo -e "\E[0;32m|  Done. The     /etc/tunapie.conf is by default in censured mode:     |\E[0;0m" )
( echo -e "\E[0;32m|                    ------------CHILD PROTECTION-----------           |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|      If you want switch to *ADULT* mode edit /etc/tunapie.conf       |\E[0;0m" )
( echo -e "\E[0;32m|      and change  -0-  to  -1-                                        |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m+--------------------------------------------------------------------- +\E[0;0m" )



if [ -x /usr/bin/update-mime-database ]; then
  /usr/bin/update-mime-database /usr/share/mime &> /dev/null
fi

if [ -x /usr/bin/update-desktop-database ]; then
  /usr/bin/update-desktop-database 1> /dev/null 2> /dev/null
fi

if [ -x /usr/bin/gtk-update-icon-cache ]; then
  /usr/bin/gtk-update-icon-cache  -f -q /usr/share/icons/hicolor 1> /dev/null 2> /dev/null
fi

