/***************************************************************************
					main.cpp  -  description
						 -------------------
		begin                : t jn 29 04:54:46 CEST 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "control.h"
#include <stdexcept>
#include <new>
#include <qmessagebox.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kglobal.h>
#include "tuneroid.h"

static const char *description =
  I18N_NOOP("<p><nobr><b>tuneroid</b> is a tuner for a variety of musical instruments.</nobr></p>");


static KCmdLineOptions options[] =
{
	{ 0, 0, 0 }
	// INSERT YOUR COMMANDLINE OPTIONS HERE
};

void fatalMessage(int argc, char *argv[], const char* errorText);

int main(int argc, char *argv[])
{
	try {
		KAboutData aboutData("tuneroid", I18N_NOOP("tuneroid"),
							 VERSION, description, KAboutData::License_GPL,
							 "(c) 2000-2005, Jozef Kosoru", I18N_NOOP("Enjoy tuneriod!"),
							 "http://zyzstar.kosoru.com/?tuneroid", "jozef.kosoru@pobox.sk");

		aboutData.addAuthor("Jozef Kosoru", 0, "jozef.kosoru@pobox.sk");
		aboutData.addCredit("Carlo Caposaca",I18N_NOOP("bug-reporter"),
						    "capocasa@gmx.net");
		aboutData.addCredit("Klaus Krechan",I18N_NOOP("bug-reporter"),
						    "klaus@krechan.de");
		aboutData.addCredit("Alexandre Prokoudine",I18N_NOOP("russian translation"),
						    "avp@altlinux.ru");
		aboutData.addCredit("Kate Draven",I18N_NOOP("bug-reporter"),
						    "borgqueen@earthlink.net");
		aboutData.addCredit("Peter Vrabel",I18N_NOOP("tester"),
						    "kybu@kybu.org");
				

		KCmdLineArgs::init(argc, argv, &aboutData);
		KCmdLineArgs::addCmdLineOptions(options); // Add our own options.

		KApplication app;
		Tuneroid* const tuneroid = new Tuneroid;
		app.setMainWidget(tuneroid);

		tuneroid->show();
		return app.exec();

	}
	catch (const std::exception& errExcept)
	{
		fatalMessage(argc, argv, errExcept.what());
		return -1;
	}
}

void fatalMessage(int argc, char *argv[], const char* errorText)
{
	QApplication fatalApp(argc, argv);
	QMessageBox::about(0, "tuneroid - Fatal Error!", errorText);
}
