/***************************************************************************
					optionsdialog.h  -  description
						 -------------------
		begin                : Mon Jul 10 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <cmath>
#include <qwidget.h>
#include <kdialogbase.h>

class TunerOptions;
class ToneDetermine;
class QStringList;
class QComboBox;
class QSpinBox;
class QSlider;
class QCheckBox;
class QLineEdit;

/**
 *	@author Jozef Kosoru
 */
class OptionsDialog : public KDialogBase
{
	 Q_OBJECT

public:
	OptionsDialog(QWidget* parent = 0, const char* name = 0);
	~OptionsDialog();

	virtual QSize minimumSizeHint() const;

protected slots:
	virtual void slotApply();
	virtual void slotDefault();
	virtual void slotOk();

private:
	inline int roundToInt(float f)
	{
		int sign = 1;
		if (f < 0)
		{
			f = -f;
			sign = -1;
		}

		const int fi = static_cast<int>(f);

		if ((f - static_cast<float>(fi)) >= 0.5)
		{
			return (fi + 1) * sign;
		}
		else{
			return fi * sign;
		}
	}

	inline int getSliderSensitivityValue(const float y)
	{
		// y = ((x / 100)^(Log[0.5, 0.2])) * 0.5
		static const float a1 = 0.0000113531;
		static const float b1 = 1.0 / 2.32193;
		return roundToInt(powf(y / a1, b1)); //return x
	}

	inline float getThresholdSensitivityValue(const int x)
	{
		// y = ((x / 100)^(Log[0.5, 0.2])) * 0.5
		static const float a1 = 0.0000113531;
		static const float b1 = 2.32193;
		return a1 * powf(static_cast<float>(x), b1); //return y
	}

	inline float getFloatCalibrationValue(const int x)
	{
		// float = (int * 0.0003) + 1
		return (static_cast<float>(x) * 0.0003) + 1;
	}

	inline int getIntCalibrationValue(const float y)
	{
		// int = (float - 1) / 0.0003
		return roundToInt((y - 1) / 0.0003);
	}

private:
	void initTab1();
	void initTab2();
	void loadSettings();
	QStringList getDeviceList();
	void setCurrentSamplerateItem(QComboBox* samplerateBox);

	TunerOptions* m_options;
	ToneDetermine* m_toneDetermine;

	//tab1
	QComboBox* m_deviceCombo;
	QSpinBox* m_subdeviceSpinBox;
    QCheckBox* m_setPcmNameCheckBox;
	QLineEdit* m_pcmNameLineEdit;
	QComboBox* m_resolutionCombo;
	QComboBox* m_samplerateCombo;
	QSpinBox* m_responseSpinBox;

	//tab2
	QSpinBox* m_freqOfASpinBox;
	QSpinBox* m_calibrateSpinBox;
	QSpinBox* m_maxFreqSpinBox;
	QSpinBox* m_minFreqSpinBox;
	QSlider* m_sensitivitySlider;

};

#endif
