/***************************************************************************
					pitchdetector.h  -  description
						 -------------------
		begin                : Fri Jun 30 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PITCHDETECTOR_H
#define PITCHDETECTOR_H

#include <stdint.h>
#include <new>

class TunerOptions;

/**
 *	@author Jozef Kosoru
 */
template<class SAMPLE>
class PitchDetector
{
private:
	struct PeakStore
	{
		int position;
		SAMPLE value;
	};

	struct ValueRange
	{
		int lo;
		int hi;
	};

	enum SearchPhase { lowSignal, topPeak, bottomPeak };

	SAMPLE m_threshold;   //samples under this value are ignored
	float m_samplerate;
	int m_maxPeriod;      //min freq
	int m_minPeriod;      //max freq
	float m_maxPeriodDif; //max period difference between two neighbouring valid peaks
	float m_maxAmpDif;    //max amplitude difference between two neighbouring valid peaks
	int m_minPeaksAmount; //min number of valid peaks (2=min!)
	int m_peaksMinimum;   //min number of peaks
	int m_bufSize;
	SAMPLE* m_buffer;
	PeakStore* m_peakBufPos;  //buffer for positive peaks
	PeakStore* m_peakBufNeg;  //buffer for negative peaks

	inline static int roundToInt(const float f);
	inline static int averagePeak(const PeakStore* peaksBuf, const int bufSize);
	inline static ValueRange computeRange(const int num, const float difMulti);
	inline int giveBasePeriod(int& cStep, const PeakStore* peakBuff, const int start,
							  const int stop, const bool rightDirect) const;
	inline int findAnotherPeriod(const int cPeriod, int& bufStep, const PeakStore* peakBuff,
								 const int stop, const bool rightDirect) const;

public:
	PitchDetector(const TunerOptions* options);
	PitchDetector(int sampleRate,
				  SAMPLE* buffer,
				  int bufSize,
				  SAMPLE threshold,
				  int maxFreq = 20000,
				  int minFreq = 20,
				  float maxFreqDif = 0.1,
				  float maxAmpDif = 0.1,
				  float calibration = 1,
				  int minPeaksAmount = 2) throw (std::bad_alloc);

	~PitchDetector();
	float analyzeBuffer();
};

typedef PitchDetector<int16_t> PitchDetector_16bit;
typedef PitchDetector<int8_t> PitchDetector_8bit;

#endif
