/***************************************************************************
					threadengine.h  -  description
						 -------------------
		begin                : Tue Jul 4 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THREADENGINE_H
#define THREADENGINE_H

#include <stdexcept>
#include <string>
#include <pthread.h>
#include <qobject.h>

class QString;
class QSocketNotifier;
class ToneDetermine;

namespace Thread{
	void* th_analyzer(void*);
}

/**
 *	@author Jozef Kosoru
 */
class ThreadEngine : public QObject
{
	 Q_OBJECT

public:
	ThreadEngine(QObject* parent = 0) throw(std::runtime_error);
	~ThreadEngine();
	void startThread() throw(std::runtime_error);
	void stopThread();
	void setError(const char* const errorText);
	void setFreq(const float freq);
	friend void* Thread::th_analyzer(void* ptr);

signals:
	void signalFreqChanged(float);
	void signalIndicatorChanged(int);
	void signalToneChanged(int);
	void signalThreadError(QString);

private:
	void postMessage();

protected slots:
	void messageHandler();

private:
	volatile bool m_exitThread;
	volatile bool m_isError;
	volatile float m_freq;
	std::string m_sErrorText;
	QSocketNotifier* m_notifier;
	int m_fds[2];
	pthread_mutex_t m_messageLock;
	pthread_t m_thread;
	ToneDetermine* m_toneDetermine;
};

#endif
