/***************************************************************************
					tonedetermine.h  -  description
						 -------------------
		begin                : Sat Jul 8 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TONEDETERMINE_H
#define TONEDETERMINE_H

#include <cmath>

class TunerOptions;

/**
 *	@author Jozef Kosoru
 */
class ToneDetermine
{
public:
	ToneDetermine(const TunerOptions* options);
	~ToneDetermine();
	int getTone(const float freq);
	int getDivergency(const float freq);
	void setNewFreqOf_A(const TunerOptions* options);

private:
	void analyzeFreq(const float freq);
	double m_logFreqOf_A;
	float m_lastFreq;
	int m_divergence;
	int m_tone;
	double m_logToneFreq[12];
	static const double m_toneIncrease;
	static const double m_log2;

	inline static int roundToInt(const double f)
	{
		const int fi = static_cast<int>(f);
		if ((f - static_cast<double>(fi)) >= 0.5)
		{
			return fi + 1;
		}
		else
		{
			return fi;
		}
	};

};

#endif
