/***************************************************************************
					tunerdisplay.h  -  description
						 -------------------
		begin                : Fri Feb 4 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TUNERDISPLAY_H
#define TUNERDISPLAY_H

#include <qwidget.h>
#include <qframe.h>
#include <qpoint.h>
#include <qrect.h>

class QPixmap;
class QTimer;

#define X_CROP_OFFSET   (-19)
#define Y_CROP_OFFSET   (-47)

/**
 *	@author Jozef Kosoru
 */
class TunerDisplay : public QFrame
{
	 Q_OBJECT

public:
	TunerDisplay(QWidget *parent = 0, const char *name = 0);
	~TunerDisplay();
	void resetDisplay();

public slots:
	void slotChangeIndicator(int);		// <-32,0,32> , 999=OFF
	void slotChangeTone(int);			// <0,11> , 999=OFF
	void slotChangeFrequency(float);	// -1=OFF

private slots:
	void slotDrawBlinkArrow();

private:
	void paintEvent(QPaintEvent*);
	void updateON();			//draw only new lightBars and grayBars
	void redrawON();			//draw all lightBars
	void drawGrayBar(int numOfBar);
	void drawLightBar(int numOfBar);
	void drawTUNED(bool light);
	void drawLEFTarrow(bool light);
	void drawRIGHTarrow(bool light);
	void drawTone(int tone, bool light);
	void drawFreq(bool redraw);

	// If I simply mark these (see below) function declarations
	// as inline and then I place their definitions to 'tunerdisplay.cpp',
	// linker fails to make an executable. Note that they are private!
	// Am I wrong or It's a bug in the compiler (egcs-1.1.2)
	// (Maybe it's because of moc compiler)
	/*
	inline QPoint getGrayPoint(int numOfBar) const;
	inline QRect getGrayRect(int numOfBar) const;
	inline QRect getLightRect(int numOfBar) const;
	*/
	QPoint getGrayPoint(int numOfBar) const
	{
		if(numOfBar > 0)
		{
			return(QPoint(s_RIndicator[numOfBar - 1][0] + m_frameWidth,
						  s_RIndicator[numOfBar - 1][1] + m_frameWidth));
		}
		else{
			return(QPoint(s_LIndicator[(-numOfBar) - 1][0] + m_frameWidth,
						  s_LIndicator[(-numOfBar) - 1][1] + m_frameWidth));
		}
	}

	QRect getGrayRect(int numOfBar) const
	{
		if(numOfBar > 0)
		{
			QPoint topLeft(s_RIndicator[numOfBar - 1][0],
						   s_RIndicator[numOfBar - 1][1]);

			return(QRect(topLeft, QPoint(s_RIndicator[numOfBar - 1][2],
										 s_RIndicator[numOfBar - 1][3])));
		}
		else
		{
			QPoint topLeft(s_LIndicator[(-numOfBar) - 1][0],
						   s_LIndicator[(-numOfBar) - 1][1]);

			return(QRect(topLeft, QPoint(s_LIndicator[(-numOfBar) - 1][2],
										 s_LIndicator[(-numOfBar) - 1][3])));
		}
	}

	QRect getLightRect(int numOfBar) const
	{
		if(numOfBar > 0)
		{
			QPoint topLeft(s_RIndicator[numOfBar - 1][0] + X_CROP_OFFSET,
						   s_RIndicator[numOfBar - 1][1] + Y_CROP_OFFSET);

			return(QRect(topLeft, QPoint(s_RIndicator[numOfBar - 1][2] + X_CROP_OFFSET,
										 s_RIndicator[numOfBar - 1][3] + Y_CROP_OFFSET)));
		}
		else
		{
			QPoint topLeft(s_LIndicator[(-numOfBar) - 1][0] + X_CROP_OFFSET,
						   s_LIndicator[(-numOfBar) - 1][1] + Y_CROP_OFFSET);

			return(QRect(topLeft, QPoint(s_LIndicator[(-numOfBar) - 1][2] + X_CROP_OFFSET,
										 s_LIndicator[(-numOfBar) - 1][3] + Y_CROP_OFFSET)));
		}
	}

	//////////////// variables
	QPixmap* m_display_OFF;
	QPixmap* m_display_ON;
	QPixmap* m_display_TONE;
	QPixmap* m_display_DIGITS;
	QPixmap* m_tempDigit;
	QTimer* m_blinkArrowTimer;

	// values that should be...
	bool m_LArrow;
	bool m_RArrow;
	int m_Indicator;	// <-32,0,32> , 999=OFF
	float m_freq;
	// values that currently are...
	bool m_LArrow_c;
	bool m_RArrow_c;
	int m_Indicator_c;
	int m_Tone_c;		// <0,10> , 999=OFF
	float m_freq_c;

	int m_frameWidth;
	char m_freqStr[9];

	//positions
	static const short int s_LIndicator[32][4];
	static const short int s_RIndicator[32][4];
	static const short int s_TUNEDmarks[8][4];
	static const short int s_TonePosition[12][4];
	static const short int s_DigitPosition[7][2];
};

#endif
