/***************************************************************************
					tuneroid.h  -  description
						 -------------------
		begin                : Fri Feb 4 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TUNEROID_H
#define TUNEROID_H

#include <qstrlist.h>
#include <qworkspace.h>
#include <kapplication.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include "threadengine.h"

#define APP_MINI_ICON "tuneroid.png"

class TunerDisplay;
class TunerOptions;
class QTimerEvent;
class ToneDetermine;

class Tuneroid : public KMainWindow
{
	Q_OBJECT

public:
	Tuneroid();
	~Tuneroid();
	ToneDetermine* getToneDetermine() const { return m_toneDetermine; };
	TunerOptions* getTunerOptions() const { return m_options; };
	ThreadEngine* getThreadEngine() const {return m_engine; };
	TunerDisplay* getDisplay() const { return m_lcdDisplay; };

	friend void* Thread::th_analyzer(void*);

private:
	void initToolBar();
	void initEngine();
	virtual void timerEvent(QTimerEvent*);

	TunerDisplay* m_lcdDisplay;
	TunerOptions* m_options;
	ThreadEngine* m_engine;
	ToneDetermine* m_toneDetermine;

private slots:
	void slotOptions();
	void slotFrom_File();
	void slotErrorMessage(QString message);
	void slotAbout();

};

#endif
