/***************************************************************************
					tuneroptions.h  -  description
						 -------------------
		begin                : Tue Jul 4 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TUNEROPTIONS_H
#define TUNEROPTIONS_H

#include <string>
#include <vector>

/**
 *	@author Jozef Kosoru
 */
class TunerOptions
{
public:
	struct DeviceEntry
	{
		std::string sCardName;
		int iCardNumber;
		int iDevicesCount;
	};

public:
	TunerOptions();
	~TunerOptions();
	void readOptions();
	void saveOptions();

	// sound card
	std::vector<DeviceEntry> m_deviceList;

	int m_iCardNumber;
	int m_iDeviceNumber;

	bool m_bUsePcmString;
    std::string m_sPcmName;

	int m_iResolution;		// sample resolution

	int m_iSamplerate;
	int m_iSamplerate_real;

	int m_iBufferTime;		// msec !!
	int m_iBufferSize_real;	// bytes !!

	char* m_pAudioBuffer;

	bool m_bFromFile;

	// pitch detection
	float m_threshold;		//samples under this value are ignored
	int m_maxFreq;			//min freq
	int m_minFreq;			//max freq
	float m_maxFreqDif;		//max period difference between two neighbouring valid peaks
	float m_maxAmpDif;		//max amplitude difference between two neighbouring valid peaks
	int m_minPeaksAmount;	//min number of valid peaks (2=min!)
	int m_peaksMinimum;		//min number of peaks
	float m_calibration;

	// tone determine
	float m_freqOf_A;

};

#endif
