
#!/bin/sh
###
# Place the Avahi init script.
###
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}


config etc/rc.d/rc.avahidaemon.new
config etc/rc.d/rc.avahidnsconfd.new
config etc/avahi/avahi-daemon.conf.new
config etc/dbus-1/system.d/avahi-dbus.conf.new

###
# Create avahi user:group if they don't exist.
###
group_exists=`grep ^avahi etc/group`
if [[ "${group_exists}" == "" ]]; then
	groupadd avahi
fi
user_exists=`grep ^avahi etc/passwd`
if [[ "${user_exists}" == "" ]]; then
	useradd -g avahi -d / -c "Avahi" -s /bin/false avahi
fi

###
# Create avahi-autoipd user:group if they don't exist.
###
group_exists=`grep ^avahi-autoipd  etc/group`
if [[ "${group_exists}" == "" ]]; then
	groupadd avahi-autoipd 
fi
user_exists=`grep ^avahi-autoipd  etc/passwd`
if [[ "${user_exists}" == "" ]]; then
	useradd -g avahi-autoipd -d / -c "Avahi-Autopid" -s /bin/false avahi-autoipd
fi

###
# Create netdev group if they don't exist.
###
group_exists=`grep ^netdev etc/group`
if [[ "${group_exists}" == "" ]]; then
	groupadd netdev
fi


#Avahi-daemon
# To disable Avahi, chmod rc.hal to 644
if [ -x /etc/rc.d/rc.rc.avahidaemon ]; then
	sh /etc/rc.d/rc.rc.avahidaemon start
fi








( cd usr/lib ; rm -rf libavahi-common.so.3 )
( cd usr/lib ; ln -sf libavahi-common.so.3.4.4 libavahi-common.so.3 )
( cd usr/lib ; rm -rf libavahi-qt3.so.1 )
( cd usr/lib ; ln -sf libavahi-qt3.so.1.0.1 libavahi-qt3.so.1 )
( cd usr/lib ; rm -rf libavahi-client.so.3 )
( cd usr/lib ; ln -sf libavahi-client.so.3.2.2 libavahi-client.so.3 )
( cd usr/lib ; rm -rf libavahi-glib.so.1 )
( cd usr/lib ; ln -sf libavahi-glib.so.1.0.1 libavahi-glib.so.1 )
( cd usr/lib ; rm -rf libdns_sd.so.1 )
( cd usr/lib ; ln -sf libdns_sd.so.1.0.0 libdns_sd.so.1 )
( cd usr/lib/mono/avahi-sharp ; rm -rf avahi-sharp.dll )
( cd usr/lib/mono/avahi-sharp ; ln -sf ../gac/avahi-sharp/1.0.0.0__4d116c78973743f5/avahi-sharp.dll avahi-sharp.dll )
( cd usr/lib/mono/avahi-ui-sharp ; rm -rf avahi-ui-sharp.dll )
( cd usr/lib/mono/avahi-ui-sharp ; ln -sf ../gac/avahi-ui-sharp/0.0.0.0__4d116c78973743f5/avahi-ui-sharp.dll avahi-ui-sharp.dll )
( cd usr/lib ; rm -rf libhowl.so.0 )
( cd usr/lib ; ln -sf libhowl.so.0.0.0 libhowl.so.0 )
( cd usr/lib ; rm -rf libhowl.so )
( cd usr/lib ; ln -sf libhowl.so.0.0.0 libhowl.so )
( cd usr/lib ; rm -rf libavahi-ui.so )
( cd usr/lib ; ln -sf libavahi-ui.so.0.0.1 libavahi-ui.so )
( cd usr/lib ; rm -rf libavahi-client.so )
( cd usr/lib ; ln -sf libavahi-client.so.3.2.2 libavahi-client.so )
( cd usr/lib ; rm -rf libavahi-glib.so )
( cd usr/lib ; ln -sf libavahi-glib.so.1.0.1 libavahi-glib.so )
( cd usr/lib ; rm -rf libdns_sd.so )
( cd usr/lib ; ln -sf libdns_sd.so.1.0.0 libdns_sd.so )
( cd usr/lib ; rm -rf libavahi-core.so.5 )
( cd usr/lib ; ln -sf libavahi-core.so.5.0.2 libavahi-core.so.5 )
( cd usr/lib ; rm -rf libavahi-common.so )
( cd usr/lib ; ln -sf libavahi-common.so.3.4.4 libavahi-common.so )
( cd usr/lib ; rm -rf libavahi-ui.so.0 )
( cd usr/lib ; ln -sf libavahi-ui.so.0.0.1 libavahi-ui.so.0 )
( cd usr/lib ; rm -rf libavahi-core.so )
( cd usr/lib ; ln -sf libavahi-core.so.5.0.2 libavahi-core.so )
( cd usr/lib ; rm -rf libavahi-qt3.so )
( cd usr/lib ; ln -sf libavahi-qt3.so.1.0.1 libavahi-qt3.so )
( cd usr/bin ; rm -rf avahi-publish-address )
( cd usr/bin ; ln -sf avahi-publish avahi-publish-address )
( cd usr/bin ; rm -rf avahi-resolve-host-name )
( cd usr/bin ; ln -sf avahi-resolve avahi-resolve-host-name )
( cd usr/bin ; rm -rf avahi-publish-service )
( cd usr/bin ; ln -sf avahi-publish avahi-publish-service )
( cd usr/bin ; rm -rf bvnc )
( cd usr/bin ; ln -sf bssh bvnc )
( cd usr/bin ; rm -rf avahi-browse-domains )
( cd usr/bin ; ln -sf avahi-browse avahi-browse-domains )
( cd usr/bin ; rm -rf avahi-resolve-address )
( cd usr/bin ; ln -sf avahi-resolve avahi-resolve-address )
( cd usr/man/man1 ; rm -rf bvnc.1 )
( cd usr/man/man1 ; ln -sf bssh.1 bvnc.1 )
( cd usr/man/man1 ; rm -rf avahi-resolve-address.1 )
( cd usr/man/man1 ; ln -sf avahi-resolve.1 avahi-resolve-address.1 )
( cd usr/man/man1 ; rm -rf avahi-publish-service.1 )
( cd usr/man/man1 ; ln -sf avahi-publish.1 avahi-publish-service.1 )
( cd usr/man/man1 ; rm -rf avahi-browse-domains.1 )
( cd usr/man/man1 ; ln -sf avahi-browse.1 avahi-browse-domains.1 )
( cd usr/man/man1 ; rm -rf avahi-publish-address.1 )
( cd usr/man/man1 ; ln -sf avahi-publish.1 avahi-publish-address.1 )
( cd usr/man/man1 ; rm -rf avahi-resolve-host-name.1 )
( cd usr/man/man1 ; ln -sf avahi-resolve.1 avahi-resolve-host-name.1 )
