#!/usr/bin/python
# -*-python-*-
# $Id: ServiceTypeDatabase.py.in 1245 2006-08-06 11:54:31Z lennart $

# This file is part of avahi.
#
# avahi is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# avahi is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with avahi; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA.

import gdbm
import locale
import re

locale.setlocale(locale.LC_ALL, '')

class ServiceTypeDatabase:

    def __init__(self, filename = "/usr/share/avahi/service-types.db"):

        self.db = gdbm.open(filename, "r")

        l = locale.getlocale(locale.LC_MESSAGES)

        self.suffixes = ()

        if not l[0] is None:

            if not l[1] is None:
                self.suffixes += (l[0] + "@" + l[1], )

            self.suffixes += (l[0], )

            i = l[0].find("_")

            if i >= 0:

                k = l[0][:i]
                
                if not l[1] is None:
                    self.suffixes += (k + "@" + l[1], )

                self.suffixes += (k, )
            
            
        self.suffixes = tuple(map(lambda x:  "["+x+"]", self.suffixes)) + ("", )

    def __getitem__(self, key):

        for suffix in self.suffixes:
            try:
                return self.db[key + suffix]
            except KeyError:
                pass

        raise KeyError()

    def items(self):

        items = []
        key = self.db.firstkey()
        while key is not None:
            if re.search('_[a-zA-Z0-9-]+\._[a-zA-Z0-9-]+', key) and not re.search('_[a-zA-Z0-9-]+\._[a-zA-Z0-9-]+\[.*\]', key):
                localized_service_name = self[key]
                items.append((key, localized_service_name))
            key = self.db.nextkey(key)
        return items

    def has_key(self, key):

        for suffix in self.suffixes:

            if self.db.has_key(key + suffix):
                return True
            
        return False

    def __contains__(self, item):

        for suffix in self.suffixes:

            if item+suffix in self.db:
                return True

        return False
        

        
if __name__ == "__main__":
    
    b = ServiceTypeDatabase()
    print b.items()

    print b["_http._tcp"]
    print b["_ftp._tcp"]
    print b["_webdav._tcp"]
    print b["_webdavs._tcp"]

    print b["gurki._tcp"]
