/*
  XMMS InfoPipe plugin
  Distributed under GNU GPL. See the COPYING file for details.

  Written by Weyfour WWWWolf (Urpo Lankinen),
  2000-12-09 and onward
 
  $Id: infopipe.c,v 1.14 2002/05/19 11:08:40 wwwwolf Exp $
*/

/***********************************************************/
/*
  FIXME: This thing has, ahem, accumulated some cruft. Is this all
  absolutely necessary?
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <pthread.h>
#include <time.h>
#include <pwd.h>
#include <glib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <xmms/plugin.h>
#include <xmms/util.h>
#include <xmms/xmmsctrl.h>

#include "infopipe.h"
#include "../config.h"
#include "infopipe_config.h"

/***********************************************************/

/* Some strings - these are initialized in the
   init function and g_free()d in the finalization function.
   infopipe_ver should be gchar *, but for some reason, it wants
   a "constant" and pointer-passing gives Weird Results...
*/

/* Name and version */
#define VERSTRLEN 40
char infopipe_ver[VERSTRLEN];
/* FIFO file name. */
gchar *fifo_file = NULL;
/* Current user's name. */
gchar *user_name;

/*
  The data structure that holds the information about this plugin...
 */
GeneralPlugin infopipe_gp =
{
  NULL,             /* Handle (Filled by XMMS)   */
  NULL,             /* Filename (Filled by XMMS) */
  0,                /* Session ID                */
  infopipe_ver,     /* Description               */
  init_plugin,      /* Init function             */
  show_about,       /* About box                 */
  NULL,             /* Configure                 */
  finalize_plugin   /* Cleanup                   */
};


/***********************************************************/

/*
  XMMS hookup function. This routine is called by XMMS after it dlopen()s
  this library, and it's supposed to return a pointer to GeneralPlugin
  struct.
 */
GeneralPlugin *get_gplugin_info(void) {
  strncpy(infopipe_ver, "InfoPipe ", VERSTRLEN);
  strncat(infopipe_ver, VERSION, VERSTRLEN);

  return &infopipe_gp;
}

/* Pipe handling thread. */
pthread_t pipehandler;

/*
  The function that's called when the plugin is initialized, as specified
  in infopipe_gp structure...
  This will create the pipe special file, then start a thread to handle
  pipe requests.
 */
void init_plugin(void) {

  struct passwd *user_info;

  /* Load configuration. */
  load_config();

  /*
    Handle multiple session names.
    (Changed by WWWWolf - snprintf vs. sprintf, eliminated Yet Another
    Possible Buffer Overflow Sploit =)
   */

  /* Get user's name */
  user_info = getpwuid(geteuid()); /* Note: should not be free()d! */
  user_name = g_strdup(user_info->pw_name);

  /* Formulate FIFO file name. */

  fifo_file =
    g_strdup_printf("%s_%s.%d",
		    FIFO_FILE_PFX,
		    user_name,
		    SESSIONID);

  /* See if the file exists... */
  if(access(fifo_file,F_OK)==0) {
    /* Let's nuke the old pipe that we found. Probably leftovers from old
       session.
    */
    if(unlink(fifo_file)!=0) {
      perror("Unable to remove the old pipe.");
      xmms_quit();
      return;
    }
  }
  
  /* Create the pipe. */
  /* Edited by Shogun, made it readable for other users too,
     handy for PHP/Perl scripts running under a different user ;) */
  /* Ok, cool, I was about to do that change myself, too, due to
     Popular Demand =) - WWWWolf */
  if(mkfifo(fifo_file,0644) != 0) {
    perror("Unable to create a pipe");
    xmms_quit();
  }

  /* Chown the pipe if so desired. */
  if(param.do_chown) {
    if(chown(fifo_file, param.chowntouid, param.chowntogid) != 0) {
      perror("Couldn't chown(), but continuing anyway");
    }
  }

  /* Remove old symlink if it exists, and create a new symlink
     that points to most recent pipe. Yes, this means that the symlink
     always points to the most recently created pipe.

     We handle all errors except
       - "not found", because, duh, if it wasn't there at first place,
       - "permission denied" - if we can't yank the damn link from
         there, someone else probably has a good
         explanation for that, so let's leave it at that...
  */

  if(param.create_symlinks) {
    if(unlink(FIFO_FILE_PFX)!=0 &&
       (errno != ENOENT && errno != EPERM && errno != EACCES) ) {
      /* Oops, we did something wrong. */
      perror("Unable to reasonably remove the symbolic link");
      xmms_quit();
      return;
    } else {
      /* We succeeded. Let's try to create the link. */
      if(symlink(fifo_file,FIFO_FILE_PFX)!=0) {
	perror("Unable to create symbolic link");
	xmms_quit();
	return;    
      }
    }
  }

  /* Create the thread that handles pipe stuff. */
  if(pthread_create(&pipehandler,NULL,
		    (void *) &request_handler_thread,
		    NULL) != 0) {
    perror("Unable the create new thread (ie, no InfoPipe for you!)");
    xmms_quit();
  }

}

/*
  The function that's called when XMMS quits. It will get rid of the thread
  and the special file.
  NOTE: Do we need xmms_remote_quit()s here? After all, we're probably
  *already* quitting!
*/
void finalize_plugin(void) {

  /* Wait for it to finish... even thought it never does that. */
  if(pthread_cancel(pipehandler) != 0) {
    perror("Thread cancel failed");
    xmms_quit();
  }

  /* ...remove the pipe ... even when we never do this either... */
  if(unlink(fifo_file)!=0) {
    perror("Unable to remove the pipe in the cleanup phase");
    xmms_quit();
  }

  /* remove the symlink */
  if(param.delete_symlinks) {
    if(unlink(FIFO_FILE_PFX)!=0) {
      perror("Unable to remove the symlink in the cleanup phase");
      xmms_quit();
    }
  }

  /* Unallocate strings */
  g_free(user_name);
  /* g_free(infopipe_ver); */
  g_free(fifo_file);
}

/*
  This is the thread that runs in background, waiting for reader at the
  InfoPipe and then sending information.

  In 1.1, we use fcntl() instead of waiting 'round, because this seems to be
  the Right Way and apparently more cooler anyway if you get millions
  of hits...
*/
void request_handler_thread(void) {

  fd_set fds;
  FILE *p;  /* the pipe */
  int fd; /* File descriptor for pipe, and its flags. */

  for(;;) {
    /* Open the pipe as file descriptor. */
    /* (O_RDONLY seems to be enough in Linux, but FreeBSDites seemed to
       demand O_RDWR.) */
    fd = open(fifo_file, O_RDWR);
    
    if(fd == -1) {
      perror("xmms_infopipe: Pipe open failed");
      xmms_quit();
    }

    /* Set the file handle to use non-blocking I/O */
    fcntl(fd, F_SETFL, fcntl(fd, F_GETFL) | O_NONBLOCK);

    /* (Thanks to jre for pointing out this can be put to
       the open() call, but regrettably that caused just a
       segmentation fault... This form should work!)
    */

    /* Wait here until we have a reader... */
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    if(select(fd+1, NULL, &fds, NULL, NULL) <= 0)
      break;

    p = fdopen(fd, "w");
    blast_info(p);

    fclose(p);
    close(fd);
    /* Changed to 1 second after request... report if you have problems.
       FIXME: Should use XMMS configfile facility & config dialog???
    */
    sleep(1); /* Umm, or non-blockingness still doesn't work without this!
		 Is there some nicer way of saying this, like "wait
		 until no reader?" select()? */
  }
}

void xmms_quit(void)
{
  xmms_remote_quit(infopipe_gp.xmms_session);
}
