/* $Id: gui-GTK.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <glib.h>
#include "gui-GTK_handlers.h"
#include "gui-GTK_misc.h"

/* main window widgets */
GtkWidget *window_main;
GtkWidget *vbox_main1;
GtkWidget *menu_bar_main;
GtkWidget *vpaned_main;
GtkWidget *vbox_main2;
GtkWidget *hbox_main1;
GtkWidget *hbox_main2;
GtkWidget *button_prevframe;
GtkWidget *arrow_prevframe;
GtkWidget *label_framenumber;
GtkWidget *button_nextframe;
GtkWidget *arrow_nextframe;
GtkWidget *hbox_maindatasize;
GtkWidget *label_datasize;
GtkWidget *edit_datasize;
GtkWidget *scroll_tables;
GtkWidget *hpaned_tables;
GtkWidget *table_hex;
GtkWidget *table_ascii;
GtkWidget *hbox_main3;
GtkWidget *label_bin;
GtkWidget *table_bin;
GtkWidget *label_dec;
GtkWidget *table_dec;
GtkWidget *vbox_main3;
GtkWidget *hbox_main4;
GtkWidget *hbox_main5;
GtkWidget *hbox_main6;
GtkWidget *hbox_main7;
GtkWidget *button_addeth;
GtkWidget *button_addcrc;
GtkWidget *button_addip;
GtkWidget *button_addipcksum;
GtkWidget *button_addipx;
GtkWidget *button_addspx;
GtkWidget *button_addudp;
GtkWidget *button_addtcp;
GtkWidget *button_addudpcksum;
GtkWidget *button_addtcpcksum;
GtkWidget *progressbar_doing;
GtkWidget *button_addframe;
GtkWidget *button_deleteframe;
GtkWidget *button_removeframes;
GtkWidget *button_send;

GList *list_cells_hex;
GList *list_cells_ascii;
GList *list_cells_number;

/* return: TRUE when yes, FALSE when no */
int question_dialog(char *text) {
    GtkWidget *question_window;
    int answer;

    question_window = gtk_message_dialog_new(GTK_WINDOW(window_main),
                                    GTK_DIALOG_DESTROY_WITH_PARENT,
                                    GTK_MESSAGE_QUESTION,
                                    GTK_BUTTONS_YES_NO,
                                    text);
    answer = (gtk_dialog_run(GTK_DIALOG(question_window)) == GTK_RESPONSE_YES);
    gtk_widget_destroy(question_window);
    return answer;
}

/* Rewrite label with number of frames */
void fill_frame_number() {
    char *text;

    text = malloc(32);
    sprintf(text, _("Frame %i/%i"), selected_frame + 1, g_list_length(all_frames));
    gtk_label_set_text(GTK_LABEL(label_framenumber), text);
    free(text);
}

/* Remove last cells from hex and ascii tables */
void remove_cells_from_tables() {
    GtkWidget *cell;
    guint i, row_height, rows, startfrom;
    GtkAdjustment *adjustment;
    GdkColor color;

    adjustment = gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*)scroll_tables);
    row_height = adjustment->upper / ceil(g_list_length(list_cells_hex) / 16);
    gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, 0);
    gtk_widget_show(progressbar_doing);
    startfrom = g_list_length(list_cells_hex);
    for (i = g_list_length(list_cells_hex); i > frame->len; i--) {
    	cell = g_list_last(list_cells_hex)->data;
	gtk_widget_destroy(cell);
	list_cells_hex = g_list_remove(list_cells_hex, cell);
	cell = g_list_last(list_cells_ascii)->data;
	gtk_widget_destroy(cell);
	list_cells_ascii = g_list_remove(list_cells_ascii, cell);
	if (((i - 1) % 16) == 0) {
	    cell = g_list_last(list_cells_number)->data;
	    gtk_widget_destroy(cell);
	    list_cells_number = g_list_remove(list_cells_number, cell);
	}
	gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, (double) (startfrom - i) / (double) (startfrom - frame->len));
	gtk_main_iteration_do(FALSE);
	gtk_main_iteration_do(FALSE);
	gtk_main_iteration_do(FALSE);
	gtk_main_iteration_do(FALSE);
	gtk_main_iteration_do(FALSE);
	gtk_main_iteration_do(FALSE);
    }
    if (selected_byte >= frame->len)
	selected_byte = frame->len - 1;
    rows = ceil(frame->len / 16);
    if (rows == 0)
	rows++;
    gtk_table_resize(GTK_TABLE(table_hex), rows, 20);
    gtk_table_resize(GTK_TABLE(table_ascii), rows, 16);
    if (frame->len > 0) {
        color.red = color.green = 0xFFFF;
	color.blue = 0;
        gtk_widget_modify_base(g_list_nth(list_cells_hex, selected_byte)->data, GTK_STATE_NORMAL, &color);
	gtk_widget_modify_base(g_list_nth(list_cells_ascii, selected_byte)->data, GTK_STATE_NORMAL, &color);
    }
    gtk_widget_hide(progressbar_doing);
}

/* Fill hex and ascii cells for one byte of data
   Input:
   number - number of byte */
void fill_one_byte_cells(int number) {
    GtkWidget *cell;
    GdkColor *color;
    char *ascii_text, *utf_text;

    /* kolor komrki */
    color = color_of_cell(number);
    if (number == selected_byte) {
	color->red = color->green = 0xFFFF;
	color->blue = 0;
    }

    /* find hex cell */
    cell = g_list_nth_data(list_cells_hex, number);
    /* convert to hex data and print */
    ascii_text = int2hex(frame->data[number]);
    gtk_entry_set_text(GTK_ENTRY(cell), ascii_text);
    gtk_widget_modify_base(cell, GTK_STATE_NORMAL, color);
    free(ascii_text);

    /* find ascii cell */
    cell = g_list_nth_data(list_cells_ascii, number);
    /* convert to utf data and print */
    ascii_text = malloc(2);
    ascii_text[0] = frame->data[number];
    ascii_text[1] = 0;
    utf_text = ascii2utf(ascii_text);
    gtk_entry_set_text(GTK_ENTRY(cell), utf_text);
    gtk_widget_modify_base(cell, GTK_STATE_NORMAL, color);
    free(color);
    free(ascii_text);
    free(utf_text);
}

/* Sets default background color for cell
   Input:
   number - number of byte */
void set_default_color_for_cell(int number) {
    GtkWidget *cell;
    
    /* find hex cell */
    cell = g_list_nth_data(list_cells_hex, number);
    gtk_widget_modify_base(cell, GTK_STATE_NORMAL, &color_default);

    /* find ascii cell */
    cell = g_list_nth_data(list_cells_ascii, number);
    gtk_widget_modify_base(cell, GTK_STATE_NORMAL, &color_default);
}

/* add cells for next byte */
void add_one_byte_cells(int number) {
    GtkWidget *cell;
    char *ascii_text, *utf_text;
    GdkColor *color;

    /* kolor komrki */
    color = color_of_cell(number);

    /* create and fill hex cell */
    cell = gtk_entry_new();
    list_cells_hex = g_list_append(list_cells_hex, cell);
    gtk_entry_set_max_length(GTK_ENTRY(cell), 2);
    gtk_entry_set_width_chars(GTK_ENTRY(cell), 2);
    ascii_text = int2hex(frame->data[number]);
    gtk_entry_set_text(GTK_ENTRY(cell), ascii_text);
    free(ascii_text);
    gtk_entry_set_has_frame(GTK_ENTRY(cell), FALSE);
    g_signal_connect(G_OBJECT(cell), "key-press-event", G_CALLBACK(cell_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(cell), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    g_signal_connect(G_OBJECT(cell), "focus-in-event", G_CALLBACK(cell_hex_focusin), NULL);
    g_signal_connect(G_OBJECT(cell), "focus-out-event", G_CALLBACK(cell_hex_focusout), NULL);
    gtk_table_attach(GTK_TABLE(table_hex), cell, number%16 + 4, (number%16)+5, number/16,
    	    (number/16)+1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
    gtk_widget_modify_base(cell, GTK_STATE_NORMAL, color);
    gtk_widget_show(cell);

    /* create and fill ascii cell */
    cell = gtk_entry_new();
    list_cells_ascii = g_list_append(list_cells_ascii, cell);
    gtk_entry_set_max_length(GTK_ENTRY(cell), 1);
    gtk_entry_set_width_chars(GTK_ENTRY(cell), 1);
    /* convert to utf data */
    ascii_text = malloc(2);
    ascii_text[0] = frame->data[number];
    ascii_text[1] = 0;
    utf_text = ascii2utf(ascii_text);
    gtk_entry_set_text(GTK_ENTRY(cell), utf_text);
    free(ascii_text);
    free(utf_text);
    gtk_entry_set_has_frame(GTK_ENTRY(cell), FALSE);
    g_signal_connect(G_OBJECT(cell), "key-press-event", G_CALLBACK(cell_ascii_keypress), NULL);
    g_signal_connect(G_OBJECT(cell), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    g_signal_connect(G_OBJECT(cell), "focus-in-event", G_CALLBACK(cell_ascii_focusin), NULL);
    g_signal_connect(G_OBJECT(cell), "focus-out-event", G_CALLBACK(cell_ascii_focusout), NULL);
    gtk_table_attach(GTK_TABLE(table_ascii), cell, number%16, (number%16)+1, number/16,
	    (number/16)+1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
    gtk_widget_modify_base(cell, GTK_STATE_NORMAL, color);
    gtk_widget_show(cell);

    if ((number % 16) == 0) {
	cell = gtk_entry_new();
	list_cells_number = g_list_append(list_cells_number, cell);
	gtk_entry_set_max_length(GTK_ENTRY(cell), 6);
	gtk_entry_set_width_chars(GTK_ENTRY(cell), 6);
	gtk_entry_set_has_frame(GTK_ENTRY(cell), FALSE);
	g_signal_connect(G_OBJECT(cell), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
	gtk_editable_set_editable((GtkEditable*) cell, FALSE);
	GTK_WIDGET_UNSET_FLAGS(cell, GTK_CAN_FOCUS);
	gtk_entry_set_alignment(GTK_ENTRY(cell), 1);
	ascii_text = malloc(6);
	sprintf(ascii_text, "%i", number);
	gtk_entry_set_text(GTK_ENTRY(cell), ascii_text);
	free(ascii_text);
	gtk_table_attach(GTK_TABLE(table_hex), cell, 0, 3, number/16,
		(number/16)+1, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
	gtk_widget_show(cell);
    }
    free(color);
}

/* Add new cells to hex and ascii tables */
void add_cells_to_tables() {
    guint i, cells;

    i = g_list_length(list_cells_hex);
    cells = frame->len - i;
    if (cells > 10) {
	gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, 0);
	gtk_widget_show(progressbar_doing);
    }
    for (; i < frame->len; i++) {
	add_one_byte_cells(i);
	gtk_main_iteration_do(FALSE);
	if (cells > 10) {
	    gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, (double) (i + cells - frame->len) / (double) cells);
	    gtk_main_iteration_do(FALSE);
	    gtk_main_iteration_do(FALSE);
	    gtk_main_iteration_do(FALSE);
	    gtk_main_iteration_do(FALSE);
	    gtk_main_iteration_do(FALSE);
	    gtk_main_iteration_do(FALSE);
	}
    }
    if (selected_byte == 0)
	gtk_widget_grab_focus(list_cells_hex->data);
    gtk_widget_hide(progressbar_doing);
}

/* Wypenij cae tabele */
void fill_tables() {
    int i, max;

    /* wypenij istniejce komrki */
    max = ((frame->len < g_list_length(list_cells_hex))?frame->len:g_list_length(list_cells_hex));
    if (max > 10) {
	gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, 0);
	gtk_widget_show(progressbar_doing);
    }
    for (i = 0; i < max; i++) {
	fill_one_byte_cells(i);
	gtk_main_iteration_do(FALSE);
	if (max > 10)
	    gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, (double) i / (double) max);
    }
    gtk_widget_hide(progressbar_doing);

    /* usu/dodaj nastpne komrki */
    if (frame->len > g_list_length(list_cells_hex))
	add_cells_to_tables();
    else
	remove_cells_from_tables();
}

/* Fill binary cell
   extern selected_byte - number of byte from data  */
void fill_binary() {
    char *ascii;
    ascii = int2bin(frame->data[selected_byte]);
    gtk_entry_set_text(GTK_ENTRY(table_bin), ascii);
    free(ascii);
}

/* Fill decimal cell
   extern selected_byte - number of byte from data  */
void fill_decimal() {
    char *ascii;
    ascii = int2dec(frame->data[selected_byte]);
    gtk_entry_set_text(GTK_ENTRY(table_dec), ascii);
    free(ascii);
}

/* Fill datalen cell
   extern frame_len - bytes in frame */
void fill_datasize() {
    gtk_spin_button_set_value((GtkSpinButton*) edit_datasize, frame->len);
}

/* Create menu for main window */
GtkWidget* create_menu() {
    GtkWidget *menu_bar, *menu_bar_item;
    GtkWidget *main_menu, *main_menu_item;

    /* Create menubar */
    menu_bar = gtk_menu_bar_new();
    gtk_widget_show(menu_bar);

    /* Main menu "File" */
    menu_bar_item = gtk_menu_item_new_with_mnemonic(_("_File"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar), menu_bar_item);
    gtk_widget_show(menu_bar_item);
    main_menu = gtk_menu_new();
    gtk_menu_set_title(GTK_MENU(main_menu), _("File"));
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_bar_item), main_menu);
    gtk_widget_show(main_menu);

    /* Menu "New" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_New"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_file_new), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu -separator- */
    main_menu_item = gtk_separator_menu_item_new();
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    gtk_widget_show(main_menu_item);

    /* Menu "Open" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_Open"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_file_open), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "Save" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_Save"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_file_save), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "Save as" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("Save _As"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_file_saveas), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu -separator- */
    main_menu_item = gtk_separator_menu_item_new();
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    gtk_widget_show(main_menu_item);

    /* Menu "Exit" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_Quit"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_file_exit), NULL);
    gtk_widget_show(main_menu_item);

    /* Main menu "Add" */
    menu_bar_item = gtk_menu_item_new_with_mnemonic(_("_Add"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar), menu_bar_item);
    gtk_widget_show(menu_bar_item);
    main_menu = gtk_menu_new();
    gtk_menu_set_title(GTK_MENU(main_menu), _("Add"));
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_bar_item), main_menu);
    gtk_widget_show(main_menu);

    /* Menu "Ethernet Header" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_Ethernet header"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_eth), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "FCS" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_FCS"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_crc), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu -separator- */
    main_menu_item = gtk_separator_menu_item_new();
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    gtk_widget_show(main_menu_item);

    /* Menu "IP Header" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_IP header"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_ip), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "IP Checksum" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("IP _checksum"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_ipcksum), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "IPX Header" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("IP_X header"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_ipx), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu -separator- */
    main_menu_item = gtk_separator_menu_item_new();
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    gtk_widget_show(main_menu_item);

    /* Menu "TCP Header" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_TCP header"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_tcp), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "TCP Checksum" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("TCP c_hecksum"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_tcpcksum), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "UDP Header" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_UDP header"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_udp), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "UDP Checksum" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("UDP chec_ksum"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_udpcksum), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "SPX Header" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_SPX header"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_add_spx), NULL);
    gtk_widget_show(main_menu_item);

    /* Main menu "Ramki" */
    menu_bar_item = gtk_menu_item_new_with_mnemonic(_("F_rames"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar), menu_bar_item);
    gtk_widget_show(menu_bar_item);
    main_menu = gtk_menu_new();
    gtk_menu_set_title(GTK_MENU(main_menu), _("Frames"));
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_bar_item), main_menu);
    gtk_widget_show(main_menu);

    /* Menu "Dodaj now" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("Add _new"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_frames_add), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "Usu wybran" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_Delete chosen"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_frames_delete), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "Usu wszystkie" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("Delete _all"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_frames_remove), NULL);
    gtk_widget_show(main_menu_item);

    /* Menu "Wylij" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_Send"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_frames_send), NULL);
    gtk_widget_show(main_menu_item);

    /* Main menu "Help" */
    menu_bar_item = gtk_menu_item_new_with_mnemonic(_("_Help"));
    gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar), menu_bar_item);
    gtk_widget_show(menu_bar_item);
    main_menu = gtk_menu_new();
    gtk_menu_set_title(GTK_MENU(main_menu), _("Help"));
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_bar_item), main_menu);
    gtk_widget_show(main_menu);

    /* Menu "About" */
    main_menu_item = gtk_menu_item_new_with_mnemonic(_("_About ANT"));
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), main_menu_item);
    g_signal_connect(G_OBJECT(main_menu_item), "activate", G_CALLBACK(menu_help_about), NULL);
    gtk_widget_show(main_menu_item);

    return menu_bar;
}

/* Create main window */
void create_main_window() {

    /* create main window*/
    window_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_name (window_main, "ant_window");
    gtk_window_set_title (GTK_WINDOW(window_main), _("ANT"));
    gtk_window_set_default_size(GTK_WINDOW(window_main), 600, 400);

    g_signal_connect (G_OBJECT(window_main), "delete_event", G_CALLBACK(delete_event), NULL);

    /* insert widgets into main window */
    vbox_main1 = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER(window_main), vbox_main1);

    menu_bar_main = create_menu ();
    gtk_box_pack_start (GTK_BOX(vbox_main1), menu_bar_main, FALSE, TRUE, 0);

    /* paned */
    vpaned_main = gtk_vpaned_new ();
    gtk_box_pack_start (GTK_BOX(vbox_main1), vpaned_main, TRUE, TRUE, 0);

    /* vbox */
    vbox_main2 = gtk_vbox_new (FALSE, 0);
    gtk_paned_pack1 (GTK_PANED(vpaned_main), vbox_main2, TRUE, FALSE);

    /* hbox */
    hbox_main1 = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox_main2), hbox_main1, FALSE, FALSE, 0);

    hbox_main2 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_main1), hbox_main2, FALSE, FALSE, 0);

    /* prev frame button */
    button_prevframe = gtk_button_new();
    arrow_prevframe = gtk_arrow_new(GTK_ARROW_LEFT, GTK_SHADOW_NONE);
    gtk_container_add(GTK_CONTAINER(button_prevframe), arrow_prevframe);
    g_signal_connect(G_OBJECT(button_prevframe), "clicked", G_CALLBACK(buttonprevframe_clicked), NULL);
    gtk_box_pack_start(GTK_BOX(hbox_main2), button_prevframe, FALSE, FALSE, 0);

    /* number of frame label */
    label_framenumber = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(hbox_main2), label_framenumber, FALSE, FALSE, 0);

    /* next frame button */
    button_nextframe = gtk_button_new();
    arrow_nextframe = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_OUT);
    gtk_container_add(GTK_CONTAINER(button_nextframe), arrow_nextframe);
    g_signal_connect(G_OBJECT(button_nextframe), "clicked", G_CALLBACK(buttonnextframe_clicked), NULL);
    gtk_box_pack_start(GTK_BOX(hbox_main2), button_nextframe, FALSE, FALSE, 0);

    /* hbox */
    hbox_maindatasize = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_main1), hbox_maindatasize, FALSE, FALSE, 0);

    label_bin = gtk_label_new(_("Frame size"));

    edit_datasize = gtk_spin_button_new_with_range(1, 10000, 1);
    gtk_spin_button_set_numeric((GtkSpinButton*) edit_datasize, TRUE);
    gtk_entry_set_max_length(GTK_ENTRY(edit_datasize), 4);
    gtk_entry_set_width_chars(GTK_ENTRY(edit_datasize), 4);
    gtk_entry_set_alignment(GTK_ENTRY(edit_datasize), 1);
    g_signal_connect(G_OBJECT(edit_datasize), "value-changed", G_CALLBACK(datasize_changed), NULL);
    g_signal_connect(G_OBJECT(edit_datasize), "key-press-event", G_CALLBACK(datasize_keypress), NULL);
    g_signal_connect(G_OBJECT(edit_datasize), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_box_pack_end (GTK_BOX(hbox_maindatasize), edit_datasize, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(hbox_maindatasize), label_bin, FALSE, FALSE, 5);

    /* scrolled window */
    scroll_tables = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scroll_tables), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW(scroll_tables), GTK_SHADOW_OUT);
    gtk_box_pack_start (GTK_BOX(vbox_main2), scroll_tables, TRUE, TRUE, 0);

    hpaned_tables = gtk_hpaned_new ();
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scroll_tables), hpaned_tables);

    table_hex = gtk_table_new (0, 20, TRUE);
    gtk_table_set_row_spacings (GTK_TABLE(table_hex), 0);
    gtk_paned_pack1 (GTK_PANED(hpaned_tables), table_hex, TRUE, FALSE);

    table_ascii = gtk_table_new (0, 16, TRUE);
    gtk_table_set_row_spacings (GTK_TABLE(table_ascii), 0);
    gtk_paned_pack2 (GTK_PANED(hpaned_tables), table_ascii, TRUE, FALSE);

    hbox_main3 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox_main2), hbox_main3, FALSE, TRUE, 0);

    label_bin = gtk_label_new(_("Binary"));
    gtk_box_pack_start(GTK_BOX(hbox_main3), label_bin, FALSE, FALSE, 5);

    table_bin = gtk_entry_new ();
    gtk_entry_set_max_length(GTK_ENTRY(table_bin), 8);
    gtk_entry_set_width_chars(GTK_ENTRY(table_bin), 8);
    g_signal_connect(G_OBJECT(table_bin), "key-press-event", G_CALLBACK(cell_bin_keypress), NULL);
    g_signal_connect(G_OBJECT(table_bin), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    g_signal_connect(G_OBJECT(table_bin), "focus-out-event", G_CALLBACK(cell_bin_focusout), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main3), table_bin, FALSE, FALSE, 0);

    label_dec = gtk_label_new(_("Decimal"));
    gtk_box_pack_start(GTK_BOX(hbox_main3), label_dec, FALSE, FALSE, 5);

    table_dec = gtk_entry_new ();
    gtk_entry_set_max_length(GTK_ENTRY(table_dec), 3);
    gtk_entry_set_width_chars(GTK_ENTRY(table_dec), 3);
    gtk_entry_set_alignment(GTK_ENTRY(table_dec), 1);
    g_signal_connect(G_OBJECT(table_dec), "key-press-event", G_CALLBACK(cell_dec_keypress), NULL);
    g_signal_connect(G_OBJECT(table_dec), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    g_signal_connect(G_OBJECT(table_dec), "focus-out-event", G_CALLBACK(cell_dec_focusout), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main3), table_dec, FALSE, FALSE, 0);

    progressbar_doing = gtk_progress_bar_new();
    gtk_progress_bar_set_fraction((GtkProgressBar*)progressbar_doing, 0);
    gtk_box_pack_end(GTK_BOX(hbox_main3), progressbar_doing, FALSE, TRUE, 0);

    vbox_main3 = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox_main2), vbox_main3, FALSE, TRUE, 0);

    hbox_main7 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox_main3), hbox_main7, FALSE, TRUE, 0);

    button_addframe = gtk_button_new_with_label (_("Add frame"));
    g_signal_connect(G_OBJECT(button_addframe), "clicked", G_CALLBACK(buttonaddframe_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main7), button_addframe, FALSE, TRUE, 0);

    button_deleteframe = gtk_button_new_with_label (_("Delete frame"));
    g_signal_connect(G_OBJECT(button_deleteframe), "clicked", G_CALLBACK(buttondeleteframe_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main7), button_deleteframe, FALSE, TRUE, 0);

    button_removeframes = gtk_button_new_with_label (_("Delete all frames"));
    g_signal_connect(G_OBJECT(button_removeframes), "clicked", G_CALLBACK(buttonremoveframes_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main7), button_removeframes, FALSE, TRUE, 0);

    button_send = gtk_button_new_with_label (_("Send"));
    g_signal_connect(G_OBJECT(button_send), "clicked", G_CALLBACK(buttonsend_clicked), NULL);
    gtk_box_pack_end (GTK_BOX(hbox_main7), button_send, FALSE, TRUE, 0);


    hbox_main4 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox_main3), hbox_main4, FALSE, TRUE, 0);

    button_addeth = gtk_button_new_with_label (_("Add Ethernet header"));
    gtk_widget_modify_bg(button_addeth, GTK_STATE_NORMAL, &color_eth);
    g_signal_connect(G_OBJECT(button_addeth), "clicked", G_CALLBACK(buttonaddeth_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main4), button_addeth, FALSE, TRUE, 0);

    button_addip = gtk_button_new_with_label (_("Add IP header"));
    gtk_widget_modify_bg(button_addip, GTK_STATE_NORMAL, &color_ip);
    g_signal_connect(G_OBJECT(button_addip), "clicked", G_CALLBACK(buttonaddip_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main4), button_addip, FALSE, TRUE, 0);

    button_addtcp = gtk_button_new_with_label (_("Add TCP header"));
    gtk_widget_modify_bg(button_addtcp, GTK_STATE_NORMAL, &color_tcp);
    g_signal_connect(G_OBJECT(button_addtcp), "clicked", G_CALLBACK(buttonaddtcp_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main4), button_addtcp, FALSE, TRUE, 0);

    button_addudp = gtk_button_new_with_label (_("Add UDP header"));
    gtk_widget_modify_bg(button_addudp, GTK_STATE_NORMAL, &color_udp);
    g_signal_connect(G_OBJECT(button_addudp), "clicked", G_CALLBACK(buttonaddudp_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main4), button_addudp, FALSE, TRUE, 0);

    hbox_main5 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox_main3), hbox_main5, FALSE, TRUE, 0);

    button_addcrc = gtk_button_new_with_label (_("Add FCS"));
    gtk_widget_modify_bg(button_addcrc, GTK_STATE_NORMAL, &color_fcs);
    g_signal_connect(G_OBJECT(button_addcrc), "clicked", G_CALLBACK(buttonaddcrc_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main5), button_addcrc, FALSE, TRUE, 0);
    
    button_addipcksum = gtk_button_new_with_label (_("Add IP checksum"));
    gtk_widget_modify_bg(button_addipcksum, GTK_STATE_NORMAL, &color_ip);
    g_signal_connect(G_OBJECT(button_addipcksum), "clicked", G_CALLBACK(buttonaddipcksum_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main5), button_addipcksum, FALSE, TRUE, 0);

    button_addtcpcksum = gtk_button_new_with_label (_("Add TCP checksum"));
    gtk_widget_modify_bg(button_addtcpcksum, GTK_STATE_NORMAL, &color_tcp);
    g_signal_connect(G_OBJECT(button_addtcpcksum), "clicked", G_CALLBACK(buttonaddtcpcksum_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main5), button_addtcpcksum, FALSE, TRUE, 0);

    button_addudpcksum = gtk_button_new_with_label (_("Add UDP checksum"));
    gtk_widget_modify_bg(button_addudpcksum, GTK_STATE_NORMAL, &color_udp);
    g_signal_connect(G_OBJECT(button_addudpcksum), "clicked", G_CALLBACK(buttonaddudpcksum_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main5), button_addudpcksum, FALSE, TRUE, 0);

    hbox_main6 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX(vbox_main3), hbox_main6, FALSE, TRUE, 0);

    button_addipx = gtk_button_new_with_label (_("Add IPX header"));
    gtk_widget_modify_bg(button_addipx, GTK_STATE_NORMAL, &color_ipx);
    g_signal_connect(G_OBJECT(button_addipx), "clicked", G_CALLBACK(buttonaddipx_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main6), button_addipx, FALSE, TRUE, 0);

    button_addspx = gtk_button_new_with_label (_("Add SPX header"));
    gtk_widget_modify_bg(button_addspx, GTK_STATE_NORMAL, &color_spx);
    g_signal_connect(G_OBJECT(button_addspx), "clicked", G_CALLBACK(buttonaddspx_clicked), NULL);
    gtk_box_pack_start (GTK_BOX(hbox_main6), button_addspx, FALSE, TRUE, 0);

    /* show widgets */
    gtk_widget_show_all (window_main);
}
