/* $Id: gui-GTK_ipx-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *ipx_dialog_window;
GtkWidget *ipx_dialog_label1;
GtkWidget *ipx_dialog_hbox1;
GtkWidget *ipx_dialog_checkcsum;
GtkWidget *ipx_dialog_csum;
GtkWidget *ipx_dialog_hbox2;
GtkWidget *ipx_dialog_checkplen;
GtkWidget *ipx_dialog_plen;
GtkWidget *ipx_dialog_hbox3;
GtkWidget *ipx_dialog_checktcontrol;
GtkWidget *ipx_dialog_tcontrol;
GtkWidget *ipx_dialog_hbox4;
GtkWidget *ipx_dialog_checktype;
GtkWidget *ipx_dialog_combotype;
GtkWidget *ipx_dialog_type;
GtkWidget *ipx_dialog_hbox5;
GtkWidget *ipx_dialog_checkdestnet;
GtkWidget *ipx_dialog_destnet;
GtkWidget *ipx_dialog_hbox6;
GtkWidget *ipx_dialog_checkdestnode;
GtkWidget *ipx_dialog_destnode;
GtkWidget *ipx_dialog_hbox7;
GtkWidget *ipx_dialog_checkdestsock;
GtkWidget *ipx_dialog_combodestsock;
GtkWidget *ipx_dialog_destsock;
GtkWidget *ipx_dialog_hbox8;
GtkWidget *ipx_dialog_checksrcnet;
GtkWidget *ipx_dialog_srcnet;
GtkWidget *ipx_dialog_hbox9;
GtkWidget *ipx_dialog_checksrcnode;
GtkWidget *ipx_dialog_combosrcnode;
GtkWidget *ipx_dialog_srcnode;
GtkWidget *ipx_dialog_hbox10;
GtkWidget *ipx_dialog_checksrcsock;
GtkWidget *ipx_dialog_combosrcsock;
GtkWidget *ipx_dialog_srcsock;

GtkWidget *ipx_dialog_label2;
GtkWidget *ipx_dialog_hbox11;
GtkWidget *ipx_dialog_radioatipx;
GtkWidget *ipx_dialog_radioatcursor;

GtkWidget *ipx_dialog_buttonget;

/* 00 - unknown
   01 - RIP, Routing Information Packet
   02 - Echo Packet
   03 - Error Packet
   04 - PEP, Packet Exchange Protocol
   05 - SPX, Sequence Packet Protocol
   11 - NCP, NetWare Core Protocol
*/
char* table_ipx_types[] = { N_("00 - unknown"),
			    N_("05 - SPX"), NULL};

/* 0001 - RIP, Routing Information Packet
   0002 - Echo Protocol Packet
   0003 - Error Handling Packet
   0451 - NCP, NetWare Core Protocol
   0452 - SAP, Service Advertising Protocol
   0453 - RIP, Routing Information Protocol
   0455 - NetBIOS
   0456 - Diagnostic
   0457 - Serialisation
   0BB8 - Xerox registered
   0BB9 - Dynamically Assigned
   8060 - IPX
   9091 - TCP over IPXF
   9092 - UDP over IPXF
   9093 - IPXF, IPX Fragmentation Protocol
*/
char* table_ipx_sockets[] = { N_("0451 - NetWare Core Protocol"),
			      N_("0452 - Service Advertising Protocol"),
			      N_("0453 - Routing Information Protocol"),
			      N_("0454 - NetBIOS"),
			      N_("0456 - Diagnostics"), NULL};

void ipx_dialog_checkcsum_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_csum, gtk_toggle_button_get_active(widget));
}

void ipx_dialog_checkplen_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_plen, gtk_toggle_button_get_active(widget));
}

void ipx_dialog_checktcontrol_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_tcontrol, gtk_toggle_button_get_active(widget));
}

void ipx_dialog_checktype_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ipx_dialog_combotype, active);
    gtk_widget_set_sensitive(ipx_dialog_type, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combotype)) == 0));
}

void ipx_dialog_combotype_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_type,
    		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combotype)) == 0));
}

void ipx_dialog_checkdestnet_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_destnet, gtk_toggle_button_get_active(widget));
}

void ipx_dialog_checkdestnode_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_destnode, gtk_toggle_button_get_active(widget));
}

void ipx_dialog_checkdestsock_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ipx_dialog_combodestsock, active);
    gtk_widget_set_sensitive(ipx_dialog_destsock, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combodestsock)) == 0));
}

void ipx_dialog_combodestsock_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_destsock,
    		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combodestsock)) == 0));
}

void ipx_dialog_checksrcnet_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_srcnet, gtk_toggle_button_get_active(widget));
}

void ipx_dialog_checksrcnode_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ipx_dialog_combosrcnode, active);
    gtk_widget_set_sensitive(ipx_dialog_srcnode, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combosrcnode)) == 0));
}

void ipx_dialog_combosrcnode_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_srcnode,
    		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combosrcnode)) == 0));
}

void ipx_dialog_checksrcsock_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ipx_dialog_combosrcsock, active);
    gtk_widget_set_sensitive(ipx_dialog_srcsock, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combosrcsock)) == 0));
}

void ipx_dialog_combosrcsock_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ipx_dialog_srcsock,
    		(gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combosrcsock)) == 0));
}

gboolean ipx_dialog_hex_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    gint sel_start, sel_end;
    gboolean selection;

    /* allow for 'left' 'right' 'up' 'down' 'tab' 'home' 'end' key presses */
    if ((event->keyval == GDK_Right) || (event->keyval == GDK_Left) ||
	(event->keyval == GDK_Up) || (event->keyval == GDK_Down) ||
        (event->keyval == GDK_Home) || (event->keyval == GDK_End) ||
        (event->keyval == GDK_Tab))
        return FALSE;

    /* backspace - change cursor position */
    if (event->keyval == GDK_BackSpace) {
        gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
        if (sel_start > 0) {
	    sel_start = sel_start - 1 - ((sel_start % 5) == 0);
            gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + 1);
	}
    }

    if (((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) ||
        ((event->keyval >= GDK_a) && (event->keyval <= GDK_f)) ||
        ((event->keyval >= GDK_A) && (event->keyval <= GDK_F))) {
        selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
        if (((sel_start + 1) % 5) == 0)
            sel_start++;
        gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + 1);
        return FALSE;
    }
    return TRUE;        /* don't do anything when other key pressed */
}

void ipx_dialog_hex_changed(GtkWidget *widget, gpointer data) {
    gtk_entry_set_text((GtkEntry*) widget, g_ascii_strup(gtk_entry_get_text((GtkEntry*) widget), -1));
}
																	
void ipx_dialog_buttonget_clicked(GtkWidget *widget, gpointer data) {
    int i;
    char *text, *text2;
    int position = 0;

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_radioatipx))
	position = 14;

    /* set checksum */
    if (frame->len > position + 1) {
	text = malloc(5);
        for (i = 0; i < 2; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2]), text2, 2);
	    free(text2);
        }
        text[4] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_csum, text);
	free(text);
    }

    /* set packet len */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ipx_dialog_plen),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set transport control */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ipx_dialog_tcontrol), frame->data[position++]);

    /* set type */
    if (frame->len > position) {
        text = int2hex(frame->data[position++]);
        gtk_entry_set_text((GtkEntry*) ipx_dialog_type, text);
	gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combotype, 0);
	gtk_widget_set_sensitive(ipx_dialog_type, gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checktype));
        free(text);
    }

    /* set destination network */
    if (frame->len > position + 3) {
	text = malloc(10);
        for (i = 0; i < 4; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2 + (i / 2)]), text2, 2);
	    free(text2);
        }
	text[4] = ' ';
        text[9] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_destnet, text);
	free(text);
    }

    /* set destination node */
    if (frame->len > position + 5) {
	text = malloc(15);
        for (i = 0; i < 6; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2 + (i / 2)]), text2, 2);
	    free(text2);
        }
	text[4] = text[9] = ' ';
        text[14] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_destnode, text);
	free(text);
    }

    /* set destination socket */
    if (frame->len > position + 1) {
        text = malloc(5);
        for (i = 0; i < 2; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2]), text2, 2);
	    free(text2);
        }
        text[4] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_destsock, text);
	free(text);
	gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combodestsock, 0);
	gtk_widget_set_sensitive(ipx_dialog_destsock, gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checkdestsock));
    }

    /* set source network */
    if (frame->len > position + 3) {
        text = malloc(10);
        for (i = 0; i < 4; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2 + (i / 2)]), text2, 2);
	    free(text2);
        }
	text[4] = ' ';
        text[9] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_srcnet, text);
	free(text);
    }

    /* set source node */
    if (frame->len > position + 5) {
        text = malloc(15);
        for (i = 0; i < 6; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2 + (i / 2)]), text2, 2);
	    free(text2);
        }
	text[4] = text[9] = ' ';
        text[14] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_srcnode, text);
	free(text);
	gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combosrcnode, 0);
	gtk_widget_set_sensitive(ipx_dialog_srcnode, gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checksrcnode));
    }

    /* set source socket */
    if (frame->len > position + 1) {
        text = malloc(5);
        for (i = 0; i < 2; i++) {
            text2 = int2hex(frame->data[position++]);
            strncpy(&(text[i * 2]), text2, 2);
	    free(text2);
        }
        text[4] = 0;
        gtk_entry_set_text((GtkEntry*) ipx_dialog_srcsock, text);
	free(text);
	gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combosrcsock, 0);
	gtk_widget_set_sensitive(ipx_dialog_srcsock, gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checksrcsock));
    }
}

void ipx_dialog_create() {
    int value, selected;
    char *text;

    ipx_dialog_window = gtk_dialog_new_with_buttons(_("Add IPX header"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    NULL);
    ipx_dialog_buttonget = gtk_button_new_with_label(_("Get values from frame"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->action_area), ipx_dialog_buttonget, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_buttonget), "clicked", G_CALLBACK(ipx_dialog_buttonget_clicked), NULL);
    gtk_dialog_add_button(GTK_DIALOG(ipx_dialog_window), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);

    ipx_dialog_label1 = gtk_label_new(_("Create header containing"));

    ipx_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checkcsum = gtk_check_button_new_with_label(_("checksum"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checkcsum, TRUE);
    ipx_dialog_csum = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_csum), 4);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_csum), 4);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_csum), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_csum), "FFFF");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox1), ipx_dialog_checkcsum, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox1), ipx_dialog_csum, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_csum), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_csum), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checkcsum), "toggled", G_CALLBACK(ipx_dialog_checkcsum_toggled), NULL);

    ipx_dialog_hbox2 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checkplen = gtk_check_button_new_with_label(_("packet length"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checkplen, TRUE);
    ipx_dialog_plen = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ipx_dialog_plen), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_plen), 1);
    value = frame->len - 14;
    if (value < 30)
	value = 30;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ipx_dialog_plen), value);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox2), ipx_dialog_checkplen, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox2), ipx_dialog_plen, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_checkplen), "toggled", G_CALLBACK(ipx_dialog_checkplen_toggled), NULL);

    ipx_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checktcontrol = gtk_check_button_new_with_label(_("transport control"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checktcontrol, TRUE);
    ipx_dialog_tcontrol = gtk_spin_button_new_with_range(0, 255, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ipx_dialog_tcontrol), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ipx_dialog_tcontrol), 0);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_tcontrol), 3);
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_tcontrol), 3);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_tcontrol), 1);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox3), ipx_dialog_checktcontrol, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox3), ipx_dialog_tcontrol, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_checktcontrol), "toggled", G_CALLBACK(ipx_dialog_checktcontrol_toggled), NULL);

    ipx_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checktype = gtk_check_button_new_with_label(_("type"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checktype, TRUE);
    ipx_dialog_combotype = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combotype, _("-other-"));
    value = 0;
    while (table_ipx_types[value] != NULL)
        gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combotype, _(table_ipx_types[value++]));
    gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combotype, 0);
    ipx_dialog_type = gtk_entry_new();
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_type), 2);
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_type), 2);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_type), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_type), "00");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox4), ipx_dialog_checktype, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox4), ipx_dialog_combotype, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox4), ipx_dialog_type, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_type), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_type), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_combotype), "changed", G_CALLBACK(ipx_dialog_combotype_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checktype), "toggled", G_CALLBACK(ipx_dialog_checktype_toggled), NULL);

    ipx_dialog_hbox5 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checkdestnet = gtk_check_button_new_with_label(_("destination network"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checkdestnet, TRUE);
    ipx_dialog_destnet = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_destnet), 9);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_destnet), 9);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_destnet), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_destnet), "0000 0000");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox5), ipx_dialog_checkdestnet, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox5), ipx_dialog_destnet, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_destnet), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_destnet), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checkdestnet), "toggled", G_CALLBACK(ipx_dialog_checkdestnet_toggled), NULL);

    ipx_dialog_hbox6 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checkdestnode = gtk_check_button_new_with_label(_("destination node"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checkdestnode, TRUE);
    ipx_dialog_destnode = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_destnode), 14);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_destnode), 14);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_destnode), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_destnode), "0000 0000 0000");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox6), ipx_dialog_checkdestnode, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox6), ipx_dialog_destnode, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_destnode), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_destnode), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checkdestnode), "toggled", G_CALLBACK(ipx_dialog_checkdestnode_toggled), NULL);

    ipx_dialog_hbox7 = gtk_hbox_new(FALSE, 5);
    ipx_dialog_checkdestsock = gtk_check_button_new_with_label(_("destination socket"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checkdestsock, TRUE);
    ipx_dialog_combodestsock = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combodestsock, _("-other-"));
    value = 0;
    while (table_ipx_sockets[value] != NULL)
        gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combodestsock, _(table_ipx_sockets[value++]));
    gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combodestsock, 0);
    ipx_dialog_destsock = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_destsock), 4);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_destsock), 4);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_destsock), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_destsock), "0000");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox7), ipx_dialog_checkdestsock, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox7), ipx_dialog_combodestsock, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox7), ipx_dialog_destsock, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_destsock), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_destsock), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_combodestsock), "changed", G_CALLBACK(ipx_dialog_combodestsock_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checkdestsock), "toggled", G_CALLBACK(ipx_dialog_checkdestsock_toggled), NULL);

    ipx_dialog_hbox8 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checksrcnet = gtk_check_button_new_with_label(_("source network"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checksrcnet, TRUE);
    ipx_dialog_srcnet = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_srcnet), 9);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_srcnet), 9);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_srcnet), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_srcnet), "0000 0000");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox8), ipx_dialog_checksrcnet, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox8), ipx_dialog_srcnet, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_srcnet), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_srcnet), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checksrcnet), "toggled", G_CALLBACK(ipx_dialog_checksrcnet_toggled), NULL);

    ipx_dialog_hbox9 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_checksrcnode = gtk_check_button_new_with_label(_("source node"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checksrcnode, TRUE);
    ipx_dialog_combosrcnode = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combosrcnode, _("-other-"));
    value = selected = 0;
    while ((text = get_iface_name(value++)) != NULL) {
        gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combosrcnode, text);
        if (device != NULL && strcmp(text, device) == 0)
            selected = value;
    }
    ipx_dialog_srcnode = gtk_entry_new();
    /* select iface on combo and (en/dis)able entry after create */
    g_signal_connect(G_OBJECT(ipx_dialog_combosrcnode), "changed", G_CALLBACK(ipx_dialog_combosrcnode_changed), NULL);
    gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combosrcnode, selected);
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_srcnode), 14);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_srcnode), 14);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_srcnode), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_srcnode), "0000 0000 0000");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox9), ipx_dialog_checksrcnode, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox9), ipx_dialog_combosrcnode, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox9), ipx_dialog_srcnode, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_srcnode), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_srcnode), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checksrcnode), "toggled", G_CALLBACK(ipx_dialog_checksrcnode_toggled), NULL);


    ipx_dialog_hbox10 = gtk_hbox_new(FALSE, 5);
    ipx_dialog_checksrcsock = gtk_check_button_new_with_label(_("source socket"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_checksrcsock, TRUE);
    ipx_dialog_combosrcsock = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combosrcsock, _("-other-"));
    value = 0;
    while (table_ipx_sockets[value] != NULL)
        gtk_combo_box_append_text((GtkComboBox*) ipx_dialog_combosrcsock, _(table_ipx_sockets[value++]));
    gtk_combo_box_set_active((GtkComboBox*) ipx_dialog_combosrcsock, 0);
    ipx_dialog_srcsock = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ipx_dialog_srcsock), 4);
    gtk_entry_set_width_chars(GTK_ENTRY(ipx_dialog_srcsock), 4);
    gtk_entry_set_alignment(GTK_ENTRY(ipx_dialog_srcsock), 1);
    gtk_entry_set_text(GTK_ENTRY(ipx_dialog_srcsock), "0000");
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox10), ipx_dialog_checksrcsock, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox10), ipx_dialog_combosrcsock, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ipx_dialog_hbox10), ipx_dialog_srcsock, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ipx_dialog_srcsock), "key-press-event", G_CALLBACK(ipx_dialog_hex_keypress), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_srcsock), "changed", G_CALLBACK(ipx_dialog_hex_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_combosrcsock), "changed", G_CALLBACK(ipx_dialog_combosrcsock_changed), NULL);
    g_signal_connect(G_OBJECT(ipx_dialog_checksrcsock), "toggled", G_CALLBACK(ipx_dialog_checksrcsock_toggled), NULL);

    ipx_dialog_label2 = gtk_label_new(_("Write:"));
    ipx_dialog_hbox11 = gtk_hbox_new(TRUE, 5);
    ipx_dialog_radioatipx = gtk_radio_button_new_with_label(NULL, _("from 14th byte of frame"));
    ipx_dialog_radioatcursor = gtk_radio_button_new_with_label_from_widget(
						    GTK_RADIO_BUTTON(ipx_dialog_radioatipx),
						    _("from cursor's position"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipx_dialog_radioatipx, TRUE);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox11), ipx_dialog_radioatipx, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipx_dialog_hbox11), ipx_dialog_radioatcursor, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox5, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox6, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox7, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox8, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox9, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox10, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipx_dialog_window)->vbox), ipx_dialog_hbox11, TRUE, TRUE, 2);
    gtk_widget_show_all(ipx_dialog_window);
}

void ipx_dialog_write_frame() {
    int value, position, position2;
    char *text, *text2;

    /* cleanup */
    if ((position = frame->ipx_position) > -1) {
	frame->ipx_position = -1;
        for (position2 = position; position2 < position + 30; position2++) {
    	    if (frame->len > position2)
    	        fill_one_byte_cells(position2);
	}
    }

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_radioatipx))
	position = 14;

    /* cleanup old colors */
    if (frame->ip_position > -1) {
        for (position2 = frame->ip_position; position2 < frame->ip_position + 20; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->tcp_position > -1) {
        for (position2 = frame->tcp_position; position2 < frame->tcp_position + 20; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->udp_position > -1) {
        for (position2 = frame->udp_position; position2 < frame->udp_position + 8; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }

    /* remember position */
    frame->ip_position = -1;
    frame->tcp_position = -1;
    frame->udp_position = -1;
    frame->ipx_position = position;

    /* get checksum */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checkcsum)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
        for (position2 = 0; position2 < 2; position++, position2++) {
            text = malloc(3);
            text = gtk_editable_get_chars((GtkEditable*) ipx_dialog_csum, position2 * 2, position2 * 2 + 2);
            text[2] = 0;
            value = (hex2int(text) & 0xFF);
            free(text);
            frame->data[position] = value & 0xFF;
        }
    } else
	position += 2;

    /* get packet len */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checkplen)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ipx_dialog_plen));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get transport control */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checktcontrol)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ipx_dialog_tcontrol));
	frame->data[position] = value & 0xFF;
    }
    position++;

    /* get type */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checktype)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}

        value = gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combotype));
	text = malloc(3);
	if (value == 0)
	    text = gtk_editable_get_chars((GtkEditable*) ipx_dialog_type, 0, 2);
	else
	    strncpy(text, _(table_ipx_types[value - 1]), 2);
	text[2] = 0;
	value = (hex2int(text) & 0xFF);
	free(text);
	frame->data[position] = value & 0xFF;
    }
    position++;

    /* get destination network */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checkdestnet)) {
	/* add bytes to frame */
	if (frame->len < position + 4) {
	    add_to_frame(position - frame->len + 4, NULL, 0);
	    add_cells_to_tables();
	}
        for (position2 = 0; position2 < 4; position++, position2++) {
            text = malloc(3);
            text = gtk_editable_get_chars((GtkEditable*) ipx_dialog_destnet,
				     position2 * 2 + (position2 / 2), position2 * 2 + 2 + (position2 / 2));
            text[2] = 0;
            value = (hex2int(text) & 0xFF);
            free(text);
            frame->data[position] = value & 0xFF;
        }
    } else
	position += 4;

    /* get destination node */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checkdestnode)) {
	/* add bytes to frame */
	if (frame->len < position + 6) {
	    add_to_frame(position - frame->len + 6, NULL, 0);
	    add_cells_to_tables();
	}
        for (position2 = 0; position2 < 6; position++, position2++) {
            text = malloc(3);
            text = gtk_editable_get_chars((GtkEditable*) ipx_dialog_destnode,
				     position2 * 2 + (position2 / 2), position2 * 2 + 2 + (position2 / 2));
            text[2] = 0;
            value = (hex2int(text) & 0xFF);
            free(text);
            frame->data[position] = value & 0xFF;
        }
    } else
	position += 6;

    /* get destination socket */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checkdestsock)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}

        value = gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combodestsock));
	text2 = malloc(5);
	if (value == 0)
	    text2 = gtk_editable_get_chars((GtkEditable*) ipx_dialog_destsock, 0, 4);
	else
	    strncpy(text2, _(table_ipx_sockets[value - 1]), 4);
        text2[4] = 0;

        for (position2 = 0; position2 < 2; position++, position2++) {
            text = malloc(3);
	    strncpy(text, &text2[position2 * 2], 2);
            text[2] = 0;
            value = (hex2int(text) & 0xFF);
            free(text);
            frame->data[position] = value & 0xFF;
        }
	free(text2);
    } else
	position += 2;

    /* get source network */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checksrcnet)) {
	/* add bytes to frame */
	if (frame->len < position + 4) {
	    add_to_frame(position - frame->len + 4, NULL, 0);
	    add_cells_to_tables();
	}
        for (position2 = 0; position2 < 4; position++, position2++) {
            text = malloc(3);
            text = gtk_editable_get_chars((GtkEditable*) ipx_dialog_srcnet,
				     position2 * 2 + (position2 / 2), position2 * 2 + 2 + (position2 / 2));
            text[2] = 0;
            value = (hex2int(text) & 0xFF);
            free(text);
            frame->data[position] = value & 0xFF;
        }
    } else
	position += 4;

    /* get destination node */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checksrcnode)) {
	/* add bytes to frame */
	if (frame->len < position + 6) {
	    add_to_frame(position - frame->len + 6, NULL, 0);
	    add_cells_to_tables();
	}

        value = gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combosrcnode));
	if (value == 0) {
    	    for (position2 = 0; position2 < 6; position++, position2++) {
        	text = malloc(3);
        	text = gtk_editable_get_chars((GtkEditable*) ipx_dialog_srcnode,
		    		position2 * 2 + (position2 / 2), position2 * 2 + 2 + (position2 / 2));
        	text[2] = 0;
        	value = (hex2int(text) & 0xFF);
        	free(text);
        	frame->data[position] = value & 0xFF;
    	    }
	} else {
	    device = get_iface_name(value - 1);
            text = get_mac_address();
            memcpy(frame->data + position, text, 6);
            free(text);
	    position += 6;
	}
    } else
	position += 6;

    /* get destination socket */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipx_dialog_checksrcsock)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}

        value = gtk_combo_box_get_active(GTK_COMBO_BOX(ipx_dialog_combosrcsock));
	text2 = malloc(5);
	if (value == 0)
	    text2 = gtk_editable_get_chars((GtkEditable*) ipx_dialog_srcsock, 0, 4);
	else
	    strncpy(text2, _(table_ipx_sockets[value - 1]), 4);
        text2[4] = 0;

        for (position2 = 0; position2 < 2; position++, position2++) {
            text = malloc(3);
	    strncpy(text, &text2[position2 * 2], 2);
            text[2] = 0;
            value = (hex2int(text) & 0xFF);
            free(text);
            frame->data[position] = value & 0xFF;
        }
	free(text2);
    }

    /* refresh window */
    for (position2 = frame->ipx_position; position2 < frame->ipx_position + 30; position2++) {
        if (frame->len > position2)
    	    fill_one_byte_cells(position2);
    }
    fill_binary();
    fill_decimal();
    fill_datasize();
}
