/* $Id: main.c,v 1.4 2005/03/20 22:26:54 emvi Exp $ */

/*
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org)

This file is part of Ant.

Ant is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Ant is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ant; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include "misc.h"
#include "net.h"
#include "main.h"

#include <gtk/gtk.h>
#include <glib.h>
#include "gui-GTK.h"

GList *all_frames;		/* list of frames */
int selected_frame;		/* number of selected frame */
frame_t *frame;			/* struct of frame */

int selected_byte = 0;		/* number of selected byte in frame */
char *file_name = "";		/* name of file to open/save */
const char *charset;		/* character set encoding */

/* initialize frame data */
void init_frames() {
    /* store first frame in memmory */
    frame = malloc(sizeof(frame_t));
    frame->len = 1;
    frame->eth_position = -1;
    frame->ip_position = -1;
    frame->udp_position = -1;
    frame->tcp_position = -1;
    frame->fcs_position = -1;
    frame->ipx_position = -1;
    frame->spx_position = -1;
    /* store data of first frame */
    frame->data = malloc(1);
    frame->data[0] = 0;
    selected_frame = 0;
    selected_byte = 0;
    all_frames = g_list_append(all_frames, frame);
}

/* delete selected frame */
void delete_frame() {
    if (frame != NULL) {
	/* remove frame from memmory if exist */
	free(frame->data);
	free(frame);
	/* remove from list */
	all_frames = g_list_remove(all_frames, frame);
	/* select next frame in list */
	frame = g_list_nth_data(all_frames, selected_frame);
	/* select last frame if no more */
	if (frame == NULL)
	    frame = g_list_nth_data(all_frames, --selected_frame);
    }
}

/* remove all frames */
void remove_all_frames() {
    selected_frame = 0;
    while (all_frames != NULL)
	delete_frame();
}

/* remove data from selected frame */
void remove_framedata() {
    frame->data = realloc(frame->data, 1);
    frame->data[0] = 0;
    frame->len = 1;
    selected_byte = 0;
}

/* return: TRUE when all data read ok, FALSE on any error */
int read_from_file() {
    FILE *file;
    char data[2];
    int bytes, len;
    frame_t *new_frame;
    int ok;

    ok = TRUE;
    file = fopen(file_name, "r");
    if (file != NULL) {
	while (fread(data, 1, 2, file) == 2) {
	    /* read length of frame an check value */
	    len = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
	    if (len >= 10000) {
		ok = FALSE;
		break;
	    }
	    /* reseerve memmory for frame */
	    new_frame = malloc(sizeof(frame_t));
	    new_frame->len = len;
	    new_frame->data = malloc(len);
	    /* read position of eth */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->eth_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->eth_position == 0xFFFF)
		    new_frame->eth_position = -1;
	    }
	    /* read position of ip */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->ip_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->ip_position == 0xFFFF)
		    new_frame->ip_position = -1;
	    }
	    /* read position of tcp */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->tcp_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->tcp_position == 0xFFFF)
		    new_frame->tcp_position = -1;
	    }
	    /* read position of udp */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->udp_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->udp_position == 0xFFFF)
		    new_frame->udp_position = -1;
	    }
	    /* read position of ipx */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->ipx_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->ipx_position == 0xFFFF)
		    new_frame->ipx_position = -1;
	    }
	    /* read position of spx */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->spx_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->spx_position == 0xFFFF)
		    new_frame->spx_position = -1;
	    }
	    /* read position of fcs */
	    bytes = fread(data, 1, 2, file);
	    if (bytes == 2) {
		new_frame->fcs_position = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
		if (new_frame->fcs_position == 0xFFFF)
		    new_frame->fcs_position = -1;
	    }
	    /* read frame data */
	    bytes = fread(new_frame->data, 1, len, file);
	    if (bytes == len)
		all_frames = g_list_append(all_frames, new_frame);
	    else {
		/* file corrupted - stop reading */
		free(new_frame->data);
	        free(new_frame);
		ok = FALSE;
	    }
	}
	fclose(file);
    }
    if (g_list_length(all_frames) == 0) {
	init_frames();
	ok = FALSE;
    }
    selected_frame = 0;
    frame = g_list_nth_data(all_frames, 0);
    selected_byte = 0;
    return ok;
}

void save_to_file() {
    FILE *file;
    frame_t *frame_to_save;
    int i, nr_frames;
    guint8 idata;

    file = fopen(file_name, "w");

    nr_frames = g_list_length(all_frames);
    for (i = 0; i < nr_frames; i++) {
	/* write length of frame */
	frame_to_save = g_list_nth_data(all_frames, i);
	idata = (frame_to_save->len & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->len & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of eth */
	idata = (frame_to_save->eth_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->eth_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of ip */
	idata = (frame_to_save->ip_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->ip_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of tcp */
	idata = (frame_to_save->tcp_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->tcp_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of udp */
	idata = (frame_to_save->udp_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->udp_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of ipx */
	idata = (frame_to_save->ipx_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->ipx_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of spx */
	idata = (frame_to_save->spx_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->spx_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write position of fcs */
	idata = (frame_to_save->fcs_position & 0xFF00) >> 8;
	fwrite(&idata, 1, 1, file);
	idata = frame_to_save->fcs_position & 0xFF;
	fwrite(&idata, 1, 1, file);

	/* write frame data */
	fwrite(frame_to_save->data, 1, frame_to_save->len, file);
    }
    
    fclose(file);
}

int main(int argc, char *argv[]) {

    bindtextdomain("ant", "po/");
    textdomain("ant");
    bind_textdomain_codeset("ant", "UTF-8");

    gtk_init (&argc, &argv);

    g_get_charset(&charset);
    if (strcmp(charset, "ANSI_X3.4-1968"))
	charset = "ISO-8859-1";

    get_iface_list();
    create_main_window ();

    init_frames();

    add_cells_to_tables(frame->len);
    fill_frame_number();
    fill_binary();
    fill_decimal();
    fill_datasize();

    gtk_main ();

    remove_all_frames();
    g_list_free(all_frames);
    free_iface_list();
    return 0;
}
