/* $Id: misc.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "main.h"
#include "gui-GTK.h"

/* Convert byte to hex data
   Input:
   data - byte to convert
   Output: byte as hex data (string) */
char *int2hex(guint8 data) {
    char *ascii = NULL;
    ascii = malloc(3);
    sprintf(ascii, "%.2X", data);
    return ascii;
}

/* Convert hex data to byte
   Input:
   data - hex data to convert
   Output: byte */
guint8 hex2int(char *data) {
    int byte = 0;
    sscanf(data, "%X", &byte);
    return byte;
}

/* Convert byte to binary data
   Input:
   data - byte to convert
   Output: byte as binary data (string) */
char* int2bin(int data) {
    char *bin;
    int i, mask = 0x80;
    bin = malloc(9);
    for (i=0; i<8; i++) {
	bin[i] = ((data & mask) > 0)?'1':'0';
	mask = mask >> 1;
    }
    bin[8] = 0;
    return bin;
}

/* Convert binary data to byte
   Input:
   data - byte as binary data (string)
   Output: converted byte */
int bin2int(char *data) {
    int i, result = 0;
    for (i=0; i<8; i++) {
	result = result << 1;
	result += (data[i] == '1')?1:0;
    }
    return result;
}

/* Convert byte to decimal data
   Input:
   data - byte to convert
   Output: byte as decimal data (string) */
char* int2dec(int data) {
    char *ascii = NULL;
    ascii = malloc(4);
    sprintf(ascii, "%i", data & 0xFF);
    return ascii;
}

/* Convert decimal data to byte
   Input:
   data - byte as decimal data (string)
   Output: converted byte */
int dec2int(char *data) {
    int i, result = 0;
    for (i=0; (i < 3) && (data[i] != 0); i++) {
	result = result * 10;
	result += data[i] - '0';
    }
    return result;
}

/* Convert ascii to utf
   Input:
   ascii - text to convert
   Output: utf text */
char *ascii2utf(char *ascii) {
    char *utf = NULL;
    GError *err = NULL;
    if (!ascii)
	return NULL;
    utf = malloc(strlen(ascii));
    if (!(utf = g_convert(ascii, -1, "UTF-8", charset, NULL, NULL, &err))) {
	if (err != NULL)
	    g_error_free(err);
	utf = g_strdup(ascii);
    }
    return utf;
}

/* Convert utf to ascii
   Input:
   utf - text to convert
   Output: ascii text */
char *utf2ascii(char *utf) {
    char *ascii = NULL;
    GError *err = NULL;
    if (!utf)
	return NULL;
    ascii = malloc(2);
    if (!(ascii = g_locale_from_utf8(utf, -1, NULL, NULL, &err))) {
	if (err != NULL)
	    g_error_free(err);
	ascii = g_strdup(utf);
    }
    return ascii;
}

/* Add X bytes to frame data
   Input:
   length - number of bytes to add
   new_data - data to add (string) or NULL to fill with value
   value - value to write in new bytes */
void add_to_frame(int length, char *new_data, int value) {
    int i;
    value = value & 0xFF;
    frame->data = realloc(frame->data, frame->len + length);
    if (new_data == NULL)
	for (i = 0; i < length; i++)
	    frame->data[frame->len + i] = value;
    else
	memcpy(frame->data + frame->len, new_data, length);
    frame->len += length;
    fill_datasize();
}

/* Delete X bytes from frame data
   Input:
   length - number of bytes to del */
void remove_from_frame(int length) {
    frame->data = realloc(frame->data, frame->len - length);
    frame->len -= length;
    if (selected_byte >= frame->len)
	selected_byte = frame->len - 1;
    fill_datasize();
}
