/***************************************************************************
 *   Copyright (C) 2005 by Tommaso frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kmainwindow.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <ksystemtray.h>

#include "ecikontrol.h"
#include "ecikontrolwidget.h"

#include <qtooltip.h>
#include <qfont.h>
#include <qevent.h>
#include <qsize.h>

eciKontrol::eciKontrol()
    : KMainWindow( 0, "eciKontrol" )
{
    init = false;
    
    QSize size(230,390);
    setFixedSize(size);
    setCentralWidget( new eciKontrolWidget( this ) );
    setIcon(KGlobal::iconLoader()->loadIcon("kppp", KIcon::MainToolbar));
    
    trayicon = new KSystemTray(this, "ecikontrolsystemtray");
    trayicon->setPixmap(KGlobal::iconLoader()->loadIcon("kppp", KIcon::MainToolbar));
    setTrayiconTooltip( "<b>Not Connected</b>" );
    init = true;
    
    
}
bool eciKontrol::event(QEvent* e)
{
    if( (int)e->type() == QEvent::Hide) 
    {
   	trayicon->setInactive();
	trayicon->show();
    }
    else if( (int)e->type() == QEvent::Show) 
    {
	    trayicon->hide();
    } 
    if( (int)e->type() == QEvent::Close) 
    {
	    trayicon->setInactive();
	    trayicon->show();
	    return true;
    }
  
    return KMainWindow::event( e );
}

eciKontrol::~eciKontrol()
{
}

void eciKontrol::setTrayiconTooltip(QString message) {
    QFont font = QToolTip::font();
    font.setPointSize( 9 );
    QToolTip::setFont( font ); 

    QToolTip::add( trayicon, message);
}
#include "ecikontrol.moc"
