/***************************************************************************
 *   Copyright (C) 2005 by Tommaso frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ecikontrolconfigwizard.h"

#include <kconfig.h>
#include <kmessagebox.h>
#include <kfiledialog.h>

#include <qlineedit.h>
#include <qlistbox.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qprocess.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>


eciKontrolConfigWizard::eciKontrolConfigWizard(QWidget *parent, const char *name) : frmConfignWizard(parent, name)
{
	
	connect (this->finishButton(), SIGNAL(clicked()), this, SLOT(finishButton_clicked()));
	

	eciconf = new KConfig("/etc/eciadsl/eciadsl.conf");
	
	txtUsername->setText(eciconf->readEntry("PPPD_USER", ""));

	loadDatabaseIntoList("/etc/eciadsl/providers.db", lstProvider, 2, eciconf->readEntry("PROVIDER", ""));
	lstProvider->insertItem("##..Other Provider");	
	txtDNS1->setText(eciconf->readEntry("DNS1", ""));
	txtDNS2->setText(eciconf->readEntry("DNS2", ""));

	loadDatabaseIntoList("/etc/eciadsl/modems.db", lstModem, 7, eciconf->readEntry("MODEM", ""));		
	txtVPI->setText(eciconf->readEntry("VPI", ""));
	txtVCI->setText(eciconf->readEntry("VCI", ""));
	txtVID1->setText(eciconf->readEntry("VID1", ""));
	txtPID1->setText(eciconf->readEntry("PID1", ""));
	txtVID2->setText(eciconf->readEntry("VID2", ""));
	txtPID2->setText(eciconf->readEntry("PID2", ""));
	txtAltSynch->setText(eciconf->readEntry("SYNCH_ALTIFACE", ""));
	txtAltPPPoECI->setText(eciconf->readEntry("PPPOECI_ALTIFACE", ""));    
	
	readBinaries(eciconf->readEntry("SYNCH", ""));

	if (eciconf->readEntry("USE_DHCP", "").compare("yes") == 0)
	{
		btnHowGetIP->setButton(0);
		fmStatic->setEnabled(FALSE);
	} 
	else
	{
		btnHowGetIP->setButton(1);
		fmStatic->setEnabled(TRUE);
	} 

	lstPPPMode->setSelected(lstPPPMode->findItem(eciconf->readEntry("MODE", "")), TRUE);
	txtStaticIP->setText(eciconf->readEntry("STATICIP", ""));
	txtGateway->setText(eciconf->readEntry("GATEWAY", ""));


}
 
void eciKontrolConfigWizard::loadDatabaseIntoList(QString database, QListBox* list, int last_params, QString selected_start_with)
{
	list->clear();
	
	QFile file(database);
	
	if (!file.exists())
	{
		KMessageBox::error(this, "Database \"" + database + "\" not found.\nChech your EciADSL configuration directory at \"/etc/eciadsl/\"!", "Warning: Database not found");
		return;
	}
	
	file.open(IO_ReadOnly);
	QString record;

	while (!file.atEnd())
	{
		file.readLine(record, 1024);
		QStringList tokens = QStringList::split(" ", record.simplifyWhiteSpace(), FALSE);
		
		record = tokens[0];
		for (unsigned int index = 1; index < tokens.size() - last_params; index++)
			record.append(tokens[index]);
		
		record.append("  [");
		for (unsigned int index = tokens.size() - last_params; index < tokens.size() - 1; index++)
			record.append(tokens[index] + " - ");
		
		record.append(tokens[tokens.size() - 1] + "]");

		list->insertItem(record);		
		
		if (selected_start_with.length() > 0 && record.startsWith(selected_start_with))
			list->setSelected(list->findItem(record), TRUE);
	}
	
	file.close();
}

void eciKontrolConfigWizard::readBinaries(QString folder) 
{
	QStringList tokens = QStringList::split("/", folder.simplifyWhiteSpace(), FALSE);	
	QString synch_path("/");
	QString synch_bin("");

	for (unsigned int index = 0; index < tokens.size() - 1; index++) 
	{
		synch_path.append(tokens[index] + "/");
	}

	if (tokens[tokens.size() - 1].endsWith(".bin")) 
	{
		synch_bin = tokens[tokens.size() - 1];
	}
	else
	{
		synch_path.append(tokens[tokens.size() - 1] + "/");
	}
		

	txtSynchPath->setText(synch_path);

	QDir dir(synch_path, "*.bin");
	lstSynch->clear();
	for (unsigned int index = 0; index < dir.count(); index++)
		if (!dir[index].startsWith("firmware"))
			lstSynch->insertItem(dir[index]);

	if (synch_bin.length() > 0)
		lstSynch->setSelected(lstSynch->findItem(synch_bin), TRUE);
}

QStringList eciKontrolConfigWizard::getRecordParams(QString record) 
{
	QStringList tokens = QStringList::split("[", record.simplifyWhiteSpace(), FALSE);
	tokens = QStringList::split("]", tokens[1].simplifyWhiteSpace(), FALSE);
	tokens = QStringList::split(" - ", tokens[0].simplifyWhiteSpace(), FALSE);
	
	return tokens;
}

QString eciKontrolConfigWizard::getRecordDesc(QString record) 
{
	QStringList tokens = QStringList::split("[", record.simplifyWhiteSpace(), FALSE);

	return tokens[0].stripWhiteSpace();
}

void eciKontrolConfigWizard::lstProvider_highlighted(const QString& s)
{
	QStringList dnses = this->getRecordParams( s );

	txtDNS1->setText(dnses[0]);
	txtDNS2->setText(dnses[1]);

}

void eciKontrolConfigWizard::lstModem_highlighted(const QString& s)
{
	QStringList modem_params = this->getRecordParams( s );

	txtVID1->setText(modem_params[0]);
	txtVID2->setText(modem_params[1]);
	txtPID1->setText(modem_params[2]);
	txtPID2->setText(modem_params[3]);
	txtAltSynch->setText(modem_params[5]);
	txtAltPPPoECI->setText(modem_params[6]);

	cmbChipset->setCurrentText("Globespan " + modem_params[4]);
}

void eciKontrolConfigWizard::btnSelectPath_clicked()
{
	QString path = KFileDialog::getExistingDirectory(txtSynchPath->text(), this, "Select Sinchronization Binary Directory");

	readBinaries( path );
}

void eciKontrolConfigWizard::btnHowGetIP_released(int b)
{
	fmStatic->setEnabled(!b);
}

void eciKontrolConfigWizard::finishButton_clicked() 
{
	eciconf->writeEntry("PPPD_USER", txtUsername->text());
	eciconf->writeEntry("PPPD_PASSWD", txtPassword->text());

	eciconf->writeEntry("PROVIDER", this->getRecordDesc( lstProvider->currentText() ));
	eciconf->writeEntry("DNS1", txtDNS1->text());
	eciconf->writeEntry("DNS2", txtDNS2->text());
	eciconf->writeEntry("VPI", txtVPI->text());
	eciconf->writeEntry("VCI", txtVCI->text());

	eciconf->writeEntry("MODEM", this->getRecordDesc( lstModem->currentText() ));
	eciconf->writeEntry("VID1", txtVID1->text());
	eciconf->writeEntry("VID2", txtVID2->text());
	eciconf->writeEntry("PID1", txtPID1->text());
	eciconf->writeEntry("PID2", txtPID2->text());
	eciconf->writeEntry("SYNCH_ALTIFACE", txtAltSynch->text());
	eciconf->writeEntry("PPPOECI_ALTIFACE", txtAltPPPoECI->text());

	eciconf->writeEntry("SYNCH", txtSynchPath->text() + lstSynch->currentText());

	eciconf->writeEntry("MODE", lstPPPMode->currentText());
	eciconf->writeEntry("STATICIP", txtStaticIP->text());
	eciconf->writeEntry("GATEWAY", txtGateway->text());

	if (rdDHCP->isOn()) 
	{
		eciconf->writeEntry("USE_DHCP", "yes");
		eciconf->writeEntry("USE_STATICIP", "no");
	}
	else
	{
		eciconf->writeEntry("USE_DHCP", "no");
		eciconf->writeEntry("USE_STATICIP", "yes");
	}

	eciconf->sync();

	KMessageBox::information(this, "All new settings now are stored in the configuration file.\nPress \"Connect\" to establish new connection to internet", "Configuration Wizard Completed");
}

void eciKontrolConfigWizard::frmConfignWizard_selected(const QString&)
{
	finishButton()->setEnabled(TRUE);
}







#include "ecikontrolconfigwizard.moc"
