//
// C++ Implementation: $MODULE$
//
// Description: 
//
//
// Author: Tommaso Frazzetto <tommaso.frazzetto@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qprocess.h>
#include <qprogressbar.h>
#include <qdir.h>
#include <qstring.h>
#include <qbuttongroup.h>
#include <qtooltip.h>

#include <kglobal.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kconfig.h>

#include "ecikontrolprobesynchdialog.h"
#include "ecikontrolvalidssynchbin.h"

eciKontrolProbeSynchDialog::eciKontrolProbeSynchDialog(QWidget *parent, const char *name)
    :dlgProbeSynch(parent, name)
{   
    
    synch_path = new QString();

    pbProgress->setTotalSteps(readBinariesSynchs());

    btnAbort->setPixmap(KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
    btnDetails->setPixmap(KGlobal::iconLoader()->loadIcon("2rightarrow", KIcon::MainToolbar));

    pbProgress->setProgress(-1);
    process = NULL;
    valids_dialog = NULL;
    startTest();
}

eciKontrolProbeSynchDialog::~eciKontrolProbeSynchDialog() 
{
	delete synch_path;
	if (process != NULL)
		delete process;
	if (valids_dialog != NULL)
		delete valids_dialog;

}

void eciKontrolProbeSynchDialog::btnAbort_clicked()
{
        if (KMessageBox::warningYesNo(this, "Testing of synchronization binaries isn't completed.\nAre you sure you want abort synchronization binaries testing?", "Abort") == KMessageBox::Yes) 
        {
		this->hide();
        } 

}

void eciKontrolProbeSynchDialog::btnDetails_clicked()
{
    if (height() == 100) 
    {
        btnDetails->setTextLabel("Hide &Details");
        QToolTip::add(btnDetails, "Hide testing detals");
        btnDetails->setPixmap(KGlobal::iconLoader()->loadIcon("2leftarrow", KIcon::MainToolbar));

        setFixedHeight(300);
    }
    else
    {
        btnDetails->setTextLabel("Show &Details");
        QToolTip::add(btnDetails, "Show testing details");
        btnDetails->setPixmap(KGlobal::iconLoader()->loadIcon("2rightarrow", KIcon::MainToolbar));

        setFixedHeight(100);
    }
}

int eciKontrolProbeSynchDialog::readBinariesSynchs()
{
	KConfig * eciconf = new KConfig("/etc/eciadsl/eciadsl.conf");

	QString synch = eciconf->readEntry("SYNCH", "");

	delete eciconf;

	if (synch.length() == 0)
		synch = "/etc/eciadsl";

	QStringList tokens = QStringList::split("/", synch.simplifyWhiteSpace(), FALSE);	

	for (unsigned int index = 0; index < tokens.size() - 1; index++) 
	{
		synch_path->append("/" + tokens[index]);
	}

	if (!tokens[tokens.size() - 1].endsWith(".bin")) 
	{
		synch_path->append("/" + tokens[tokens.size() - 1]);
	}
		

	lblPath->setText("Synchronization Binaries Folder: <b>" + *synch_path + "</b>");
	QString * files = new QString();
	QDir dir(*synch_path, "*.bin");
	lblConsole->setText(files->setNum(dir.count() - 1) + " synchronization binary files founded");
	delete files;
	return dir.count() - 1;
}

void  eciKontrolProbeSynchDialog::startTest()
{
	process = new QProcess();
	
	process->addArgument("/usr/local/bin/eciadsl-probe-synch");
	process->addArgument("--try-all");
	process->addArgument("--batch");
	process->addArgument(*synch_path);
		
	connect( process, SIGNAL(readyReadStdout()), this, SLOT(connectionReadFromStdout()));    
	connect( process, SIGNAL(readyReadStderr()), this, SLOT(connectionReadFromStderr()));    
	connect( process, SIGNAL(processExited()), this, SLOT(testFinished()) );    	

	valids_dialog = new eciKontrolValidsSynchBin(this);
	process->start();
}

void eciKontrolProbeSynchDialog::connectionReadFromStdout()
{
    QString string = process->readLineStdout();

    if (string.startsWith("Testing synch with"))
	pbProgress->setProgress(pbProgress->progress() + 1);

    if (string.endsWith("seems OK")) 
    {
    	QStringList tokens = QStringList::split(" ", string);
	valids_dialog->addValidSynchBin(tokens[0]);
    }
	

    if (!string.isEmpty()) {
        lblConsole->setText(lblConsole->text() + string + "<br>");
    }
}

void eciKontrolProbeSynchDialog::connectionReadFromStderr()
{
    QString string = process->readLineStderr();

    if (!string.isEmpty()) {
        lblConsole->setText(lblConsole->text() + "<font color=#BB6666>" + string + "</font><br>");
    }
}

void eciKontrolProbeSynchDialog::testFinished()
{
	lblConsole->setText(lblConsole->text() + "<font color=#6666BB>Test finished</font><br>");
	pbProgress->setProgress(pbProgress->progress() + 1);	
	valids_dialog->exec();
	close();
}

void eciKontrolProbeSynchDialog::lblConsole_textChanged()
{
    lblConsole->scrollToBottom();
}


#include "ecikontrolprobesynchdialog.moc"
