/***************************************************************************
 *   Copyright (C) 2005 by Tommaso frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qprocess.h>
#include <qwidgetstack.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qmenubar.h>
#include <qpopupmenu.h>

#include "ecikontrolwidget.h"
#include "ecikontrolconfigwizard.h"
#include "ecikontroldoctrodialog.h"
#include "ecikontrolprobesynchdialog.h"

#include <kglobal.h>
#include <kaboutapplication.h>
#include <kiconloader.h>
#include <kmessagebox.h>



#include <unistd.h>

eciKontrolWidget::eciKontrolWidget(QWidget* parent, const char* name, WFlags fl)
        : eciKontrolWidgetBase(parent,name,fl)
{
    this->parent = (eciKontrol*) parent; 
    process = NULL;
    menu = new QMenuBar(this);
    file = new QPopupMenu(this);
    tools = new QPopupMenu(this);
    help = new QPopupMenu(this);
	
    file->insertItem(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar), "&Connect", this, SLOT(btnConnect_clicked()), CTRL+Key_C, 0);
    file->insertSeparator();
    file->insertItem(KGlobal::iconLoader()->loadIcon("exit", KIcon::MainToolbar), "&Exit", this, SLOT(btnExit_clicked()), CTRL+Key_X, 1);    

    tools->insertItem(KGlobal::iconLoader()->loadIcon("kcontrol", KIcon::MainToolbar), "&Configuration Wizard...", this, SLOT(btnConfig_clicked()), CTRL+Key_W, 0);
    tools->insertSeparator();    
    tools->insertItem(KGlobal::iconLoader()->loadIcon("messagebox_info", KIcon::MainToolbar), "Configuration &Test...", this, SLOT(mnuDoctor_clicked()), CTRL+Key_T, 1);
    tools->insertItem(KGlobal::iconLoader()->loadIcon("reload", KIcon::MainToolbar), "&Syncronization Binaries Test...", this, SLOT(mnuProber_clicked()), CTRL+Key_S, 2);

    help->insertItem(KGlobal::iconLoader()->loadIcon("kppp", KIcon::MainToolbar), "&About...", this, SLOT(btnAbout_clicked()), CTRL+Key_I, 0);

    
    menu->insertItem("&File", file);
    menu->insertItem("&Tools", tools);
    menu->insertItem("&Help", help);

    lblStatus->setText("<b>Not connected</b>");    
    btnConnect->setPixmap(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar));
    btnConfig->setPixmap(KGlobal::iconLoader()->loadIcon("kcontrol", KIcon::MainToolbar));
    btnExit->setPixmap(KGlobal::iconLoader()->loadIcon("exit", KIcon::MainToolbar));

    btnDisconnect->setPixmap(KGlobal::iconLoader()->loadIcon("connect_no", KIcon::MainToolbar));

    timer = new QTimer( this);
    connect( timer, SIGNAL(timeout()), this, SLOT(connectionMonitorTimeout()) );
    QString command("/sbin/ifconfig");
    QString param("ppp0");
    monitor = new QProcess();
    monitor->addArgument(command);
    monitor->addArgument(param);
    connect( monitor, SIGNAL(readyReadStdout()), this, SLOT(monitorReadFromStdout()));
    checkConnection();
}

eciKontrolWidget::~eciKontrolWidget()
{
	delete process;
	delete timer;
	delete monitor;
}

void eciKontrolWidget::checkConnection()
{
	QString command("/usr/bin/pgrep");
	QString id("eciadsl-pppoeci");
		
	process = new QProcess();
	process->addArgument(command);
	process->addArgument(id);

	if (!process->start())
		return;

	while(process->isRunning());

	if (process->exitStatus() == 0)
	{
		lblStatus->clear();
		wgtStack->raiseWidget(1);
		timer->start(1000, FALSE);
		file->changeItem(KGlobal::iconLoader()->loadIcon("connect_no", KIcon::MainToolbar),"&Disconnect", 0); 
	
		connection_time.start();
	}
		
}

void eciKontrolWidget::connectionReadFromStdout()
{
    QString string = process->readLineStdout();

    if (!string.isEmpty()) {
        lblOutput->setText(lblOutput->text() + string + "<br>");
    }
}

void eciKontrolWidget::connectionReadFromStderr()
{
    QString string = process->readLineStderr();

    if (!string.isEmpty()) {
        lblOutput->setText(lblOutput->text() + "<font color=#BB6666>" + string + "</font><br>");
    }
}

void eciKontrolWidget::connectionCompleted() 
{
    QString error_messages[7] = 
    {   
       "normal termination (no error)",
       "usage/cmdline error",
       "USB system init error",
       "synchronization error",
       "connection error",
       "routing error"
    };

    if (process->exitStatus() == 0) {
        lblOutput->setText( lblOutput->text() + "<font color=#44AA44><b>Now you are connected to internet!</b><br>");
        lblStatus->clear();
        wgtStack->raiseWidget(1);
        timer->start(1000, FALSE);
	file->changeItem(KGlobal::iconLoader()->loadIcon("connect_no", KIcon::MainToolbar),"&Disconnect", 0); 

	connection_time.start();
    }
    else
    {

	btnConnect->setTextLabel("&Connect");
	btnConnect->setPixmap(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar));
        btnConnect->setEnabled(true);
        btnConfig->setEnabled(true);

	file->changeItem(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar),"&Connect Connection", 0); 

        lblOutput->setText( lblOutput->text() + "<font color=#CC9999><b>Error during connection!!</b><br>");
        lblOutput->setText( lblOutput->text() + "<font color=#CC9999><b>Error Description: " + error_messages[process->exitStatus()] + "</b><br>");
        
    }
}

void eciKontrolWidget::disconnectionCompleted() 
{
   try {    
	if (process->exitStatus() == 0) {
		btnConnect->setTextLabel("&Connect");
		btnConnect->setPixmap(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar));
		btnConfig->setEnabled(true);		
	
		file->changeItem(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar),"&Connect Connection", 0); 

		lblOutput->setText("<b>Wellcome to eciKontrol:</b><br>eciKontrol is a simple frontend for EciADSL drivers.<br><ul><li>Press \"Connect\" for create new internet connection.</li>				<li>Press \"Configure\" to start connection configuration wizard.</li><li>Press \"Exit\" to leave <i>eciKontrol.</i></li></ul>");
	
		wgtStack->raiseWidget(0);
		timer->stop();
    	}
    }
    catch (void * e) {
    }
}

void eciKontrolWidget::btnConnect_clicked()
{
	if (process == NULL || !process->isRunning()) 
	{
		QString shell("/bin/sh");
		QString script("/usr/local/bin/eciadsl-start");
		
		process = new QProcess();
		process->addArgument(shell);
		process->addArgument(script);
		connect( process, SIGNAL(readyReadStdout()), this, SLOT(connectionReadFromStdout()));    
		connect( process, SIGNAL(readyReadStderr()), this, SLOT(connectionReadFromStderr()));    
		connect( process, SIGNAL(processExited()), this, SLOT(connectionCompleted()) );    		
		
		lblOutput->clear();
		lblOutput->setText(lblOutput->text() + "<b>Output:</b><br>Connectiong to internet...<br>");
		if (!process->start())
			lblOutput->setText("<font color=#DD4444><b>Error during connection</b><br>");
		
		btnConnect->setTextLabel("&Abort Connection");
		btnConnect->setPixmap(KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));

		file->changeItem(KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar),"&Abort Connection", 0); 
		
		btnConfig->setEnabled(false);		
	}
	else
	{
		int res = KMessageBox::questionYesNo(this, "Are you sure you want abort connection?", "Abort Connection");
		if (res == KMessageBox::No)
			return;
		
		disconnect( process, SIGNAL(processExited()), this, SLOT(connectionCompleted()) );    		
		process->kill();
		process = NULL;
		
		btnConnect->setTextLabel("&Connect");
		btnConnect->setPixmap(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar));
		btnConfig->setEnabled(true);		

		file->changeItem(KGlobal::iconLoader()->loadIcon("connect_creating", KIcon::MainToolbar),"&Connect Connection", 0); 

		lblOutput->setText("<b>Wellcome to eciKontrol:</b><br>eciKontrol is a simple frontend for EciADSL drivers.<br><ul><li>Press \"Connect\" for create new internet connection.</li>				<li>Press \"Configure\" to start connection configuration wizard.</li><li>Press \"Exit\" to leave <i>eciKontrol.</i></li></ul>");
	}
}

void eciKontrolWidget::btnExit_clicked()
{
    int res = KMessageBox::questionYesNo(this, "Are you sure you want exit?", "Exit...");
    
    if (res == KMessageBox::Yes) {
        _exit(0);
    }
}

void eciKontrolWidget::btnDisconnect_clicked()
{
    int res = KMessageBox::questionYesNo(this, "Are you sure you want disconnect from internet?", "Disconnection...");
    if (res == KMessageBox::No)
        return;

    QString shell("/bin/sh");
    QString script("/usr/local/bin/eciadsl-stop");
    
    process = new QProcess();
    process->addArgument(shell);
    process->addArgument(script);
    connect( process, SIGNAL(processExited()), this, SLOT(disconnectionCompleted()) );

    process->start();
}

void eciKontrolWidget::lblOutput_textChanged()
{
    lblOutput->scrollToBottom();
}

void eciKontrolWidget::connectionMonitorTimeout() 
{
    lblStatus->clear();
    monitor->start();
}

void eciKontrolWidget::monitorReadFromStdout() {
    bool skip = true;
    QString * output = new QString();

    while (monitor->canReadLineStdout()) {
        QString string = monitor->readLineStdout();
        
        if (string.find("ppp", 0, FALSE) != -1 || string.find("tun", 0, FALSE))
            skip = false;
        
        if (!string.isEmpty() && !skip) {
            output->append(string);
        }
    }

    if (output->isEmpty()) {
        lblStatus->setText("<b>Not connected</b>");
        return;
    }
    
    lblStatus->setText("<b><u>Connection Status: </b></u><br>");    
    if (output->find("ppp", 0, FALSE) != -1) {
        lblStatus->append("<b>Device: </b>ppp");    
    }
    else {
        lblStatus->append("<b>Device: ppp</b>tun");    
    }

    int address_start = output->find("addr:", 0, FALSE) + 5;
    int address_end = output->find(" ", address_start, FALSE);
    lblStatus->append("<b>Address: </b>" + getSubString(*output, address_start, address_end));

    int rx_start = output->find("RX packets:", 0, FALSE) + 11;
    int rx_end = output->find(" ", rx_start, FALSE);
    lblStatus->append("<b>Received packets: </b>" + getSubString(*output, rx_start, rx_end));

    int tx_start = output->find("TX packets:", 0, FALSE) + 11;
    int tx_end = output->find(" ", tx_start, FALSE);    
    lblStatus->append("<b>Transmitted packets: </b>" + getSubString(*output, tx_start, tx_end));

    rx_start = output->find("RX bytes:", 0, FALSE) + 9;
    rx_end = output->find(")", rx_start, FALSE) + 1;
    lblStatus->append("<b>Received data: </b>" + getSubString(*output, rx_start, rx_end));

    tx_start = output->find("TX bytes:", 0, FALSE) + 9;
    tx_end = output->find(")", tx_start, FALSE) + 1;    
    QTime time(0,0,0);
    lblStatus->append("<b>Transmitted data: </b>" + getSubString(*output, tx_start, tx_end));
    lblStatus->append("<b>Connection time: </b>" + time.addMSecs(connection_time.elapsed()).toString("hh:mm:ss"));

    parent->setTrayiconTooltip(lblStatus->text());
    delete output;
}

QString eciKontrolWidget::getSubString(QString& source, int start, int end) 
{
    if (source.isEmpty() || start <= 0 || end <= start)
        return "";
    
    return source.right(source.length() - start).left(end - start);
}

QString eciKontrolWidget::getStatusInformations() 
{
    return lblStatus->text();
}

void eciKontrolWidget::btnConfig_clicked()
{
    eciKontrolConfigWizard wizard(this);
    wizard.exec();
}

void eciKontrolWidget::btnAbout_clicked()
{
	KAboutApplication about( this );
	about.exec();
}

void eciKontrolWidget::mnuDoctor_clicked()
{
	eciKontrolDoctroDialog doctor(this);
	doctor.setFixedWidth(370);
	doctor.setFixedHeight(390);

	doctor.exec();
	checkConnection();
}

void eciKontrolWidget::mnuProber_clicked()
{
	eciKontrolProbeSynchDialog prober(this);
	prober.setFixedWidth(300);
	prober.setFixedHeight(100);

	prober.exec();
	checkConnection();
}



#include "ecikontrolwidget.moc"

