/***************************************************************************
 *   Copyright (C) 2005 by Tommaso frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _ECIKONTROLWIDGET_H_
#define _ECIKONTROLWIDGET_H_

#include "ecikontrolwidgetbase.h"
#include "ecikontrol.h"
#include <qprocess.h>
#include <qtimer.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qdatetime.h>
#include <ksystemtray.h>

class eciKontrol;
class eciKontrolWidget : public eciKontrolWidgetBase
{
    Q_OBJECT
    QProcess * process;
    QProcess * monitor;
    QTimer * timer;
    eciKontrol * parent;
    QMenuBar * menu;
    QPopupMenu * file;
    QPopupMenu * tools;
    QPopupMenu * help;
    QTime connection_time;


    QString getSubString(QString& source, int start, int end);

public:
    eciKontrolWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~eciKontrolWidget();
    QString getStatusInformations();
    void checkConnection();
    /*$PUBLIC_FUNCTIONS$*/

public slots:
    virtual void connectionCompleted();
    virtual void connectionReadFromStdout();
    virtual void connectionReadFromStderr();
    virtual void disconnectionCompleted();
    virtual void btnConnect_clicked();
    virtual void btnExit_clicked();
    virtual void btnDisconnect_clicked();
    virtual void lblOutput_textChanged();
    virtual void connectionMonitorTimeout();
    virtual void monitorReadFromStdout();
    virtual void btnConfig_clicked();
    virtual void btnAbout_clicked();
    virtual void mnuDoctor_clicked();
    virtual void mnuProber_clicked();

protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

