/*
 * colors.c
 *
 * provides some color stuff - NOT USEFUL at the moment
 *
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "colors.h"
#include "global.h"
#include "icons.h"
#include "options.h"

#include <gtk/gtkcontainer.h>

/* define colors for widget styles */

GdkColor red        	= { 0, 0xffff, 0x0000, 0x0000 };
GdkColor blue   	= { 0, 0x0000, 0x0000, 0xffff };
GdkColor green  	= { 0, 0x0000, 0xffff, 0x0000 };
GdkColor yellow 	= { 0, 0xffff, 0xffff, 0x0000 };
GdkColor purple 	= { 0, 0xffff, 0x0000, 0xffff };
GdkColor orange 	= { 0, 0xffff, 0x9999, 0x0000 };
GdkColor cyan   	= { 0, 0x0000, 0xffff, 0xffff };
GdkColor black  	= { 0, 0x0000, 0x0000, 0x0000 };
GdkColor white       	= { 0, 0xffff, 0xffff, 0xffff };
GdkColor dark_green  	= { 0, 0x2c00, 0x6700, 0x0000 };
/* GdkColor ultradark_green= { 0, 0x1700, 0x3500, 0x0000 }; */
GdkColor ultradark_green= { 0, 0x2600, 0x5700, 0x0000 };
/* GdkColor medium_green  	= { 0, 0x6300, 0xa100, 0x3600 }; original - too bright!? */
GdkColor dark_grey  	= { 0, 0x5000, 0x5000, 0x5000 };
GdkColor grey  		= { 0, 0x8000, 0x8000, 0x8000 };
GdkColor medium_green  	= { 0, 0x3f00, 0xa300, 0x1e00 };
GdkColor brown        	= { 0, 0x6800, 0x3500, 0x0400 };
GdkColor dark_yellow	= { 0, 0xec00, 0x8e00, 0x0000 };


/* different styles */

GtkStyle *style_dark_green_background;
GtkStyle *style_notebook_page;
GtkStyle *style_notebook_label;
GtkStyle *style_url_label;


/* create_style  (fg, txt, bg) */

GtkStyle *
create_style (GdkColor fg, GdkColor txt, GdkColor bg)
{
        GtkStyle *defstyle;
        GtkStyle *style;
        int      i;

        /* get default style and make copy of it */
        defstyle = gtk_widget_get_default_style ();
        style    = gtk_style_copy (defstyle);

        /* set the colors for each state */
        for (i=0; i < 5; i++) {
                style -> fg   [i] = fg;
                style -> text [i] = txt;
                style -> bg   [i] = bg;
        }
        return (style);
}

/* create_default_styles */

void
create_default_styles (void)
{
	GdkColormap *cm = gdk_colormap_get_system();

	g_return_if_fail ( cm != NULL );

	gdk_colormap_alloc_color (cm, &red, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &blue, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &green, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &yellow, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &purple, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &orange, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &cyan, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &black, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &white, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &dark_green, FALSE, TRUE);
	gdk_colormap_alloc_color (cm, &medium_green, FALSE, TRUE);

	/* only dark green background for main window, so the logo doesn't look so miserable */
	style_dark_green_background = create_style (white, yellow, dark_green);

	/* medium green for notebook page window (only last parameter matter here!) */
	style_notebook_page             = create_style (yellow, white, medium_green );
	style_notebook_label            = create_style (white, white, white);
	style_url_label                 =  create_style (blue, blue, blue);
}


/* set_style_recursively
 *
 * sets the widget's style to the style and make sure that all the
 * children (if it's a container) are also set to that particular style
 */

void
set_style_recursively (GtkWidget *widget, gpointer data)
{
        GtkStyle *style = (GtkStyle *)data;

	g_return_if_fail (style!=NULL);
	g_return_if_fail (widget!=NULL);

	/* set the style of the widget and if it has children widgets, set all children's style too */
	gtk_widget_set_style (widget, style);	
        if (GTK_IS_CONTAINER (widget))
	{
                gtk_container_foreach (GTK_CONTAINER (widget), set_style_recursively, style);
	}
}


