/***************************************************************************
                          misc_gtk.h  -  description
                             -------------------
    begin                : Fri Nov 29 2002
    copyright            : (C) 2002 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_misc_gtk_included_
#define _ed2k_gui_misc_gtk_included_

#include "icons.h"

#include <gtk/gtkmessagedialog.h>
#include <gtk/gtktooltips.h>
#include <gtk/gtktreeselection.h>

#define COLUMN_NUM_BITS         0x00ffff	/* 16 bits for column width           */
#define COLUMN_INVISIBLE_FLAG   0xff0000	/*  8 bits for flags like 'invisible' */

void    misc_gtk_ok_dialog (GtkMessageType type, const gchar *txt);

void			new_button_pack_and_signal_connect (	GtkWidget **button_ptr,
														GtkWidget *hbox,
														const gchar *label,
														void *click_func,
														gpointer func_data,
														gint pack_start_flag);

void			 new_icon_button_pack_and_signal_connect (	GtkWidget **button_ptr,
															GtkWidget *hbox,
					 										const gchar *text,
															void *click_func,
															gpointer func_data,
															gint pack_start_flag,
															IconName icon);

void              add_new_entry_widget_to_box (GtkWidget    *box,
                                               GtkWidget   **entrywidget,
                                               const gchar  *entrylabel,
                                               guint16       max_length);

GtkWidget        *make_icon_and_label_hbox (const gchar *text, IconName icon);


void              new_highlight_button_pack_and_signal_connect (GtkWidget **box,
                                                                IconName    icon,
                                                                void       *click_func,
                                                                gpointer    func_data);

GtkWidget        *misc_gtk_new_tooltip_label_in_flat_button_box (GtkWidget   **label,
                                                                 const gchar  *tiptext_utf8);


gint              misc_gtk_tree_selection_count_selected_rows (GtkTreeSelection *selection);

GtkWidget        *misc_gtk_attach_new_check_button_to_table ( GtkWidget *table,
                                                              const gchar *checktxt,
                                                              GtkTooltips *tooltips,
                                                              const gchar *tooltxt,
                                                              guint row,
                                                              guint col );

void              misc_gtk_add_menu_item ( GtkWidget *menu,
                                           const gchar *text,
                                           void *callback_func,
                                           gpointer user_data,
                                           IconName icon,
                                           gboolean is_sensitive );


void              misc_gtk_add_submenu ( GtkWidget *menu,
                                         const gchar *text,
                                         IconName icon,
                                         GtkWidget *submenu,
                                         gboolean is_sensitive );

void              misc_gtk_add_menu_separator ( GtkWidget *menu );

void              misc_gtk_add_menu_header    ( GtkWidget   *menu,
                                                const gchar *text,
                                                const gchar *stock_id );


GtkWidget        *misc_gtk_label_new_with_markup ( const gchar *markup_template,
                                                   const gchar *text_locale );

gboolean          misc_gtk_tree_model_get_iter_from_row_reference ( GtkTreeModel *model,
                                                                    GtkTreeRowReference *ref,
                                                                    GtkTreeIter *iter );

GtkTreeRowReference *
                   misc_gtk_tree_model_get_row_reference_from_iter ( GtkTreeModel *model,
                                                                     GtkTreeIter *iter );

void               misc_gtk_free_row_reference (gpointer data);

gboolean           misc_gtk_load_interface (const gchar   *gladefn,  
                                            gboolean       autoconnect_signals,
                                            const gchar   *widget_name1,
                                            GtkWidget    **p_widget1,
                                            ...                        );

#endif


