/***************************************************************************
                          misc_strings.h  -  description
                             -------------------
    begin                : Fri Nov 29 2002
    copyright            : (C) 2002 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_misc_strings_included_
#define _ed2k_gui_misc_strings_included_

#include <glib.h>

#define TO_UTF8(string)                    misc_string_convert_to_utf8(string)

#define FREE_UTF8(string)                  if(string){g_free(string);}

#define UTF8_PRINTF                        misc_string_utf8_printf

#define UTF8_SHORT_PRINTF                  misc_string_utf8_short_printf

#define TO_LOCALE(string)                  misc_strings_utf8_to_locale(string)


void          misc_strings_unescape_url (gchar *s);

gchar        *misc_string_convert_to_utf8(const gchar *string);

gchar        *misc_string_utf8_printf (const gchar *format, ...) G_GNUC_PRINTF(1,2);

const gchar  *misc_string_utf8_short_printf (const gchar *format, ...) G_GNUC_PRINTF(1,2);

const gchar  *misc_string_markup ( const gchar *str,
                                   const gchar *color,
                                   gboolean bold,
                                   gboolean italic );

gchar        *misc_strings_utf8_to_locale (const gchar *utf8);

gchar        *misc_strings_unescape_text (const gchar *text_utf8);

gchar        *misc_strings_escape_ascii_url (const gchar *str);


#endif


