/***************************************************************************
                          options.h  -  description
                             -------------------
    begin                : Sun Mar 16 2003
    copyright            : (C) 2003 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_options_h_included_
#define _ed2k_gui_options_h_included_

#include <glib.h>

typedef enum
{
  OPT_GUI_DOWNLOADS_VERIFY_CANCEL = 0,
  OPT_GUI_VERIFY_EXIT,
  OPT_GUI_SHUTDOWN_CORE_ON_EXIT,
  OPT_GUI_CONNECT_DIALOG_MAKE_VALUES_DEFAULT,
  OPT_GUI_SPAWN_CORE_ON_STARTUP_IF_NEEDED,
  OPT_GUI_AUTO_CONNECT_TO_CORE_ON_STARTUP,
  OPT_GUI_SEARCH_SHOW_OWN_FILES,
  OPT_GUI_SERVERS_ROTATE_INTERVAL,
  OPT_GUI_SERVERS_FETCH_NEW_LIST_WHEN_TOO_FEW,
  OPT_GUI_SERVERS_CLEAR_LIST_BEFORE_FETCHING_NEW_LIST,
  OPT_GUI_DOWNLOAD_ED2K_LINK_IMMEDIATELY,
  OPT_GUI_RESTART_CRASHED_CORE,
  OPT_GUI_SERVERS_DISCONNECT_IF_FIREWALLED,
  OPT_GUI_DOWNLOADS_HIDE_JUNK,
  OPT_GUI_DOWNLOADS_KEEP_EXTENSION_WHEN_HIDING_JUNK,
  OPT_GUI_DOWNLOADS_SHOW_TRANSFERED_IN_PERCENT,
  OPT_GUI_IGNORE_DOUBLE_CLICKS,
  OPT_GUI_SEARCH_SHOW_BLACKLISTED_ITEMS,
  OPT_GUI_SERVERS_IGNORE_QUEUE_DEADLOCKS,
  OPT_GUI_NO_GREEN,
  OPT_GUI_SLOW_GUI_CORE_CONNECTION,
  OPT_GUI_DOWNLOADS_NO_INSUFFICIENT_DISK_SPACE_PAUSE,
  OPT_GUI_STATUS_WINDOW_CLEAR_INTERVAL,
  OPT_GUI_LOG_HAVE_TIMESTAMP,
  OPT_GUI_NO_LINKS_TO_LOGFILE,
  OPT_GUI_DOWNLOADS_BLUE_PROGRESSBAR,
  OPT_GUI_DOWNLOADS_BLACKLIST_ON_DOWNLOAD,
  OPT_GUI_NO_ACTIVE_DOWNLOAD_CANCEL,
  OPT_GUI_NO_APP_ICON,
  OPT_GUI_DOWNLOADS_UNSELECT_ALL_AFTER_ACTION,
  OPT_GUI_DOWNLOADS_SINGLE_SELECTION_MODE,
  OPT_GUI_SERVERS_UNSELECT_ALL_AFTER_ACTION,
  OPT_GUI_SERVERS_SINGLE_SELECTION_MODE,
  OPT_GUI_SEARCH_NOTEBOOK_TAB_POS,
  OPT_GUI_MAIN_NOTEBOOK_TAB_POS,
  OPT_GUI_MAIN_NOTEBOOK_HIDE_TAB_TEXT_LEFT_RIGHT,
  OPT_GUI_LINKHANDLER_ACTION_IF_NO_GUI_RUNNING,
  OPT_GUI_LINKHANDLER_ADD_PAUSED_DEFAULT,
  OPT_GUI_DEFAULT_CORE_HOST,
  OPT_GUI_DEFAULT_CORE_PORT,
  OPT_GUI_DEFAULT_CORE_USER,
  OPT_GUI_DEFAULT_CORE_PASS,
  OPT_GUI_DEFAULT_CORE_BINARY_PATH,
  OPT_GUI_DEFAULT_CORE_COOKIE,
  OPT_GUI_DEFAULT_REMOTE_CONNECT,
  OPT_GUI_SERVERLIST_URL_1,
  OPT_GUI_SERVERLIST_URL_2,
  OPT_GUI_CHANGES_FROM_040_TO_050_SHOWN,
  OPT_GUI_DOWNLOADS_MIN_FREE_DISKSPACE,
  OPT_GUI_SERVERS_AUTO_REMOVE_INVALID,
  OPT_GUI_EXEC_ON_COMPLETE_COMMAND,
  OPT_GUI_ICON_THEME,
  OPT_GUI_MAX_LOGFILE_SIZE,
  OPT_GUI_TOOLBAR_SHOW_SEARCH_OPTIONS,
  OPT_GUI_COLUMN_WIDTHS_DOWNLOADS,
  OPT_GUI_COLUMN_WIDTHS_UPLOADS,
  OPT_GUI_COLUMN_WIDTHS_UPLOAD_STATS,
  OPT_GUI_COLUMN_WIDTHS_SEARCH,
  OPT_GUI_COLUMN_WIDTHS_SERVERS,
  OPT_GUI_COLUMN_WIDTHS_SHARED_FILES,
  OPT_GUI_SORT_TYPE_DOWNLOADS,
  OPT_GUI_SORT_TYPE_UPLOADS,
  OPT_GUI_SORT_TYPE_UPLOAD_STATS,
  OPT_GUI_SORT_TYPE_SEARCH,
  OPT_GUI_SORT_TYPE_SERVERS,
  OPT_GUI_SORT_TYPE_SHARED_FILES,
  OPT_GUI_SORT_TYPE_SHARED_DIRS,
  OPT_GUI_SORT_COL_DOWNLOADS,
  OPT_GUI_SORT_COL_UPLOADS,
  OPT_GUI_SORT_COL_UPLOAD_STATS,
  OPT_GUI_SORT_COL_SEARCH,
  OPT_GUI_SORT_COL_SERVERS,
  OPT_GUI_SORT_COL_SHARED_FILES,
  OPT_GUI_SORT_COL_SHARED_DIRS,
  OPT_GUI_PANE_POS_UPLOADS_PAGE,
  OPT_GUI_PANE_POS_SHARED_PAGE,
  OPT_GUI_WINDOW_POS_X,
  OPT_GUI_WINDOW_POS_Y,
  OPT_GUI_WINDOW_POS_ALLOW_NEGATIVE_VALUES,
  OPT_GUI_WINDOW_WIDTH,
  OPT_GUI_WINDOW_HEIGHT,
  OPT_GUI_WINDOW_SAVE_POS_AND_SIZE,

  OPT_GUI_STATS_TIMELINE_ACTIVE,
  OPT_GUI_STATS_TIMELINE_MODE,
  OPT_GUI_STATS_UP_WRONG,
  OPT_GUI_STATS_UP_CROP,
  OPT_GUI_STATS_DOWN_WRONG,
  OPT_GUI_STATS_DOWN_CROP,

  OPT_GUI_MAX_CONNECTIONS_SEEN,

  OPT_GUI_DOWNLOADS_FILENAMES_BOLD,
  OPT_GUI_SEARCH_FILENAMES_BOLD,

  OPT_GUI_SET_RULES_HINT_ON_LISTS,

  OPT_GUI_SHOW_ICONS_IN_SHARED_FILES_LIST,
  OPT_GUI_SHOW_ICONS_IN_SEARCH_LIST,

  OPT_GUI_USE_APPLET_IF_SUPPORTED,

  OPT_GUI_ICON_SCALING_FACTOR,

  OPT_GUI_RESUME_ONE_PAUSED_DL_ON_COMPLETE,

  OPT_GUI_OVERRIDE_TEMP,
  OPT_GUI_OVERRIDE_TEMP_PATH,

  OPT_NUM_OPTIONS,

  OPT_INVALID = 9999,

} OptNum;


typedef void (*GuiOptNotifyFunc) (OptNum opt);



#define opt_set_str(opt,val)    opt_set(opt,val)

#define opt_set_int(opt,val)    opt_set(opt,GINT_TO_POINTER(val))

#define opt_set_bool(opt,val)   opt_set(opt,GINT_TO_POINTER((val==TRUE)?1:0))

#define opt_get_bool(opt)       (opt_get_int(opt)!=0)

#define opt_toggle_bool(opt)    opt_set_bool(opt,!opt_get_bool(opt))


/* internal gui options (not saved) */

extern guint      option_gui_instance;     /* set via the command line option '-n' */


/* functions */

void              opt_read_from_disk (void);
void              opt_write_to_disk (void);

void              opt_set (OptNum opt, gconstpointer val);

gint              opt_get_int (OptNum num);
const gchar      *opt_get_str (OptNum num);

const gchar      *opt_get_opt_filename (const gchar *fn);
const gchar      *opt_get_opt_filename_without_instance (const gchar *fn);

gboolean          opt_set_prefpath (const gchar *newpath);

void              opt_notify (OptNum opt, GuiOptNotifyFunc func);


#endif






