/*
*   packet.h
*
*   (c) 2001 Tim-Philipp Mueller <t.i.m@orange.net>
*
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ed2k_gui_packet_h_included
#define ed2k_gui_packet_h_included

#include "global.h"
#include "ramfile.h"

gboolean   packet_is_complete (ramfile *packet);
gboolean   packet_header_is_valid (ramfile *packet, guint32 *datalen);
gboolean   packet_append (ramfile **packet, const gchar *buffer, gint length);
ramfile   *packet_get_next_packet_data (ramfile *packet);
guint32    packet_get_data_size (ramfile *packet);
gint       packet_left_from_pos (ramfile *packet);

#endif
