/*
*  signal_handler.c
*
*  SIGNAL HANDLING CONNECTION PART for ed2k_gui
*
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <glib.h>

#ifdef G_OS_UNIX

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include "global.h"   /* for programname */

/*********************************************************************************
* SIGCHLD handler
*
* Let's take care of our children.
* Otherwise, they may get involved with bad ppl
* and become zombies.
*
* Mario Sergio Fujikawa Ferreira <lioux@FreeBSD.org>
* on Mon, 6 May 2002 13:11:51 (GMT-4)
*
**********************************************************************************/

void
sig_chld_handler(int signo)
{
	pid_t   pid;
	int     stat;

	while ((pid = waitpid(-1, &stat, WNOHANG)) > 0);

	return;
}

/*********************************************************************************
* SIGPIPE handler
*
* Let's watch out for ppl that both speak so fast and don't pay
* attention to us that we've already ended the conversation but
* they are still speaking. We ignore the signal but you
* still can deal with it, i.e., errno is to EPIPE.
* 
* Mario Sergio Fujikawa Ferreira <lioux@FreeBSD.org>
* on Mon, 8 Apr 2002 11:43:44 (GMT-4)
*
**********************************************************************************/

void
sig_pipe_ignore_handler(int signo)
{
	/* you could issue a warning here */
        return;
}

/*********************************************************************************
* SIGPIPE block
*
* Let's watch out for ppl that both speak so fast and don't pay
* attention to us that we've already ended the conversation but
* they are still speaking. We will complete block the signal.
* Neither SIGPIPE signal is ever receiver nor errno is set to EPIPE.
* 
* Mario Sergio Fujikawa Ferreira <lioux@FreeBSD.org>
* on Mon, 8 Apr 2002 11:43:44 (GMT-4)
*
**********************************************************************************/

/*
void
sig_pipe_block(void)
{
	sigset_t sigset, sigoset;

	sigemptyset(&sigset);
	sigaddset(&sigset,SIGPIPE);
	(void) sigprocmask(SIG_BLOCK, &sigset, &sigoset);
}
*/

/* sig_segfault_handler
 *
 * show a stacktrace on segfault
 *
 * XXX - why doesn't the exit stuff work? 
 * It just doesn't exit?!
 * gtk_exit(1) doesn't work either, nor does _exit
 */

/*
void
sig_segfault_handler (int signo)
{
	g_print (
		_("****************************************************************\n"
		  "* Sorry, %s segfaulted. Please send the following\n"
		  "* stack trace by e-mail to tim@edonkey2000.com if there is one,\n"
		  "* so that I can try to debug this problem. Thank you and sorry\n"
		  "* for the inconvenience.\n"), programname);
	g_print ("****************************************************************\n");
	g_on_error_stack_trace (programname);

	exit (1);	
}
*/


#endif /* G_OS_UNIX */



