/*
*  status_page.h
*
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ED2K_GUI_STATUS_PAGE_H_INCLUDED_
#define _ED2K_GUI_STATUS_PAGE_H_INCLUDED_

#include <gtk/gtkwidget.h>

/* Our own new and improved error function:
 * outputs to stderr + does status_warning() */
void       gui_print_error_function (const gchar *errstring);

/* status message output */
void       status_msg (const gchar *format, ...) G_GNUC_PRINTF(1,2);
void       status_warning (const gchar *format, ...) G_GNUC_PRINTF(1,2);
void       status_message_blue (const gchar *format, ...) G_GNUC_PRINTF(1,2);
void       status_system_error_msg (const gchar *msg_text);
void       status_parse_error_msg (const gchar *infile, gint lineno, const gchar *linestring);
void       status_msg_print_ed2klink (const gchar *filename, guint size, const guint8* hash);

GtkWidget *status_page_create (void);

void       status_page_clear (void);

void       status_page_print_clientID_info (const gchar *idstring);


#endif
