/***************************************************************************
 *
 *   uploads_page.c
 *
 *   populates upload page in notepad
 *
 *   (c) 2001-2003 Tim-Philipp Muller < t.i.m at orange.net >
 *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "colors.h"
#include "core-conn.h"
#include "global.h"
#include "options.h"
#include "misc_strings.h"
#include "uploads.h"
#include "uploads_page.h"
#include "uploadstats.h"

#include <gtk/gtkhbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkvpaned.h>

/* variables */

static GtkWidget	*ulpanedwin2 = NULL;

/* functions */

static GtkWidget    *uploads_page_create_stats_label (void);


/***************************************************************************
 *
 *   uploads_page_onClientStats
 *
 ***************************************************************************/

static void
uploads_page_onClientStats (GtkWidget *slabel,
                            gfloat     temp,
                            gfloat     incoming,
                            gfloat     needed,
                            guint      clientid,
                            guint      connections,
                            guint      num_on_queue,
                            gpointer   data)
{
	if (GTK_IS_LABEL(slabel))
		gtk_label_set_text (GTK_LABEL(slabel), UTF8_SHORT_PRINTF(_(" Uploads - %u on queue "), num_on_queue));
}


/***************************************************************************
 *
 *   uploads_page_create_stats_label
 *
 ***************************************************************************/

static GtkWidget *
uploads_page_create_stats_label (void)
{
	GtkWidget	*hbox, *emptylabel, *stats_label;

	hbox = gtk_hbox_new(FALSE,0);
	gtk_widget_show(hbox);

	emptylabel = gtk_label_new(" ");
	gtk_widget_show(emptylabel);

	stats_label = gtk_label_new (UTF8_SHORT_PRINTF("%s",_(" Uploads ")));
	gtk_label_set_justify (GTK_LABEL(stats_label), GTK_JUSTIFY_LEFT);
	gtk_widget_show(stats_label);

	gtk_box_pack_start (GTK_BOX(hbox), stats_label, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(hbox), emptylabel, TRUE, TRUE, 0);

	g_object_set_data_full (G_OBJECT(stats_label), "foo1", &stats_label, (GDestroyNotify)g_nullify_pointer);

	if (!opt_get_bool(OPT_GUI_NO_GREEN))
		set_style_recursively (hbox, style_notebook_label);

	g_signal_connect_swapped(core, "client-stats", (GCallback) uploads_page_onClientStats, stats_label);

	return hbox;
}

/******************************************************************************
 *
 *   uploads_page_onPanedHandlePositionChanged
 *
 *   Called when an object property changes (here we are interested in
 *    the "position" one).
 *
 ******************************************************************************/

static void
uploads_page_onPanedHandlePositionChanged (GObject *obj, GParamSpec *pspec, gpointer data)
{
	opt_set_int (OPT_GUI_PANE_POS_UPLOADS_PAGE, gtk_paned_get_position(GTK_PANED(obj)));
}


/******************************************************************************
 *
 *   uploads_page_create
 *
 ***/

GtkWidget *
uploads_page_create (void)
{
	GtkWidget *vbox, *ulstatslabel;

	vbox = gtk_vbox_new(FALSE,0);

	gtk_widget_show(vbox);

	ulstatslabel = uploads_page_create_stats_label();

	gtk_box_pack_start (GTK_BOX(vbox), ulstatslabel, FALSE, FALSE, 0);

	ulpanedwin2 = gtk_vpaned_new ();

	g_object_set_data_full (G_OBJECT(ulpanedwin2), "foo1",
	                        &ulpanedwin2, (GDestroyNotify)g_nullify_pointer);

	gtk_widget_show (ulpanedwin2);

	gtk_paned_add1 (GTK_PANED(ulpanedwin2), uploads_create_store_model_and_view());

	gtk_paned_add2 (GTK_PANED(ulpanedwin2), uploadstats_create_store_model_and_view());

	gtk_paned_set_position (GTK_PANED(ulpanedwin2), opt_get_int(OPT_GUI_PANE_POS_UPLOADS_PAGE));

	gtk_box_pack_start (GTK_BOX(vbox), ulpanedwin2, TRUE, TRUE,0);

	g_signal_connect(ulpanedwin2, "notify::position", (GCallback) uploads_page_onPanedHandlePositionChanged, NULL);

	return vbox;
}



