/***************************************************************************
 *   Copyright (C) 2004 by Rmi Flament                                    *
 *   remipouak@yahoo.fr                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qtable.h>

#include "cmainwindow.h"
#include <qradiobutton.h>
#include <qspinbox.h>
#include <klineedit.h>
#include <krestrictedline.h>

CMainWindow::CMainWindow(QWidget* parent, const char* name, WFlags fl)
    : MainWindow(parent,name,fl)
{
    newSlot();
}

CMainWindow::~CMainWindow()
{}

int puissance(int nb,int puiss)
{
if (puiss==0) return 1;
return nb*puissance(nb,puiss-1);
}

/*$SPECIALIZATION$*/
void CMainWindow::enterPressed( )
{
QString ip=kRestrictedLine1->text();
QHostAddress test;
if (test.setAddress(ip))
	{
	updateAddressTab(test);
	char c=getAddressClass(test);
	switch (c)
		{
		case 'A': classA->setChecked(TRUE);break;
		case 'B': classB->setChecked(TRUE);break;
		case 'C': classC->setChecked(TRUE);break;
		default: break;
		}
	updateSubnetTab();
	}
}

int CMainWindow::getAdressBitsForClass(unsigned char c)
{
if (c=='A') return 24;
if (c=='B') return 16;
if (c=='C') return 8;
return 0;
}

void CMainWindow::fillTable()
{
QString ip=kRestrictedLine1->text();
int bitsSubnet=spinBox1->value();
QHostAddress test;
if (test.setAddress(ip))
	{	
	int nbBits=getAdressBitsForClass(getAddressClass(test));
	unsigned long addr=test.ip4Addr();
	int nb_hosts=puissance(2,nbBits-bitsSubnet)-2;
	int nb_subnets=puissance(2,bitsSubnet);
	table1->setNumRows(nb_subnets);
	for (int i=0;i<nb_subnets;i++)
		{
		int first=((0xFFFFFFFF<<nbBits)&addr)+(i*(nb_hosts+2))+1;
		int last=((0xFFFFFFFF<<nbBits)&addr)+((i+1)*(nb_hosts+2))-2;	
		QString range=QHostAddress(first).toString()+" - "+QHostAddress(last).toString();
		table1->setText(i,0,range);
		table1->setText(i,1,QHostAddress(first-1).toString());
		table1->setText(i,2,QHostAddress(last+1).toString());
		}
	
	} 
}


void CMainWindow::updateSubnetTab()
{
int nbBits=0;

QHostAddress addr;
unsigned char ipclass=0;
bool ipok=false;
if (addr.setAddress(kRestrictedLine1->text()))
	{
	ipok=true;
	ipclass=getAddressClass(addr);
	}


if (classA->isChecked())
	{
	nbBits=24;
	if (ipclass!='A' && ipok)
		{
		unsigned long temp=addr.ip4Addr();
		temp=(0x00FFFFFF&temp)|0x01000000;
		addr.setAddress(temp);
		kRestrictedLine1->setText(addr.toString());
		}
	}
if (classB->isChecked())
	{
	nbBits=16;
	if (ipclass!='B' && ipok)
		{
		unsigned long temp=addr.ip4Addr();
		temp=(0x00FFFFFF&temp)|0x80000000;
		addr.setAddress(temp);
		kRestrictedLine1->setText(addr.toString());
		}
	}
if (classC->isChecked())
	{
	nbBits=8;
	if (ipclass!='C' && ipok)
		{
		unsigned long temp=addr.ip4Addr();
		temp=(0x00FFFFFF&temp)|0xC0000000;
		addr.setAddress(temp);
		kRestrictedLine1->setText(addr.toString());
		}
	}
spinBox1->setMaxValue(nbBits-2);
int bitsSubnet=spinBox1->value();
int nb_subnets=puissance(2,bitsSubnet);

int nb_hosts=puissance(2,nbBits-bitsSubnet)-2;
unsigned long mask=0xFFFFFFFF<<(nbBits-bitsSubnet);

nbSubnet->setText(QString::number(nb_subnets));
nbHosts->setText(QString::number(nb_hosts,10));
maskSubnet->setText(QHostAddress(mask).toString());
maskSubnet2->setText(QHostAddress(mask).toString());
networkBits->setText(QString::number(32-nbBits+bitsSubnet));

}

void CMainWindow::updateAddressTab()
{
QString ip=kRestrictedLine1->text();
QHostAddress test;
if (test.setAddress(ip))
	{
	updateAddressTab(test);
	}

}

void CMainWindow::updateAddressTab(QHostAddress &IPAddr)
{
	int nbBits=getAdressBitsForClass(getAddressClass(IPAddr));
	unsigned long addr=IPAddr.ip4Addr();
	int bitsSubnet=spinBox1->value();
	int nb_hosts=puissance(2,nbBits-bitsSubnet)-2;
	int last=addr&(0xFFFFFFFF>>(32-nbBits));
	int pos=last/(nb_hosts+2);
	int first=((0xFFFFFFFF<<nbBits)&addr)+(pos*(nb_hosts+2)+1);
	last=((0xFFFFFFFF<<nbBits)&addr)+(pos*(nb_hosts+2)+nb_hosts);
	IPrange->setText(QHostAddress(first).toString()+" - "+QHostAddress(last).toString());
	fillTable();
}

char CMainWindow::getAddressClass(QHostAddress &addr)
{
unsigned char firstByte=(addr.ip4Addr()&0xFF000000)>>24;

	if (firstByte<127)
		{
		return 'A';
		}
	else if (firstByte<192)
		{
		return 'B';
		}
	else 
		{
		return 'C';
		}
}

void CMainWindow::newSlot( )
{
updateSubnetTab();
updateAddressTab();
}




#include "cmainwindow.moc"

