/***************************************************************************
 *   Copyright (C) 2005-2006 by Conrad Hoffmann                            *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* KTTSD PLUGIN FOR THE KOPETE KDE INSTANT MESSANGER
 *
 * base class header
 *
 */

#ifndef KOPETE_KTTS_PLUGIN_H
#define KOPETE_KTTS_PLUGIN_H

#include <qdict.h>
#include <qstring.h>

#include <kspeech_stub.h>

#include <kopeteplugin.h>
#include <kopeteonlinestatus.h>

class KopeteKttsUserPrefs;


class KopeteKttsPlugin : public Kopete::Plugin, public KSpeech_stub
{
	Q_OBJECT

public:
	static KopeteKttsPlugin* self();

	KopeteKttsPlugin( QObject* parent, const char* name, const QStringList& args );
	~KopeteKttsPlugin();
	void testSpeechOutput();

private:
	static KopeteKttsPlugin* pluginStatic_;

	void initialize();
	void readMessage( QString message );
	void announceStatusChange( KopeteKttsUserPrefs* prefs, QString statusDescription );
	void announceIncomingMessage( KopeteKttsUserPrefs* prefs );

	KopeteKttsUserPrefs* getUserPrefs( Kopete::MetaContact* mc );
	QDict<KopeteKttsUserPrefs> userPrefs;
	QPtrList<Kopete::ChatSession> freshSessions;

private slots:
	void slotSessionCreated( Kopete::ChatSession* session );
	void slotIncomingMessage( Kopete::Message& msg );
	void slotOutgoingMessage( Kopete::Message& msg );
	void slotOnlineStatusChanged( Kopete::MetaContact* mc, Kopete::OnlineStatus::StatusType status );
	void slotMetaContactAdded( Kopete::MetaContact* mc );
	void slotSettingsChanged();
	void slotShowUserPrefsDialog();

};

#endif
