/***************************************************************************
 *   Copyright (C) 2005-2006 by Conrad Hoffmann                            *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* KTTS PLUGIN FOR THE KOPETE KDE INSTANT MESSANGER
 *
 * KConfigXT preferences base class implementation
 *
 */

#include <qlayout.h>

#include <kgenericfactory.h>

#include "kopetekttsprefsbase.h"
#include "kopetekttsprefs.h"
#include "kopete_ktts.h"

typedef KGenericFactory<KopeteKttsPrefs> KopeteKttsPrefsFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_ktts, KopeteKttsPrefsFactory( "kcm_kopete_ktts" ) )


KopeteKttsPrefs::KopeteKttsPrefs( QWidget* parent, const char* /*name*/, const QStringList& args )
		: KCModule( KopeteKttsPrefsFactory::instance(), parent, args )
{
	// just tell Kconfig what widget to use... all the magic is done by KConfigTX
	m_preferencesDialog = new KopeteKttsPrefsUI(this);
	( new QVBoxLayout( this ) )->setAutoAdd( true );
	KopeteKttsKcfg::self()->readConfig();
	this->addConfig( KopeteKttsKcfg::self(), m_preferencesDialog );
	load();
}

#include "kopetekttsprefs.moc"

