/***************************************************************************
 *   Copyright (C) 2005-2006 by Conrad Hoffmann                            *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* KTTS PLUGIN FOR THE KOPETE KDE INSTANT MESSANGER 
 *
 * contact specific settings base class implementation
 *
 */ 


#include <qstring.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <kdebug.h>

#include <kopetemetacontact.h>

#include "kopetekttsuserprefs.h"
#include "kopetekttsuserprefsui.h"
#include "kopetekttsplugin.h"
#include "kopete_ktts.h"


KopeteKttsUserPrefs::KopeteKttsUserPrefs( Kopete::MetaContact* mc ) : QObject(),
		metaContact( mc )
{
	loadConfig();
	this->contactSettingsDialog = new KopeteKttsUserPrefsUI();

	QObject::connect( this->contactSettingsDialog->btOK, SIGNAL( pressed() ), this, SLOT( slotOkButtonPressed() ) );
	QObject::connect( contactSettingsDialog->btCancel, SIGNAL( pressed() ), this, SLOT( slotCancelButtonPressed() ) );
}


QString KopeteKttsUserPrefs::bool2string( bool b )
{
	return ( b ? "true" : "false" );
}


bool KopeteKttsUserPrefs::string2bool( QString s )
{
	return ( s == "true" ? true : false );
}


void KopeteKttsUserPrefs::showContactSettingsDialog()
{
	// set the content acoording to the current configuration...
	this->contactSettingsDialog->cbOverrideUseSpeech->setChecked( this->overrideUseSpeech );
	this->contactSettingsDialog->cbUseSpeech->setChecked( this->useSpeech );
	this->contactSettingsDialog->cbOverrideAnnounceIncomingMessages->setChecked( this->overrideAnnounceIncomingMessages );
	this->contactSettingsDialog->cbAnnounceIncomingMessages->setChecked( this->announceIncomingMessages );
	this->contactSettingsDialog->cbOverrideAnnounceIncomingMessagesOnlyOnce->setChecked( this->overrideAnnounceIncomingMessagesOnlyOnce );
	this->contactSettingsDialog->cbAnnounceIncomingMessagesOnlyOnce->setChecked( this->announceIncomingMessagesOnlyOnce );
	this->contactSettingsDialog->cbOverrideReadIncomingMessages->setChecked( this->overrideReadIncomingMessages );
	this->contactSettingsDialog->cbReadIncomingMessages->setChecked( this->readIncomingMessages );
	this->contactSettingsDialog->cbOverrideReadIncomingMessagesOnlyOnce->setChecked( this->overrideReadIncomingMessagesOnlyOnce );
	this->contactSettingsDialog->cbReadIncomingMessagesOnlyOnce->setChecked( this->readIncomingMessagesOnlyOnce );
	this->contactSettingsDialog->cbOverrideReadOutgoingMessages->setChecked( this->overrideReadOutgoingMessages );
	this->contactSettingsDialog->cbReadOutgoingMessages->setChecked( this->readOutgoingMessages );
	this->contactSettingsDialog->cbOverrideAnnouncementText->setChecked( this->overrideAnnouncementText );
	this->contactSettingsDialog->editAnnouncementText->setText( this->announcementText );
	this->contactSettingsDialog->cbOverrideAnnounceStatusChanges->setChecked( this->overrideAnnounceStatusChanges );
	this->contactSettingsDialog->cbAnnounceStatusChanges->setChecked( this->announceStatusChanges );
	this->contactSettingsDialog->cbUseFakeName->setChecked( this->overrideName );
	this->contactSettingsDialog->editFakeName->setText( this->fakeName );

	this->contactSettingsDialog->show();
}


void KopeteKttsUserPrefs::loadConfig()
{
	// These sure aren't very nice to read, but save a lot of lines...
	// Check if the override flag for a specific setting is set for this contact, if so, assign the chosen value, else the plugin global default...
	this->overrideUseSpeech = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideUseSpeech" ) );
	this->useSpeech = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "useSpeech" ) );
	
	this->overrideAnnounceIncomingMessages = KopeteKttsUserPrefs::string2bool(this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideAnnounceIncomingMessages" ) );
	this->announceIncomingMessages = KopeteKttsUserPrefs::string2bool(this->metaContact->pluginData( KopeteKttsPlugin::self(), "announceIncomingMessages" ) );
	this->overrideAnnounceIncomingMessagesOnlyOnce = KopeteKttsUserPrefs::string2bool(this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideAnnounceIncomingMessagesOnlyOnce" ) );
	this->announceIncomingMessagesOnlyOnce = KopeteKttsUserPrefs::string2bool(this->metaContact->pluginData( KopeteKttsPlugin::self(), "announceIncomingMessagesOnlyOnce" ) );

	this->overrideReadIncomingMessages = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideReadIncomingMessages" )  );
	this->readIncomingMessages = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "readIncomingMessages" ) );
	this->overrideReadIncomingMessagesOnlyOnce = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideReadIncomingMessagesOnlyOnce" )  );
	this->readIncomingMessagesOnlyOnce = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "readIncomingMessagesOnlyOnce" ) );

	this->overrideReadOutgoingMessages = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideReadOutgoingMessages" )  );
	this->readOutgoingMessages = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "readOutgoingMessages" ) );

	this->overrideAnnouncementText = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideAnnouncementText" ) );
	this->announcementText = this->metaContact->pluginData( KopeteKttsPlugin::self(), "announcementText" );
	if ( this->announcementText.isEmpty() )
	{
		this->announcementText = KopeteKttsKcfg::announcementText();
	}

	this->overrideAnnounceStatusChanges = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "overrideAnnounceStatusChanges" ) );
	this->announceStatusChanges = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "announceStatusChanges" ) );

	this->overrideName = KopeteKttsUserPrefs::string2bool( this->metaContact->pluginData( KopeteKttsPlugin::self(), "useFakeName" ) );
	this->fakeName = this->metaContact->pluginData( KopeteKttsPlugin::self(), "fakeName" );
	if ( this->fakeName.isEmpty() )
	{
		this->fakeName = this->metaContact->displayName();
	}
}


void KopeteKttsUserPrefs::saveConfig()
{
	// just the kind of code you love to write...
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideUseSpeech", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideUseSpeech->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "useSpeech", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbUseSpeech->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideAnnounceIncomingMessages", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideAnnounceIncomingMessages->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "announceIncomingMessages", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbAnnounceIncomingMessages->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideAnnounceIncomingMessagesOnlyOnce", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideAnnounceIncomingMessagesOnlyOnce->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "announceIncomingMessagesOnlyOnce", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbAnnounceIncomingMessagesOnlyOnce->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideReadIncomingMessages", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideReadIncomingMessages->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "readIncomingMessages", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbReadIncomingMessages->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideReadIncomingMessagesOnlyOnce", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideReadIncomingMessagesOnlyOnce->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "readIncomingMessagesOnlyOnce", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbReadIncomingMessagesOnlyOnce->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideReadOutgoingMessages", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideReadOutgoingMessages->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "readOutgoingMessages", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbReadOutgoingMessages->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideAnnouncementText", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideAnnouncementText->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "announcementText", this->contactSettingsDialog->editAnnouncementText->text() );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "overrideAnnounceStatusChanges", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbOverrideAnnounceStatusChanges->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "announceStatusChanges", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbAnnounceStatusChanges->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "useFakeName", KopeteKttsUserPrefs::bool2string( this->contactSettingsDialog->cbUseFakeName->isChecked() ) );
	this->metaContact->setPluginData( KopeteKttsPlugin::self(), "fakeName", this->contactSettingsDialog->editFakeName->text() );

	// and reload these new values into the current config... i am so lazy...
	loadConfig();
}


void KopeteKttsUserPrefs::slotOkButtonPressed()
{
	saveConfig();
	this->contactSettingsDialog->hide();
}


void KopeteKttsUserPrefs::slotCancelButtonPressed()
{
	this->contactSettingsDialog->hide();
}

//
// GETTER
// for convenience, they return the global value if override is not set.
//
bool KopeteKttsUserPrefs::getUseSpeech()
{
	return ( this->overrideUseSpeech ? this->useSpeech : KopeteKttsKcfg::enableGlobalSpeechOutput() );
}

bool KopeteKttsUserPrefs::getAnnounceIncomingMessages()
{
	return ( this->overrideAnnounceIncomingMessages ? this->announceIncomingMessages : KopeteKttsKcfg::announceIncomingMessages() );
}

bool KopeteKttsUserPrefs::getAnnounceIncomingMessagesOnlyOnce()
{
	return ( this->overrideAnnounceIncomingMessagesOnlyOnce ? this->announceIncomingMessagesOnlyOnce : KopeteKttsKcfg::announceIncomingMessagesOnlyOnce() );
}

bool KopeteKttsUserPrefs::getReadIncomingMessages()
{
	return ( this->overrideReadIncomingMessages ? this->readIncomingMessages : KopeteKttsKcfg::readIncomingMessages() );
}

bool KopeteKttsUserPrefs::getReadIncomingMessagesOnlyOnce()
{
	return ( this->overrideReadIncomingMessagesOnlyOnce ? this->readIncomingMessagesOnlyOnce : KopeteKttsKcfg::readIncomingMessagesOnlyOnce() );
}

bool KopeteKttsUserPrefs::getReadOutgoingMessages()
{
	return ( this->overrideReadOutgoingMessages ? this->readOutgoingMessages : KopeteKttsKcfg::readOutgoingMessages() );
}

bool KopeteKttsUserPrefs::getAnnounceStatusChanges()
{
	return ( this->overrideAnnounceStatusChanges ? this->announceStatusChanges : KopeteKttsKcfg::announceStatusChanges() );
}

QString KopeteKttsUserPrefs::getAnnouncementText()
{
	return ( this->overrideAnnouncementText? this->announcementText : KopeteKttsKcfg::announcementText() );
}

QString KopeteKttsUserPrefs::getName()
{
	return ( this->overrideName ? this->fakeName : this->metaContact->displayName() );
}


#include "kopetekttsuserprefs.moc"
