/***************************************************************************
 *   Copyright (C) 2005-2006 by Conrad Hoffmann                            *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* KTTS PLUGIN FOR THE KOPETE KDE INSTANT MESSANGER
 *
 * contact specific settings base class header
 *
 */


#ifndef KOPETE_KTTS_USER_PREFS_H
#define KOPETE_KTTS_USER_PREFS_H

#include <qobject.h>

class QString;
class Kopete::MetaContact;
class KopeteKttsUserPrefsUI;

class KopeteKttsUserPrefs : public QObject
{
	Q_OBJECT

public:
	KopeteKttsUserPrefs( Kopete::MetaContact* mc );
	void showContactSettingsDialog();
	bool getUseSpeech();
	bool getAnnounceStatusChanges();
	bool getAnnounceIncomingMessages();
	bool getAnnounceIncomingMessagesOnlyOnce();
	bool getReadIncomingMessages();
	bool getReadIncomingMessagesOnlyOnce();
	bool getReadOutgoingMessages();
	QString getAnnouncementText();
	QString getName();

private:
	void loadConfig();
	void saveConfig();

	KopeteKttsUserPrefsUI* contactSettingsDialog;
	Kopete::MetaContact* metaContact;

	bool overrideUseSpeech;
	bool useSpeech;
	bool overrideAnnounceIncomingMessages;
	bool announceIncomingMessages;
	bool overrideAnnounceIncomingMessagesOnlyOnce;
	bool announceIncomingMessagesOnlyOnce;
	bool overrideReadIncomingMessages;
	bool readIncomingMessages;
	bool overrideReadIncomingMessagesOnlyOnce;
	bool readIncomingMessagesOnlyOnce;
	bool readOutgoingMessages;
	bool overrideReadOutgoingMessages;
	bool overrideAnnounceStatusChanges;
	bool announceStatusChanges;
	bool overrideAnnouncementText;
	bool overrideName;
	QString announcementText;
	QString fakeName;

	static QString bool2string( bool b );
	static bool string2bool( QString s );

protected slots:
	void slotOkButtonPressed();
	void slotCancelButtonPressed();
};

#endif

