/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.blowfishj;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import net.sourceforge.blowfishj.BlowfishCBC;
import net.sourceforge.blowfishj.SHA1;

public class BlowfishOutputStream
extends OutputStream {
    OutputStream m_os;
    BlowfishCBC m_bfc;
    byte[] m_bufIn;
    byte[] m_bufOut;
    int m_nBytesInBuf;

    void init(byte[] key, int nOfs, int nLen, OutputStream os) throws IOException {
        this.m_os = os;
        this.m_nBytesInBuf = 0;
        SHA1 sh = new SHA1();
        sh.update(key, nOfs, nLen);
        sh.finalize();
        byte[] ckey = sh.getDigest();
        sh.clear();
        this.m_bfc = new BlowfishCBC(ckey, 0, ckey.length);
        Arrays.fill(ckey, 0, ckey.length, (byte)0);
        this.m_bufIn = new byte[8];
        this.m_bufOut = new byte[8];
        SecureRandom srnd = new SecureRandom();
        srnd.nextBytes(this.m_bufIn);
        this.m_os.write(this.m_bufIn, 0, this.m_bufIn.length);
        this.m_bfc.setCBCIV(this.m_bufIn, 0);
    }

    public BlowfishOutputStream(byte[] key, int nOfs, int nLen, OutputStream os) throws IOException {
        this.init(key, nOfs, nLen, os);
    }

    public BlowfishOutputStream(String sPassPhrase, OutputStream os) throws IOException {
        int nC = sPassPhrase.length();
        byte[] key = new byte[nC];
        for (int nI = 0; nI < nC; ++nI) {
            key[nI] = (byte)(sPassPhrase.charAt(nI) & 0xFF);
        }
        this.init(key, 0, nC, os);
    }

    public void write(int nByte) throws IOException {
        ++this.m_nBytesInBuf;
        if (this.m_nBytesInBuf < this.m_bufIn.length) {
            this.m_bufIn[this.m_nBytesInBuf - 1] = (byte)nByte;
            return;
        }
        this.m_bufIn[this.m_nBytesInBuf - 1] = (byte)nByte;
        this.m_nBytesInBuf = 0;
        this.m_bfc.encrypt(this.m_bufIn, 0, this.m_bufOut, 0, this.m_bufIn.length);
        this.m_os.write(this.m_bufOut, 0, this.m_bufOut.length);
    }

    public void close() throws IOException {
        byte nPadVal = (byte)(this.m_bufIn.length - this.m_nBytesInBuf);
        while (this.m_nBytesInBuf < this.m_bufIn.length) {
            this.m_bufIn[this.m_nBytesInBuf] = nPadVal;
            ++this.m_nBytesInBuf;
        }
        this.m_bfc.encrypt(this.m_bufIn, 0, this.m_bufOut, 0, this.m_bufIn.length);
        this.m_os.write(this.m_bufOut, 0, this.m_bufOut.length);
        this.m_os.close();
        this.m_bfc.cleanUp();
    }

    public void flush() throws IOException {
        this.m_os.flush();
    }
}

