/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.TreeNode;
import net.sourceforge.rssowl.controller.panel.BrowserPanel;
import net.sourceforge.rssowl.controller.sort.SortingSelectionAdapter;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.model.TableData;
import net.sourceforge.rssowl.model.TableItemData;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class NewsTable
implements ITranslatable {
    private static final String[] columnOrder = new String[]{"TABLE_HEADER_STATUS", "TABLE_HEADER_NEWSTITLE", "TABLE_HEADER_PUBDATE", "TABLE_HEADER_AUTHOR", "TABLE_HEADER_CATEGORY", "TABLE_HEADER_PUBLISHER", "TABLE_HEADER_FEED"};
    private MenuItem addFeedToFav;
    private MenuItem blogNews;
    private MenuItem copyUrlItem;
    private MenuItem generateHTML;
    private MenuItem generatePDF;
    private MenuItem generateRTF;
    private MenuItem mailLinkToFriend;
    private MenuItem markAllReadItem;
    private MenuItem markUnreadItem;
    private MenuItem reloadFeed;
    private MenuItem searchFeed;
    private CTabItem tabItem;
    private Menu tableMenu;
    EventManager eventManager;
    boolean isNewsSelected;
    String language;
    GUI rssOwlGui;
    private MenuItem exportItem;

    public NewsTable(GUI gUI, CTabItem cTabItem, EventManager eventManager) {
        this.rssOwlGui = gUI;
        this.tabItem = cTabItem;
        this.eventManager = eventManager;
        this.isNewsSelected = true;
        this.language = Dictionary.selectedLanguage;
    }

    public void setTabItem(CTabItem cTabItem) {
        this.tabItem = cTabItem;
    }

    public static void fillTable(Table table, Hashtable hashtable, Vector vector, Vector vector2, boolean bl) {
        NewsTable.fillTable(table, hashtable, vector, vector2, bl, new int[]{0});
    }

    public static void fillTable(Table table, Hashtable hashtable, Vector vector, Vector vector2, boolean bl, int[] nArray) {
        int n;
        for (n = 0; n < vector.size(); ++n) {
            NewsItem newsItem = (NewsItem)hashtable.get(vector.get(n));
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(1, newsItem.getTitle());
            tableItem.setData(TableItemData.createNewsheaderData(newsItem.isRead()));
            NewsTable.updateTableItemStyle(tableItem);
            int n2 = 2;
            if (vector2.contains("TABLE_HEADER_PUBDATE")) {
                if (newsItem.getPubDate() != null) {
                    if (newsItem.getPubDateParsed() != null) {
                        tableItem.setText(n2, DateParser.formatDate(newsItem.getPubDateParsed(), true));
                    } else {
                        tableItem.setText(n2, newsItem.getPubDate());
                    }
                } else {
                    tableItem.setText(n2, "-");
                }
                ++n2;
            }
            if (vector2.contains("TABLE_HEADER_AUTHOR")) {
                if (newsItem.getAuthor() != null) {
                    tableItem.setText(n2, newsItem.getAuthor().replaceAll("mailto:", ""));
                } else {
                    tableItem.setText(n2, "-");
                }
                ++n2;
            }
            if (vector2.contains("TABLE_HEADER_CATEGORY")) {
                if (newsItem.getCategory() != null) {
                    tableItem.setText(n2, newsItem.getCategory());
                } else {
                    tableItem.setText(n2, "-");
                }
                ++n2;
            }
            if (vector2.contains("TABLE_HEADER_PUBLISHER")) {
                if (newsItem.getPublisher() != null) {
                    tableItem.setText(n2, newsItem.getPublisher());
                } else {
                    tableItem.setText(n2, "-");
                }
                ++n2;
            }
            if (vector2.contains("TABLE_HEADER_FEED")) {
                if (newsItem.getNewsfeedTitle() != null) {
                    tableItem.setText(n2, newsItem.getNewsfeedTitle());
                } else {
                    tableItem.setText(n2, "-");
                }
                ++n2;
            }
            if (bl) continue;
            newsItem.clearHighlightWords();
            newsItem.setRequiresViewUpdate(true);
        }
        if (nArray[0] == 0) {
            for (n = 0; n < table.getColumnCount(); ++n) {
                table.getColumn(n).pack();
            }
        } else {
            for (n = 0; n < table.getColumnCount(); ++n) {
                table.getColumn(n).setWidth(nArray[n]);
            }
        }
    }

    public static void fillTableColumns(Table table, Hashtable hashtable, Vector vector, Vector vector2, boolean bl) {
        TableData tableData = TableData.createTableData();
        for (int i = 0; i < columnOrder.length; ++i) {
            if (!vector2.contains(columnOrder[i])) continue;
            boolean bl2 = columnOrder[i].equals("TABLE_HEADER_STATUS");
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setData(columnOrder[i]);
            if (!bl2) {
                tableColumn.setText(GUI.i18n.getTranslation(columnOrder[i]));
            }
            if (bl2) {
                tableColumn.setResizable(false);
                tableColumn.setToolTipText(GUI.i18n.getTranslation(columnOrder[i]));
            }
            SortingSelectionAdapter sortingSelectionAdapter = new SortingSelectionAdapter(table, hashtable, vector, vector2, bl);
            tableColumn.addSelectionListener(sortingSelectionAdapter);
            tableData.addColumnSorter(sortingSelectionAdapter, columnOrder[i]);
            tableData.addColumn(tableColumn, columnOrder[i]);
        }
        table.setData(tableData);
    }

    static void actionDisplayNextNews(boolean bl) {
        Object object;
        int n;
        CTabFolder cTabFolder = GUI.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder();
        int n2 = cTabFolder.getSelectionIndex();
        if (n2 >= 0 && NewsTable.actionDisplayNextNews(cTabFolder.getSelection(), bl)) {
            return;
        }
        int n3 = cTabFolder.getItemCount();
        for (n = n2 + 1; n < n3; ++n) {
            if (!NewsTable.actionDisplayNextNews(cTabFolder.getItem(n), bl)) continue;
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (!NewsTable.actionDisplayNextNews(cTabFolder.getItem(n), bl)) continue;
            return;
        }
        if (GUI.rssOwlGui.getRSSOwlFavoritesTree().getFavoritesTree().getSelectionCount() > 0) {
            TreeItem treeItem = GUI.rssOwlGui.getRSSOwlFavoritesTree().getFavoritesTree().getSelection()[0];
            object = new TreeNode(treeItem, bl);
            while (object != null && WidgetShop.isset(((TreeNode)object).getItem())) {
                TreeItem treeItem2 = ((TreeNode)object).getItem();
                if (NewsTable.actionDisplayNextNews(treeItem2, bl, false)) {
                    return;
                }
                if (((TreeNode)object).hasChildNodes()) {
                    object = ((TreeNode)object).getFirstChild();
                    continue;
                }
                while (object != null && ((TreeNode)object).getNextSibling() == null) {
                    object = ((TreeNode)object).getParent();
                }
                if (object == null) continue;
                object = ((TreeNode)object).getNextSibling();
            }
        }
        Tree tree = GUI.rssOwlGui.getRSSOwlFavoritesTree().getFavoritesTree();
        object = tree.getItems();
        for (int i = 0; i < ((TreeItem[])object).length; ++i) {
            if (!NewsTable.actionDisplayNextNews(object[i], bl, true)) continue;
            return;
        }
    }

    static boolean actionDisplayNextNews(TreeItem treeItem, boolean bl, boolean bl2) {
        TreeItemData treeItemData = (TreeItemData)treeItem.getData();
        if (!(treeItemData.getFavorite() == null || treeItemData.getFavorite().isErrorLoading() || treeItemData.getFavorite().isSynchronizer() || bl && !treeItemData.isStatusUnread())) {
            Favorite favorite = treeItemData.getFavorite();
            if (!GUI.rssOwlGui.getRSSOwlNewsTabFolder().isFeedOpened(favorite.getUrl())) {
                GUI.rssOwlGui.loadNewsFeed(favorite.getUrl(), SearchDefinition.NO_SEARCH, true, false, bl ? 4 : 3);
                return true;
            }
        } else if (bl2 && (treeItemData.isCategory() || treeItemData.isBlogroll()) && (!bl || treeItemData.isStatusUnread())) {
            TreeItem[] treeItemArray = treeItem.getItems();
            for (int i = 0; i < treeItemArray.length; ++i) {
                if (!NewsTable.actionDisplayNextNews(treeItemArray[i], bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean actionDisplayNextNews(CTabItem cTabItem, boolean bl) {
        int n;
        CTabFolder cTabFolder = GUI.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder();
        TabItemData tabItemData = (TabItemData)cTabItem.getData();
        if (tabItemData.getNewsHeaderTable() == null) {
            return false;
        }
        Table table = tabItemData.getNewsHeaderTable();
        TableItem[] tableItemArray = table.getItems();
        int n2 = table.getSelectionIndex();
        int n3 = -1;
        boolean bl2 = false;
        for (n = n2 + 1; n < tableItemArray.length; ++n) {
            if (bl && !((TableItemData)tableItemArray[n].getData()).isNewsRead()) {
                n3 = n;
                bl2 = true;
                break;
            }
            if (bl) continue;
            n3 = n;
            break;
        }
        if (bl && !bl2) {
            for (n = 0; n < tableItemArray.length; ++n) {
                if (!bl || ((TableItemData)tableItemArray[n].getData()).isNewsRead()) continue;
                n3 = n;
                break;
            }
        }
        if (n3 != -1) {
            if (!cTabFolder.getSelection().equals(cTabItem)) {
                cTabFolder.setSelection(cTabItem);
                GUI.rssOwlGui.getRSSOwlNewsTabFolder().updateTabFolderState();
            }
            n = 0;
            BrowserPanel browserPanel = GUI.rssOwlGui.getRSSOwlNewsText().getBrowserPanel();
            if (browserPanel != null && WidgetShop.isset(browserPanel.getBrowser())) {
                n = browserPanel.getBrowser().isFocusControl() ? 1 : 0;
            }
            if (n == 0) {
                table.setFocus();
            }
            table.setSelection(n3);
            Event event = new Event();
            event.button = 1;
            table.notifyListeners(3, event);
            return true;
        }
        return false;
    }

    static void markAllRead(Table table) {
        int n = table.getItemCount();
        for (int i = 0; i < n; ++i) {
            table.getItem(i).setData(TableItemData.createNewsheaderData(true));
            NewsTable.updateTableItemStyle(table.getItem(i));
        }
    }

    static void updateTableItemStyle(TableItem tableItem) {
        boolean bl = ((TableItemData)tableItem.getData()).isNewsRead();
        if (bl) {
            tableItem.setFont(FontShop.tableFont);
            tableItem.setImage(0, PaintShop.iconRead);
        } else {
            tableItem.setFont(FontShop.tableBoldFont);
            tableItem.setImage(0, PaintShop.iconUnread);
        }
    }

    public Table createNewsTable(Composite composite) {
        final Table table = new Table(composite, 67584);
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        table.setFont(FontShop.tableFont);
        table.setLayoutData(new GridData(1808));
        table.addListener(5, new Listener(){
            private Cursor lastCursor;

            @Override
            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TableItem tableItem = table.getItem(point);
                if (!WidgetShop.isset(tableItem)) {
                    if (this.lastCursor != null && WidgetShop.isset(table)) {
                        this.lastCursor = null;
                        table.setCursor(null);
                    }
                    return;
                }
                boolean bl = tableItem.getImageBounds(0).contains(point);
                if (this.lastCursor == null && bl) {
                    this.lastCursor = GUI.display.getSystemCursor(21);
                    table.setCursor(this.lastCursor);
                } else if (this.lastCursor != null && !bl) {
                    this.lastCursor = null;
                    table.setCursor(null);
                }
            }
        });
        table.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event event) {
                NewsTable.this.onMouseUp(table, event);
            }
        });
        table.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event event) {
                NewsTable.this.onMouseDown(table, event);
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                NewsTable.this.onKeyPressed(table, keyEvent);
            }
        });
        table.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                NewsTable.this.onMouseDoubleClick(table, event);
            }
        });
        this.tableMenu = new Menu(table);
        this.tableMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (!NewsTable.this.language.equals(Dictionary.selectedLanguage)) {
                    NewsTable.this.updateI18N();
                    NewsTable.this.language = Dictionary.selectedLanguage;
                }
            }
        });
        this.addFeedToFav = new MenuItem(this.tableMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.addFeedToFav.setImage(PaintShop.iconAddToFavorites);
        }
        this.addFeedToFav.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionAddToFavorites();
            }
        });
        new MenuItem(this.tableMenu, 2);
        this.markUnreadItem = new MenuItem(this.tableMenu, 0);
        this.markUnreadItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionMarkNewsUnread();
            }
        });
        this.markAllReadItem = new MenuItem(this.tableMenu, 0);
        this.markAllReadItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionMarkAllNewsRead();
            }
        });
        new MenuItem(this.tableMenu, 2);
        this.reloadFeed = new MenuItem(this.tableMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.reloadFeed.setImage(PaintShop.iconReload);
        }
        this.reloadFeed.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionReload();
            }
        });
        new MenuItem(this.tableMenu, 2);
        this.searchFeed = new MenuItem(this.tableMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.searchFeed.setImage(PaintShop.iconFind);
        }
        this.searchFeed.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionSearch();
            }
        });
        new MenuItem(this.tableMenu, 2);
        this.mailLinkToFriend = new MenuItem(this.tableMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.mailLinkToFriend.setImage(PaintShop.iconMail);
        }
        this.mailLinkToFriend.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionMailNewsTip();
            }
        });
        this.copyUrlItem = new MenuItem(this.tableMenu, 0);
        this.copyUrlItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionCopyNewsUrl();
            }
        });
        new MenuItem(this.tableMenu, 2);
        this.exportItem = new MenuItem(this.tableMenu, 64);
        if (!GlobalSettings.isMac()) {
            this.exportItem.setImage(PaintShop.iconExport);
        }
        Menu menu = new Menu(GUI.shell, 4);
        this.exportItem.setMenu(menu);
        if (GlobalSettings.useIText()) {
            this.generatePDF = new MenuItem(menu, 0);
            this.generatePDF.setText(GUI.i18n.getTranslation("MENU_GENERATE_PDF_SELECTION") + "...");
            if (!GlobalSettings.isMac()) {
                this.generatePDF.setImage(PaintShop.iconPDF);
            }
            this.generatePDF.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewsTable.this.eventManager.actionExportFeed(0, false);
                }
            });
            this.generateRTF = new MenuItem(menu, 0);
            this.generateRTF.setText(GUI.i18n.getTranslation("MENU_GENERATE_RTF_SELECTION") + "...");
            if (!GlobalSettings.isMac()) {
                this.generateRTF.setImage(PaintShop.iconRTF);
            }
            this.generateRTF.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewsTable.this.eventManager.actionExportFeed(2, false);
                }
            });
        }
        this.generateHTML = new MenuItem(menu, 0);
        this.generateHTML.setText(GUI.i18n.getTranslation("MENU_GENERATE_HTML_SELECTION") + "...");
        if (!GlobalSettings.isMac()) {
            this.generateHTML.setImage(PaintShop.iconHTML);
        }
        this.generateHTML.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionExportFeed(1, false);
            }
        });
        new MenuItem(this.tableMenu, 2);
        this.blogNews = new MenuItem(this.tableMenu, 0);
        this.blogNews.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTable.this.eventManager.actionBlogNews();
            }
        });
        this.updateAccelerators();
        MenuManager.initMnemonics(this.tableMenu);
        table.setMenu(this.tableMenu);
        if (table.getSelectionIndex() < 0 && this.isNewsSelected) {
            this.setNewsSelectedState(false);
        } else if (table.getSelectionIndex() >= 0 && !this.isNewsSelected) {
            this.setNewsSelectedState(true);
        }
        return table;
    }

    @Override
    public void updateI18N() {
        if (GlobalSettings.useIText()) {
            this.generatePDF.setText(GUI.i18n.getTranslation("MENU_GENERATE_PDF_SELECTION") + "...");
            this.generateRTF.setText(GUI.i18n.getTranslation("MENU_GENERATE_RTF_SELECTION") + "...");
        }
        this.generateHTML.setText(GUI.i18n.getTranslation("MENU_GENERATE_HTML_SELECTION") + "...");
        this.updateAccelerators();
        MenuManager.initMnemonics(this.tableMenu);
    }

    private void updateAccelerators() {
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.addFeedToFav, "BUTTON_ADDTO_FAVORITS", true, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.copyUrlItem, "POP_COPY_NEWS_URL", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.markUnreadItem, "POP_MARK_UNREAD", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.markAllReadItem, "POP_MARK_ALL_READ", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.reloadFeed, "MENU_RELOAD", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.searchFeed, "BUTTON_SEARCH", true, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.exportItem, "BUTTON_EXPORT", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.mailLinkToFriend, "POP_MAIL_LINK", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.blogNews, "POP_BLOG_NEWS", false, false);
    }

    void actionNavigateNews(boolean bl) {
        TabItemData tabItemData = (TabItemData)this.tabItem.getData();
        if (tabItemData.getNewsHeaderTable() == null) {
            return;
        }
        Table table = tabItemData.getNewsHeaderTable();
        int n = 0;
        int n2 = table.getItemCount() - 1;
        if (bl && table.getSelectionIndex() == n2 || !bl && table.getSelectionIndex() == n) {
            return;
        }
        if (bl) {
            this.actionSelectNews(table, table.getSelectionIndex() + 1);
        } else {
            this.actionSelectNews(table, table.getSelectionIndex() - 1);
        }
    }

    void actionSelectNews(Table table, int n) {
        table.setSelection(n);
        table.showSelection();
        Event event = new Event();
        event.button = 1;
        table.notifyListeners(3, event);
    }

    void onKeyPressed(Table table, KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = (keyEvent.stateMask & 0x40000) != 0 || (keyEvent.stateMask & 0x400000) != 0;
        if (keyEvent.character == '\r' && table.getSelectionIndex() != -1) {
            this.eventManager.actionOpenNewsURL(table.getItem(table.getSelectionIndex()).getText(1), bl);
        } else if (keyEvent.keyCode == 0x1000002) {
            this.actionNavigateNews(true);
        } else if (keyEvent.keyCode == 0x1000001) {
            this.actionNavigateNews(false);
        } else if (keyEvent.keyCode == 0x1000007 && table.getItemCount() != 0) {
            this.actionSelectNews(table, 0);
        } else if (keyEvent.keyCode == 0x1000008 && table.getItemCount() != 0) {
            this.actionSelectNews(table, table.getItemCount() - 1);
        } else if ((keyEvent.keyCode == 0x1000006 || keyEvent.keyCode == 0x1000005) && table.getItemCount() != 0) {
            int n = table.getClientArea().height / table.getItemHeight() - 1;
            boolean bl3 = keyEvent.keyCode == 0x1000005;
            boolean bl4 = table.getSelectionCount() > 0;
            int n2 = table.getItemCount();
            int n3 = table.getSelectionIndex();
            if (n >= n2) {
                this.actionSelectNews(table, bl3 ? 0 : n2 - 1);
            } else if (bl3 && bl4 && n3 - n >= 0) {
                this.actionSelectNews(table, n3 - n);
            } else if (bl3 && bl4 && n3 - n < 0) {
                this.actionSelectNews(table, 0);
            } else if (!bl3 && bl4 && n3 + n < n2 - 1) {
                this.actionSelectNews(table, n3 + n);
            } else if (!bl3 && bl4 && n3 + n >= n2 - 1) {
                this.actionSelectNews(table, n2 - 1);
            }
        } else if (keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000013) {
            return;
        }
        keyEvent.doit = false;
    }

    void onMouseDoubleClick(Table table, Event event) {
        boolean bl;
        boolean bl2 = bl = event.stateMask == 262144 || event.stateMask == 0x400000;
        if (table.getSelectionIndex() != -1) {
            this.eventManager.actionOpenNewsURL(table.getItem(table.getSelectionIndex()).getText(1), bl);
        }
    }

    void onMouseDown(Table table, Event event) {
        NewsItem newsItem;
        TabItemData tabItemData = (TabItemData)this.tabItem.getData();
        if (table.getSelectionCount() > 0) {
            MenuManager.notifyState(6);
        }
        if (table.getSelectionIndex() < 0 && this.isNewsSelected) {
            this.setNewsSelectedState(false);
        } else if (table.getSelectionIndex() >= 0 && !this.isNewsSelected) {
            this.setNewsSelectedState(true);
        }
        if (event.button != 1 || table.getSelectionCount() <= 0 || GlobalSettings.isMac() && (event.stateMask & 0x40000) != 0) {
            return;
        }
        TableItem tableItem = table.getSelection()[0];
        boolean bl = false;
        Rectangle rectangle = tableItem.getImageBounds(0);
        if (((TableItemData)tableItem.getData()).isNewsRead() && rectangle != null && rectangle.contains(new Point(event.x, event.y))) {
            bl = true;
        }
        if ((newsItem = this.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedNewsItem(tableItem.getText(1))) != null) {
            this.rssOwlGui.getArchiveManager().getArchive().addEntry(newsItem);
            newsItem.setRead(true);
        }
        ((TableItemData)tableItem.getData()).setNewsRead(true);
        NewsTable.updateTableItemStyle(tableItem);
        this.rssOwlGui.getRSSOwlNewsTabFolder().updateTabItemStatus(this.tabItem);
        String string = null;
        if (tabItemData.getUrl() != null && Category.getFavPool().containsKey(tabItemData.getUrl())) {
            string = tabItemData.getUrl();
        } else if (newsItem != null && newsItem.getNewsfeedXmlUrl() != null && Category.getFavPool().containsKey(newsItem.getNewsfeedXmlUrl())) {
            string = newsItem.getNewsfeedXmlUrl();
        }
        if (string != null) {
            Favorite favorite = (Favorite)Category.getFavPool().get(string);
            Channel channel = this.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedChannel();
            if (channel != null && !channel.isAggregatedCat()) {
                favorite.updateReadStatus(channel.getUnreadNewsCount());
            } else if (channel != null) {
                favorite.updateReadStatus(channel.getUnreadNewsCount(string));
            }
        }
        this.rssOwlGui.getRSSOwlNewsText().setRequiresUpdate();
        if (tabItemData.getUrl() != null) {
            this.rssOwlGui.getRSSOwlNewsText().displayNews(tabItemData.getUrl(), newsItem != null ? newsItem.getTitle() : tableItem.getText(1));
        }
        if (bl) {
            GUI.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GUI.isAlive() && newsItem != null) {
                        NewsTable.this.eventManager.actionMarkNewsUnread(newsItem);
                    }
                }
            });
        }
    }

    void onMouseUp(Table table, Event event) {
        if (GlobalSettings.isMac() && event.stateMask == 786432) {
            table.getMenu().setVisible(true);
        }
    }

    void setNewsSelectedState(boolean bl) {
        this.exportItem.setEnabled(bl);
        this.copyUrlItem.setEnabled(bl);
        this.markUnreadItem.setEnabled(bl);
        this.mailLinkToFriend.setEnabled(bl);
        this.blogNews.setEnabled(bl);
        this.isNewsSelected = bl;
    }
}

