/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.IFontChangeable;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.controller.forms.Hyperlink;
import net.sourceforge.rssowl.controller.forms.HyperlinkAdapter;
import net.sourceforge.rssowl.controller.forms.HyperlinkEvent;
import net.sourceforge.rssowl.controller.panel.BrowserPanel;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.model.Enclosure;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jdom.Text;

public class NewsText
implements ITranslatable,
IFontChangeable {
    private BrowserPanel browserPanel;
    private SashForm contentSash;
    private MenuItem copyItemUrl;
    private Composite descriptionHolder;
    private boolean isShowingNews;
    private Menu linkMenu;
    private Composite newsContentHolder;
    private ViewForm newsContentViewForm;
    private Composite newsContentViewFormHeader;
    private Composite newsTextHolder;
    private MenuItem openExternalItem;
    private MenuItem printNews;
    private MenuItem rateBad;
    private MenuItem rateFantastic;
    private MenuItem rateGood;
    private MenuItem rateModerate;
    private MenuItem rateVeryBad;
    private boolean requiresUpdate;
    private MenuItem selectAllItem;
    private MenuItem useBrowserForNewsText;
    MenuItem copyItem;
    Display display;
    EventManager eventManager;
    boolean isReset;
    int lastRate;
    StyledText newsText;
    Menu newsTextMenu;
    StyledText newsTextTitle;
    ToolBar newsTextToolBar;
    Hyperlink newsTextUrl;
    MenuItem openInBrowserItem;
    Composite rateComposite;
    Menu rateDropdown;
    ToolItem rateToolItem;
    NewsItem rssNewsItem;
    GUI rssOwlGui;
    Shell shell;
    Composite urlTitleHolder;
    int x;
    int y;

    public NewsText(Display display, Shell shell, SashForm sashForm, GUI gUI, EventManager eventManager) {
        this.display = display;
        this.shell = shell;
        this.contentSash = sashForm;
        this.rssOwlGui = gUI;
        this.eventManager = eventManager;
        this.isReset = true;
        this.isShowingNews = false;
        this.requiresUpdate = true;
        this.lastRate = 5;
        this.initComponents();
    }

    public BrowserPanel getBrowserPanel() {
        return this.browserPanel;
    }

    public StyledText getNewsTextTitle() {
        return this.newsTextTitle;
    }

    public String getPrintableNewstext() {
        String string = "";
        if (this.rssNewsItem != null) {
            string = this.rssNewsItem.toPrintable();
        }
        return string;
    }

    public void setNewsTextToolBarVisible(boolean bl) {
        if (WidgetShop.isset(this.newsTextToolBar)) {
            this.newsTextToolBar.setVisible(bl);
        }
    }

    public void setRequiresUpdate() {
        this.requiresUpdate = true;
    }

    @Override
    public void updateFonts() {
        if (WidgetShop.isset(this.newsText)) {
            this.newsText.setFont(FontShop.textFont);
        } else if (this.browserPanel != null && this.rssNewsItem != null && WidgetShop.isset(this.browserPanel.getBrowser())) {
            this.rssNewsItem.setRequiresViewUpdate(true);
            this.displayNews(this.rssNewsItem);
        }
        this.newsTextTitle.setFont(FontShop.textBoldFont);
        this.newsTextUrl.setFont(FontShop.textFont);
    }

    @Override
    public void updateI18N() {
        this.rateFantastic.setText(GUI.i18n.getTranslation("RATE_FANTASTIC"));
        this.rateGood.setText(GUI.i18n.getTranslation("RATE_GOOD"));
        this.rateModerate.setText(GUI.i18n.getTranslation("RATE_MODERATE"));
        this.rateBad.setText(GUI.i18n.getTranslation("RATE_BAD"));
        this.rateVeryBad.setText(GUI.i18n.getTranslation("RATE_VERY_BAD"));
        this.rateToolItem.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_RATE"));
        this.copyItemUrl.setText(GUI.i18n.getTranslation("POP_COPY"));
        if (this.openExternalItem != null) {
            this.openExternalItem.setText(GUI.i18n.getTranslation("POP_OPEN_EXTERN"));
        }
        MenuManager.initMnemonics(this.linkMenu);
        if (!GlobalSettings.useBrowserForNewsText && WidgetShop.isset(this.newsText)) {
            this.updateAccelerators();
            this.openInBrowserItem.setText(GUI.i18n.getTranslation("POP_OPEN_IN_BROWSER"));
            MenuManager.initMnemonics(this.newsTextMenu);
        }
    }

    public void updateLinkColor() {
        this.newsTextUrl.setForeground(PaintShop.linkColor);
    }

    private void createBrowserPanel(boolean bl) {
        try {
            this.browserPanel = new BrowserPanel(this.rssOwlGui, this.descriptionHolder, false);
            this.browserPanel.getBrowserPanel().setLayoutData(LayoutDataShop.createFormData(0, 0, 0, 0));
        }
        catch (SWTError sWTError) {
            GUI.logger.log("displayNewsInBrowser()", sWTError);
            if (this.browserPanel != null) {
                this.browserPanel.dispose();
                this.browserPanel = null;
            }
            GlobalSettings.useBrowserForNewsText = false;
            this.rssOwlGui.getRSSOwlMenu().setUseBrowserForNewsText(GlobalSettings.useBrowserForNewsText);
            if (!bl) {
                MessageBoxFactory.showError(this.shell, BrowserShop.createBrowserError(sWTError));
                this.eventManager.actionOpenFAQOnBrowser();
            }
            this.createStyledText();
            this.rebuildNewsText();
        }
    }

    private void createStyledText() {
        this.newsText = new StyledText(this.descriptionHolder, 584);
        this.newsText.setLayoutData(LayoutDataShop.createFormData(8, 0, 8, -1));
        this.newsText.setFont(FontShop.textFont);
        this.newsText.setBackground(this.display.getSystemColor(1));
        this.newsText.setCursor(this.display.getSystemCursor(19));
        this.newsText.setCaret(null);
        this.newsText.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NewsText.this.newsTextTitle != null) {
                    NewsText.this.newsTextTitle.setSelection(0);
                }
            }
        });
        this.newsText.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent mouseEvent) {
                NewsText.this.onMouseMove(mouseEvent);
            }
        });
        this.newsText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                NewsText.this.onMouseUp(mouseEvent);
            }
        });
        this.newsTextMenu = new Menu(this.newsText);
        if (GlobalSettings.useInternalBrowser()) {
            this.useBrowserForNewsText = new MenuItem(this.newsTextMenu, 0);
            if (!GlobalSettings.isMac()) {
                this.useBrowserForNewsText.setImage(PaintShop.loadImage("/img/icons/browserview.gif"));
                this.useBrowserForNewsText.addDisposeListener(DisposeListenerImpl.getInstance());
            }
            this.useBrowserForNewsText.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewsText.this.eventManager.actionSetBrowserView(true);
                }
            });
            new MenuItem(this.newsTextMenu, 2);
        }
        this.copyItem = new MenuItem(this.newsTextMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.copyItem.setImage(PaintShop.iconCopy);
        }
        this.copyItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!NewsText.this.newsText.getSelectionText().equals("")) {
                    NewsText.this.newsText.copy();
                }
            }
        });
        this.selectAllItem = new MenuItem(this.newsTextMenu, 0);
        this.selectAllItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsText.this.newsText.selectAll();
            }
        });
        new MenuItem(this.newsTextMenu, 2);
        if (GlobalSettings.usePrinting()) {
            this.printNews = new MenuItem(this.newsTextMenu, 0);
            if (!GlobalSettings.isMac()) {
                this.printNews.setImage(PaintShop.iconPrint);
            }
            this.printNews.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewsText.this.eventManager.actionPrintNews();
                }
            });
            new MenuItem(this.newsTextMenu, 2);
        }
        this.openInBrowserItem = new MenuItem(this.newsTextMenu, 0);
        this.openInBrowserItem.setText(GUI.i18n.getTranslation("POP_OPEN_IN_BROWSER"));
        this.openInBrowserItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsText.this.eventManager.actionOpenURL(NewsText.this.newsText.getSelectionText());
            }
        });
        this.newsTextMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (!WidgetShop.isset(NewsText.this.newsText)) {
                    return;
                }
                if (NewsText.this.newsText.getSelectionText().equals("")) {
                    NewsText.this.copyItem.setEnabled(false);
                    NewsText.this.openInBrowserItem.setEnabled(false);
                } else {
                    NewsText.this.copyItem.setEnabled(true);
                    NewsText.this.openInBrowserItem.setEnabled(true);
                }
            }
        });
        this.updateAccelerators();
        MenuManager.initMnemonics(this.newsTextMenu);
        this.newsText.setMenu(this.newsTextMenu);
    }

    private void displayNews(NewsItem newsItem) {
        if (!this.requiresUpdate && this.isShowingNews(newsItem)) {
            return;
        }
        this.rssNewsItem = newsItem;
        this.isShowingNews = true;
        this.requiresUpdate = false;
        this.rssNewsItem.setRequiresViewUpdate(false);
        MenuManager.notifyState(3);
        String string = newsItem.getLink();
        if (!StringShop.isset(string) && StringShop.isset(newsItem.getGuid()) && RegExShop.isValidURL(newsItem.getGuid())) {
            string = newsItem.getGuid();
        }
        if (!StringShop.isset(newsItem.getDescription()) && GlobalSettings.directOpenNews && StringShop.isset(string)) {
            this.displayNewsLinkInBrowser(string);
        } else if (GlobalSettings.directOpenEachNews && StringShop.isset(string)) {
            this.displayNewsLinkInBrowser(string);
        } else if (GlobalSettings.useBrowserForNewsText) {
            this.displayNewsInBrowser();
        } else {
            this.displayNewsInStyledText();
        }
        this.descriptionHolder.layout();
    }

    private void displayNewsInBrowser() {
        this.displayNewsMetaInfo();
        if (this.browserPanel == null) {
            this.createBrowserPanel(false);
        }
        if (this.browserPanel != null) {
            this.browserPanel.displayNews(this.rssNewsItem);
        } else {
            this.displayNews(this.rssNewsItem);
        }
    }

    private void displayNewsInStyledText() {
        Object object;
        int n;
        if (this.newsText == null || this.newsText.isDisposed()) {
            this.createStyledText();
        }
        this.displayNewsMetaInfo();
        int n2 = this.newsTextMenu.getItemCount();
        for (int i = n = 4 + (GlobalSettings.useInternalBrowser() ? 2 : 0) + (GlobalSettings.usePrinting() ? 2 : 0); i < n2; ++i) {
            this.newsTextMenu.getItem(n).dispose();
        }
        if (StringShop.isset(this.rssNewsItem.getDescription())) {
            this.newsText.setText(XMLShop.stripSimpleHTMLTags(Text.normalizeString(this.rssNewsItem.getDescription())));
            if (this.rssNewsItem.getLinkList() != null && this.rssNewsItem.getLinkList().size() > 0) {
                new MenuItem(this.newsTextMenu, 2);
                Iterator iterator = this.rssNewsItem.getLinkList().iterator();
                while (iterator.hasNext()) {
                    object = new MenuItem(this.newsTextMenu, 0);
                    ((MenuItem)object).setText((String)iterator.next());
                    if (!GlobalSettings.isMac()) {
                        ((MenuItem)object).setImage(PaintShop.iconWorld);
                    }
                    ((MenuItem)object).addSelectionListener(new SelectionAdapter((MenuItem)object){
                        final /* synthetic */ MenuItem val$linkFromText;
                        {
                            this.val$linkFromText = menuItem;
                        }

                        @Override
                        public void widgetSelected(SelectionEvent selectionEvent) {
                            NewsText.this.eventManager.actionOpenURL(this.val$linkFromText.getText(), this.val$linkFromText.getText().equals(NewsText.this.rssNewsItem.getOrigurl()));
                        }
                    });
                }
            }
        } else {
            this.newsText.setText(GUI.i18n.getTranslation("NEWS_NO_DESCRIPTION"));
        }
        Vector vector = new Vector();
        if (this.rssNewsItem.getLinkList() != null) {
            vector.addAll(WidgetShop.calculateStyleRanges(this.newsText, new Vector(this.rssNewsItem.getLinkList()), PaintShop.linkColor, this.display.getSystemColor(1), 0, false, true));
        }
        if (this.rssNewsItem.getHighlightWords() != null) {
            vector.addAll(WidgetShop.calculateStyleRanges(this.newsText, this.rssNewsItem.getHighlightWords(), this.display.getSystemColor(2), PaintShop.syntaxHighlightColor, 0, this.rssNewsItem.isSearchCaseSensitive(), false));
        }
        if (this.rssNewsItem.getEnclosures() != null && this.rssNewsItem.getEnclosures().size() > 0) {
            object = "\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_ENCLOSURE") + ":\n";
            this.newsText.append((String)object);
            vector.addAll(WidgetShop.calculateStyleRanges(this.newsText, StringShop.toVector(new String[]{GUI.i18n.getTranslation("NEWS_ITEM_INFO_ENCLOSURE") + ":"}), this.display.getSystemColor(2), this.display.getSystemColor(1), 1, true, false));
            for (int i = 0; i < this.rssNewsItem.getEnclosures().size(); ++i) {
                Enclosure enclosure = (Enclosure)this.rssNewsItem.getEnclosures().get(i);
                this.newsText.append("\n" + enclosure.getUrl() + " (" + enclosure.getType() + " / " + enclosure.getLength(true) + ")");
            }
        }
        if (this.rssNewsItem.getSource() != null) {
            object = "\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_SOURCE") + ":  " + this.rssNewsItem.getSource();
            this.newsText.append((String)object);
            vector.addAll(WidgetShop.calculateStyleRanges(this.newsText, StringShop.toVector(new String[]{GUI.i18n.getTranslation("NEWS_ITEM_INFO_SOURCE") + ":"}), this.display.getSystemColor(2), this.display.getSystemColor(1), 1, true, false));
        }
        if (this.rssNewsItem.getComments() != null && this.rssNewsItem.getComments().size() > 0) {
            this.newsText.append("\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_COMMENTS") + ":\n");
            vector.addAll(WidgetShop.calculateStyleRanges(this.newsText, StringShop.toVector(new String[]{GUI.i18n.getTranslation("NEWS_ITEM_INFO_COMMENTS") + ":"}), this.display.getSystemColor(2), this.display.getSystemColor(1), 1, true, false));
            for (int i = 0; i < this.rssNewsItem.getComments().size(); ++i) {
                if (this.rssNewsItem.getComments().get(i) == null || this.rssNewsItem.getComments().get(i).equals("")) continue;
                this.newsText.append("\n" + this.rssNewsItem.getComments().get(i));
            }
        }
        WidgetShop.highlightText(this.newsText, vector);
    }

    private void displayNewsLinkInBrowser(String string) {
        if (GlobalSettings.useBrowserForNewsText) {
            this.displayNewsMetaInfo();
            if (this.browserPanel == null) {
                this.createBrowserPanel(false);
            }
            if (this.browserPanel != null) {
                this.browserPanel.getBrowser().setUrl("about:blank");
                if (!this.browserPanel.getBrowserPanel().isVisible()) {
                    this.browserPanel.getBrowserPanel().setVisible(true);
                }
                this.browserPanel.setBlockNavigation(false);
                this.browserPanel.getBrowser().setUrl(string);
            } else {
                this.displayNews(this.rssNewsItem);
            }
        } else {
            this.eventManager.actionOpenURL(string);
        }
    }

    private void displayNewsMetaInfo() {
        Integer n;
        if (this.rssNewsItem.getTitle() != null) {
            this.newsTextTitle.setText(this.rssNewsItem.getTitle());
            if (this.rssNewsItem.getHighlightWords() != null) {
                WidgetShop.highlightText(this.newsTextTitle, this.rssNewsItem.getHighlightWords(), this.display.getSystemColor(2), PaintShop.syntaxHighlightColor, 0, this.rssNewsItem.isSearchCaseSensitive(), false);
            }
        } else {
            this.newsTextTitle.setText(GUI.i18n.getTranslation("NO_TITLE"));
        }
        if (this.rssNewsItem.getLink() != null) {
            this.newsTextUrl.setText(this.rssNewsItem.getLink());
        } else if (this.rssNewsItem.getGuid() != null && RegExShop.isValidURL(this.rssNewsItem.getGuid())) {
            this.newsTextUrl.setText(this.rssNewsItem.getGuid());
        } else {
            this.newsTextUrl.setText("");
        }
        if (this.newsTextUrl.getText().equals("")) {
            this.newsTextUrl.setToolTipText(null);
            this.newsTextUrl.setVisible(false);
        } else {
            this.newsTextUrl.setVisible(true);
        }
        this.newsContentViewForm.layout(false);
        String string = "";
        if (AmphetaRateThread.ratedNews.size() > 0 && (n = (Integer)AmphetaRateThread.ratedNews.get(this.rssNewsItem.toAmphetaRateURL())) != null) {
            string = GUI.i18n.getTranslation("LABEL_NEWS_RATED") + ": " + AmphetaRateThread.getTranslatedRatingLevel(n);
        }
        this.rssOwlGui.getRSSOwlStatusLine().updateRateLabel(string);
    }

    private void initComponents() {
        this.newsContentHolder = new Composite(this.contentSash, 0);
        this.newsContentHolder.setLayout(new FillLayout());
        int n = GlobalSettings.isMac() ? 0x800800 : 2048;
        this.newsContentViewForm = new ViewForm(this.newsContentHolder, n);
        this.newsContentViewForm.setTopCenterSeparate(true, false);
        this.newsContentViewFormHeader = new Composite(this.newsContentViewForm, 0);
        this.newsContentViewFormHeader.setLayout(LayoutShop.createGridLayout(2, 0, 0));
        this.newsContentViewFormHeader.setBackground(PaintShop.grayViewFormColor);
        this.urlTitleHolder = new Composite(this.newsContentViewFormHeader, 0);
        this.urlTitleHolder.setBackground(PaintShop.grayViewFormColor);
        this.urlTitleHolder.setLayout(LayoutShop.createGridLayout(1, 7, 8));
        this.urlTitleHolder.setLayoutData(new GridData(4, 1, true, false, 1, 2));
        this.newsTextTitle = new StyledText(this.urlTitleHolder, 72);
        this.newsTextTitle.setLayoutData(new GridData(4, 1, true, false));
        ((GridData)this.newsTextTitle.getLayoutData()).horizontalIndent = 1;
        this.newsTextTitle.setBackground(PaintShop.grayViewFormColor);
        this.newsTextTitle.setFont(FontShop.textBoldFont);
        this.newsTextTitle.setCursor(this.display.getSystemCursor(19));
        this.newsTextTitle.setCaret(null);
        this.newsTextTitle.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (WidgetShop.isset(NewsText.this.newsText)) {
                    NewsText.this.newsText.setSelection(0);
                }
            }
        });
        Composite composite = new Composite(this.urlTitleHolder, 64);
        composite.setLayoutData(new GridData(4, 1, true, false));
        composite.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        composite.setBackground(PaintShop.grayViewFormColor);
        this.newsTextUrl = new Hyperlink(composite, 524352);
        this.newsTextUrl.setBackground(PaintShop.grayViewFormColor);
        this.newsTextUrl.setLayoutData(new GridData(4, 1, true, false));
        this.newsTextUrl.setForeground(PaintShop.linkColor);
        this.newsTextUrl.setFont(FontShop.textFont);
        this.newsTextUrl.setUnderlined(true);
        this.newsTextUrl.setText("");
        final DragSource dragSource = new DragSource(this.newsTextUrl, 3);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (StringShop.isset(NewsText.this.newsTextUrl.getText())) {
                    dragSourceEvent.data = NewsText.this.newsTextUrl.getText();
                }
            }

            @Override
            public void dragStart(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.doit = StringShop.isset(NewsText.this.newsTextUrl.getText());
            }
        });
        this.newsTextUrl.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                dragSource.dispose();
            }
        });
        this.linkMenu = new Menu(this.newsTextTitle);
        this.copyItemUrl = new MenuItem(this.linkMenu, 0);
        this.copyItemUrl.setText(GUI.i18n.getTranslation("POP_COPY"));
        if (!GlobalSettings.isMac()) {
            this.copyItemUrl.setImage(PaintShop.iconCopy);
        }
        this.copyItemUrl.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsText.this.eventManager.actionCopyText(NewsText.this.newsTextUrl);
            }
        });
        if (GlobalSettings.useInternalBrowser() && !GlobalSettings.openBrowserExtern) {
            new MenuItem(this.linkMenu, 2);
            this.openExternalItem = new MenuItem(this.linkMenu, 0);
            this.openExternalItem.setText(GUI.i18n.getTranslation("POP_OPEN_EXTERN"));
            this.openExternalItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (StringShop.isset(NewsText.this.newsTextUrl.getText())) {
                        NewsText.this.eventManager.actionOpenURLExternal(NewsText.this.newsTextUrl.getText());
                    }
                }
            });
        }
        MenuManager.initMnemonics(this.linkMenu);
        this.newsTextUrl.setMenu(this.linkMenu);
        this.newsTextUrl.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                boolean bl;
                boolean bl2 = bl = (hyperlinkEvent.getStateMask() & 0x40000) != 0 || (hyperlinkEvent.getStateMask() & 0x400000) != 0;
                if (StringShop.isset(NewsText.this.newsTextUrl.getText())) {
                    if (bl) {
                        NewsText.this.eventManager.actionOpenURLExternal(NewsText.this.newsTextUrl.getText());
                    } else {
                        NewsText.this.eventManager.actionOpenURL(NewsText.this.newsTextUrl.getText());
                    }
                }
            }
        });
        this.rateComposite = new Composite(this.newsContentViewFormHeader, 0);
        this.rateComposite.setLayout(LayoutShop.createGridLayout(2, 0, GlobalSettings.isWindows() ? 4 : 0));
        this.rateComposite.setBackground(PaintShop.grayViewFormColor);
        this.rateComposite.setLayoutData(new GridData(34));
        this.newsTextToolBar = new ToolBar(this.rateComposite, 0x800000);
        this.newsTextToolBar.setLayoutData(new GridData(34));
        this.newsTextToolBar.setBackground(PaintShop.grayViewFormColor);
        this.rateDropdown = new Menu(this.newsContentViewForm);
        this.rateFantastic = new MenuItem(this.rateDropdown, 16);
        this.rateFantastic.setText(GUI.i18n.getTranslation("RATE_FANTASTIC"));
        this.rateFantastic.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((MenuItem)selectionEvent.getSource()).getSelection()) {
                    NewsText.this.lastRate = 10;
                    NewsText.this.eventManager.actionRateNews(NewsText.this.rssNewsItem, NewsText.this.lastRate);
                }
            }
        });
        this.rateGood = new MenuItem(this.rateDropdown, 16);
        this.rateGood.setText(GUI.i18n.getTranslation("RATE_GOOD"));
        this.rateGood.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((MenuItem)selectionEvent.getSource()).getSelection()) {
                    NewsText.this.lastRate = 8;
                    NewsText.this.eventManager.actionRateNews(NewsText.this.rssNewsItem, NewsText.this.lastRate);
                }
            }
        });
        this.rateModerate = new MenuItem(this.rateDropdown, 16);
        this.rateModerate.setText(GUI.i18n.getTranslation("RATE_MODERATE"));
        this.rateModerate.setSelection(true);
        this.rateModerate.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((MenuItem)selectionEvent.getSource()).getSelection()) {
                    NewsText.this.lastRate = 5;
                    NewsText.this.eventManager.actionRateNews(NewsText.this.rssNewsItem, NewsText.this.lastRate);
                }
            }
        });
        this.rateBad = new MenuItem(this.rateDropdown, 16);
        this.rateBad.setText(GUI.i18n.getTranslation("RATE_BAD"));
        this.rateBad.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((MenuItem)selectionEvent.getSource()).getSelection()) {
                    NewsText.this.lastRate = 2;
                    NewsText.this.eventManager.actionRateNews(NewsText.this.rssNewsItem, NewsText.this.lastRate);
                }
            }
        });
        this.rateVeryBad = new MenuItem(this.rateDropdown, 16);
        this.rateVeryBad.setText(GUI.i18n.getTranslation("RATE_VERY_BAD"));
        this.rateVeryBad.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((MenuItem)selectionEvent.getSource()).getSelection()) {
                    NewsText.this.lastRate = 0;
                    NewsText.this.eventManager.actionRateNews(NewsText.this.rssNewsItem, NewsText.this.lastRate);
                }
            }
        });
        this.rateToolItem = new ToolItem(this.newsTextToolBar, 4);
        this.rateToolItem.setImage(PaintShop.loadImage("/img/icons/rate.gif"));
        this.rateToolItem.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_RATE"));
        this.rateToolItem.addDisposeListener(DisposeListenerImpl.getInstance());
        this.rateToolItem.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rectangle = NewsText.this.rateToolItem.getBounds();
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    point = NewsText.this.newsTextToolBar.toDisplay(point);
                    NewsText.this.rateDropdown.setLocation(point.x, point.y);
                    NewsText.this.rateDropdown.setVisible(true);
                } else {
                    NewsText.this.rateNews(NewsText.this.rssNewsItem, NewsText.this.lastRate);
                }
            }
        });
        this.newsContentViewForm.setTopCenter(this.newsContentViewFormHeader, false);
        this.newsTextHolder = new Composite(this.newsContentViewForm, 0);
        this.newsTextHolder.setBackground(this.display.getSystemColor(1));
        this.newsTextHolder.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        this.descriptionHolder = new Composite(this.newsTextHolder, 0);
        this.descriptionHolder.setBackground(this.display.getSystemColor(1));
        this.descriptionHolder.setLayoutData(LayoutDataShop.createGridData(1808, 1));
        this.descriptionHolder.setLayout(new FormLayout());
        this.newsContentViewForm.setContent(this.newsTextHolder, true);
        MenuManager.notifyState(4);
        if (GlobalSettings.useBrowserForNewsText) {
            this.createBrowserPanel(true);
        } else {
            this.createStyledText();
        }
    }

    private boolean isShowingNews(NewsItem newsItem) {
        return this.isShowingNews && this.rssNewsItem != null && this.rssNewsItem.sameAs(newsItem) && !this.rssNewsItem.getRequiresViewUpdate();
    }

    private void rebuildNewsText() {
        this.newsContentHolder.dispose();
        this.initComponents();
        this.contentSash.layout();
    }

    private void updateAccelerators() {
        if (GlobalSettings.usePrinting()) {
            this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.printNews, "TOOLTIP_PRINT", true, false);
        }
        if (GlobalSettings.useInternalBrowser()) {
            this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.useBrowserForNewsText, "MENU_BROWSER_FOR_NEWSTEXT", false, false);
        }
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.selectAllItem, "MENU_EDIT_SELECT_ALL", false, false);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(this.copyItem, "MENU_EDIT_COPY", false, false);
    }

    void checkWord(StyledText styledText) {
        int n;
        int n2 = n = styledText.getOffsetAtLocation(new Point(this.x, this.y));
        int n3 = n;
        boolean bl = false;
        boolean bl2 = false;
        if (styledText.getText(n2, n2).equals(" ")) {
            return;
        }
        do {
            if (!bl) {
                if (StringShop.isTerminating(styledText.getText(n2, n2))) {
                    bl = true;
                    ++n2;
                } else if (n2 == 0) {
                    bl = true;
                } else {
                    --n2;
                }
            }
            if (bl2) continue;
            if (StringShop.isTerminating(styledText.getText(n3, n3))) {
                bl2 = true;
                --n3;
                continue;
            }
            if (n3 == styledText.getText().length() - 1) {
                bl2 = true;
                continue;
            }
            ++n3;
        } while (!bl || !bl2);
        String string = styledText.getText(n2, n3).trim();
        if (!string.equals("") && this.rssNewsItem.getLinkList() != null && this.rssNewsItem.getLinkList().contains(string)) {
            styledText.setCursor(this.display.getSystemCursor(21));
            styledText.setData(string);
            if (string.equals(this.rssNewsItem.getOrigurl())) {
                styledText.setToolTipText(GUI.i18n.getTranslation("BUTTON_ADDTO_FAVORITS"));
            }
            this.isReset = false;
        } else if (!this.isReset) {
            styledText.setCursor(this.display.getSystemCursor(19));
            styledText.setData(null);
            styledText.setToolTipText(null);
            this.isReset = true;
        }
    }

    void clearNewstext() {
        this.isShowingNews = false;
        this.newsTextTitle.setText("");
        this.newsTextTitle.setStyleRange(null);
        this.newsTextUrl.setText("");
        this.newsTextUrl.setVisible(false);
        this.rssNewsItem = null;
        this.rssOwlGui.getRSSOwlStatusLine().updateRateLabel("");
        if (GlobalSettings.useBrowserForNewsText && this.browserPanel != null) {
            this.browserPanel.hideNoControlsBrowser();
        } else if (!GlobalSettings.useBrowserForNewsText && this.newsText != null) {
            this.newsText.dispose();
        }
        this.rateComposite.setVisible(false);
    }

    void displayNews(String string, String string2) {
        NewsItem newsItem = this.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedNewsItem(string2);
        if (newsItem == null) {
            return;
        }
        if (newsItem.getNewsfeedXmlUrl() == null) {
            newsItem.setNewsfeedXmlUrl(string);
        }
        this.displayNews(newsItem);
    }

    void onMouseMove(MouseEvent mouseEvent) {
        this.x = mouseEvent.x;
        this.y = mouseEvent.y;
        try {
            this.checkWord(this.newsText);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.isReset) {
                this.newsText.setCursor(this.display.getSystemCursor(19));
                this.newsText.setData(null);
                this.newsText.setToolTipText(null);
            }
            this.isReset = true;
        }
    }

    void onMouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1 && this.newsText.getSelectionCount() == 0 && this.newsText.getData() != null) {
            this.eventManager.actionOpenURL((String)this.newsText.getData(), ((String)this.newsText.getData()).equals(this.rssNewsItem.getOrigurl()));
        }
        if (GlobalSettings.isMac() && mouseEvent.stateMask == 786432 && WidgetShop.isset(this.newsTextMenu)) {
            this.newsTextMenu.setVisible(true);
        }
    }

    void rateNews(NewsItem newsItem, int n) {
    }

    void updateNewsTextComposite() {
        if (GlobalSettings.useBrowserForNewsText) {
            try {
                this.browserPanel = new BrowserPanel(this.rssOwlGui, this.descriptionHolder, false);
                this.browserPanel.getBrowserPanel().setLayoutData(LayoutDataShop.createFormData(0, 0, 0, 0));
                if (this.newsText != null) {
                    this.newsText.dispose();
                }
            }
            catch (SWTError sWTError) {
                GUI.logger.log("updateNewsTextComposite()", sWTError);
                GlobalSettings.useBrowserForNewsText = false;
                this.rssOwlGui.getRSSOwlMenu().useBrowserForNewsText.setSelection(GlobalSettings.useBrowserForNewsText);
                MessageBoxFactory.showError(this.shell, BrowserShop.createBrowserError(sWTError));
                this.eventManager.actionOpenFAQOnBrowser();
                this.rebuildNewsText();
            }
        } else {
            if (this.browserPanel != null) {
                this.browserPanel.dispose();
            }
            this.createStyledText();
        }
        this.newsTextHolder.update();
        this.newsTextHolder.layout();
        this.isShowingNews = false;
        if (this.rssNewsItem != null) {
            this.displayNews(this.rssNewsItem);
        }
    }
}

