/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.StartupManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class RSSOwlLoader {
    private static final String PROPERTY_ALLOW_MULTI_INSTANCES = "net.sourceforge.rssowl.allowMultiInstances";
    private static final String PROPERTY_DEBUG_MODE = "net.sourceforge.rssowl.debug";
    private static final String PROPERTY_NO_SPLASH = "net.sourceforge.rssowl.noSplash";
    static final String PROPERTY_CLASSIC_SORT = "net.sourceforge.rssowl.oldSort";
    static String feedArgument;
    Display display;
    Shell invisibleShell;

    private RSSOwlLoader() {
        Display.setAppName("RSSOwl 1.2.3");
        this.display = new Display();
        this.invisibleShell = new Shell(this.display, 0);
        Shell shell = new Shell(this.invisibleShell, GlobalSettings.isWindows() ? 4 : 0);
        shell.setLayout(LayoutShop.createFillLayout(0, 0));
        if (!System.getProperties().containsKey(PROPERTY_NO_SPLASH)) {
            Label label = new Label(shell, 0);
            label.setImage(PaintShop.loadImage("/img/splash.gif"));
            label.addDisposeListener(DisposeListenerImpl.getInstance());
            shell.pack();
            shell.setText(WidgetShop.getShellTitle());
            LayoutShop.centerShell(this.display, shell);
            shell.open();
        }
        new GUI(this.display, this.invisibleShell).showGui();
    }

    public static void main(String[] stringArray) {
        RSSOwlLoader.startupProcess(stringArray);
        new RSSOwlLoader();
    }

    private static void createArchiveDir() {
        File file = new File(GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "archive");
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static void createCacheDir() {
        File file = new File(GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "cache");
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static void createLogDir() {
        File file = new File(GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "logs");
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static void createTempDir() {
        File file = new File(GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "tmp");
        if (!file.exists()) {
            file.mkdir();
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
    }

    private static void createWorkingDir() {
        File file;
        File file2;
        String string;
        String string2 = GlobalSettings.isMac() ? System.getProperty("user.home") + GlobalSettings.PATH_SEPARATOR + "Library/Preferences" : System.getProperty("user.home");
        String string3 = string = GlobalSettings.isMac() ? "rssowl" : ".rssowl";
        if (GlobalSettings.isMac() && new File(string2 + GlobalSettings.PATH_SEPARATOR + ".rssowl").exists()) {
            string = ".rssowl";
        }
        if (!(file2 = new File(string2 + GlobalSettings.PATH_SEPARATOR + string)).exists() && FileShop.isMediumWriteable(file2)) {
            file2.mkdir();
        }
        if (FileShop.isMediumWriteable(file = new File(string2 + GlobalSettings.PATH_SEPARATOR + string + GlobalSettings.PATH_SEPARATOR + "tempdir.tmp"))) {
            GlobalSettings.WORKING_DIR = string2 + GlobalSettings.PATH_SEPARATOR + string;
            return;
        }
        file = new File(System.getProperty("user.dir") + GlobalSettings.PATH_SEPARATOR + "tempdir.tmp");
        if (FileShop.isMediumWriteable(file)) {
            GlobalSettings.WORKING_DIR = System.getProperty("user.dir");
            return;
        }
        file = new File(System.getProperty("java.io.tmpdir") + GlobalSettings.PATH_SEPARATOR + "tempdir.tmp");
        if (FileShop.isMediumWriteable(file)) {
            GlobalSettings.WORKING_DIR = System.getProperty("java.io.tmpdir");
        }
    }

    private static void initDebugMode() {
        try {
            File file = new File(GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "debug.log");
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            System.setErr(printStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "trace");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.err.println(BrowserShop.getOwlAgent());
    }

    public static boolean isValidArgument(String string) {
        if (string.indexOf(".exe") < 0 && URLShop.looksLikeNewsfeed(string, true) && new File(string).exists()) {
            return true;
        }
        return RegExShop.isValidURL(string);
    }

    private static void setFilePathes() {
        GlobalSettings.RSSOWL_SETTINGS_FILE = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "user.xml";
        GlobalSettings.RSSOWL_SETTINGS_BACKUP_FILE = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "user.bak";
        GlobalSettings.CRYPT_FILE = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + ".user";
        GlobalSettings.TEMP_DIR = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "tmp";
        GlobalSettings.TEMP_EXPORT_FILE = GlobalSettings.TEMP_DIR + GlobalSettings.PATH_SEPARATOR + "export.tmp";
        GlobalSettings.TEMP_FEED_FILE = GlobalSettings.TEMP_DIR + GlobalSettings.PATH_SEPARATOR + "rssfeed.tmp";
        GlobalSettings.ARCHIVE_DIR = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "archive";
        GlobalSettings.CACHE_DIR = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "cache";
        GlobalSettings.LOGS_DIR = GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "logs";
    }

    private static void setUpProperties() {
        if (GlobalSettings.isMac()) {
            System.setProperty("org.eclipse.swt.internal.carbon.noFocusRing", "true");
        }
        if (GlobalSettings.isMac()) {
            System.setProperty("org.eclipse.swt.internal.carbon.smallFonts", "true");
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "false");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "fatal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startupProcess(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringShop.isset(stringArray[i])) continue;
            String string = stringArray[i].trim();
            if (string.startsWith("feed://")) {
                string = string.substring("feed://".length());
            } else if (string.startsWith("feed:")) {
                string = string.substring("feed:".length());
            }
            if (!RSSOwlLoader.isValidArgument(string)) continue;
            feedArgument = string;
            break;
        }
        if (!System.getProperties().containsKey(PROPERTY_ALLOW_MULTI_INSTANCES) && StartupManager.isRSSOwlRunning(feedArgument)) {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {
                System.exit(0);
            }
            finally {
                System.exit(0);
            }
        }
        if (System.getProperties().containsKey(PROPERTY_DEBUG_MODE)) {
            GlobalSettings._IS_DEBUG = true;
        }
        RSSOwlLoader.createWorkingDir();
        RSSOwlLoader.createArchiveDir();
        RSSOwlLoader.createCacheDir();
        RSSOwlLoader.createLogDir();
        RSSOwlLoader.createTempDir();
        RSSOwlLoader.setFilePathes();
        RSSOwlLoader.setUpProperties();
        if (GlobalSettings._IS_DEBUG) {
            RSSOwlLoader.initDebugMode();
        }
    }
}

