/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class RSSOwlMenu
implements ITranslatable {
    public static final String[] menuStructure = new String[]{"MENU_FILE", "MENU_EDIT", "MENU_WINDOW", "MENU_GOTO", "TABLE_HEADER_FEED", "HEADER_RSS_FAVORITES", "MENU_TOOLS"};
    public static String[][] subMenuStructure = new String[][]{{"MENU_NEW_FAVORITE", "BUTTON_OPEN", "MENU_CLOSE", "MENU_CLOSE_ALL", "MENU_SAVE", "MENU_GENERATE_PDF", "MENU_GENERATE_RTF", "MENU_GENERATE_HTML", "TOOLTIP_PRINT", "MENU_WORK_OFFLINE", "MENU_EXIT"}, {"MENU_EDIT_CUT", "MENU_EDIT_COPY", "MENU_EDIT_PASTE", "MENU_EDIT_SELECT_ALL", "POP_PROPERTIES"}, {"MENU_BROWSER_FOR_NEWSTEXT", "MENU_TOOLBAR", "MENU_QUICKVIEW", "HEADER_RSS_FAVORITES", "MENU_DISPLAY_FEED_PDF", "MENU_DISPLAY_FEED_RTF", "MENU_DISPLAY_FEED_HTML", "MENU_MINIMIZE_RSSOWL"}, {"MENU_PREVIOUS_TAB", "MENU_NEXT_TAB", "MENU_NEXT_NEWS", "MENU_NEXT_UNREAD_NEWS"}, {"POP_MARK_UNREAD", "POP_MARK_ALL_READ", "MENU_RELOAD", "BUTTON_SEARCH", "POP_MAIL_LINK", "POP_COPY_NEWS_URL", "POP_BLOG_NEWS"}, {"BUTTON_ADDTO_FAVORITS", "BUTTON_AGGREGATE_ALL", "BUTTON_RELOAD_ALL", "BUTTON_SEARCH_ALL", "BUTTON_MARK_ALL_READ"}, {"MENU_FEEDSEARCH", "MENU_FEED_DISCOVERY", "MENU_VALIDATE", "MENU_PREFERENCES"}};
    private MenuItem about;
    private MenuItem addToFavorites;
    private MenuItem aggregateAll;
    private MenuItem blogNews;
    private MenuItem cascadeItemCreateOPML;
    private MenuItem cascadeItemImportBlogroll;
    private MenuItem cascadeItemImportOPML;
    private MenuItem closeAllTabs;
    private MenuItem closeCurrentTab;
    private MenuItem copy;
    private MenuItem copyUrlItem;
    private MenuItem customizeToolBar;
    private MenuItem cut;
    private MenuItem delete;
    private MenuItem donate;
    private MenuItem edit;
    private MenuItem exitItem;
    private MenuItem export;
    private MenuItem exportHtml;
    private MenuItem exportPdf;
    private MenuItem exportRtf;
    private MenuItem faq;
    private MenuItem favorites;
    private MenuItem feedDiscovery;
    private MenuItem file;
    private MenuItem find;
    private MenuItem gotoNews;
    private Menu gotoNewsMenu;
    private MenuItem gotoNextNews;
    private MenuItem gotoNextTab;
    private MenuItem gotoNextUnreadNews;
    private MenuItem gotoPreviousTab;
    private MenuItem homepage;
    private MenuItem importMenu;
    private MenuItem info;
    private Menu infomenu;
    private boolean isMac;
    private MenuItem license;
    private MenuItem mailingList;
    private MenuItem mailLinkToFriend;
    private MenuItem markAllRead;
    private MenuItem markAllReadItem;
    private MenuItem markUnreadItem;
    private Menu menu;
    private MenuItem minimizeWindow;
    private MenuItem newCategory;
    private MenuItem newFavorite;
    private MenuItem newItem;
    private MenuItem newsheader;
    private Menu newsheaderMenu;
    private MenuItem newSubCategory;
    private MenuItem open;
    private MenuItem paste;
    private MenuItem preferences;
    private MenuItem printNews;
    private MenuItem properties;
    private MenuItem readNewsInHTML;
    private MenuItem readNewsInPDF;
    private MenuItem readNewsInRTF;
    private MenuItem reload;
    private MenuItem reloadAll;
    private MenuItem rssSearch;
    private MenuItem saveNewsFeed;
    private MenuItem searchAll;
    private MenuItem selectAll;
    Shell shell;
    private MenuItem tellMyFriends;
    private MenuItem tools;
    private Menu toolsMenu;
    private MenuItem tutorial;
    private MenuItem update;
    private MenuItem validateFeed;
    private MenuItem welcome;
    private MenuItem window;
    private Menu windowmenu;
    EventManager eventManager;
    MenuItem favoritesTreeWindow;
    Menu filemenu;
    MenuItem quickviewWindow;
    GUI rssOwlGui;
    MenuItem toolBarWindow;
    MenuItem useBrowserForNewsText;
    MenuItem workOffline;

    public RSSOwlMenu(GUI gUI, Shell shell, EventManager eventManager) {
        this.rssOwlGui = gUI;
        this.shell = shell;
        this.eventManager = eventManager;
        this.isMac = GlobalSettings.isMac();
        this.initComponents();
    }

    public void initMnemonics() {
        MenuManager.initMnemonics(this.menu);
    }

    public void setFavoritesTreeMenuEnabled(boolean bl) {
        if (WidgetShop.isset(this.favoritesTreeWindow)) {
            this.favoritesTreeWindow.setSelection(bl);
        }
    }

    public void setQuickviewMenuEnabled(boolean bl) {
        if (WidgetShop.isset(this.quickviewWindow)) {
            this.quickviewWindow.setSelection(bl);
        }
    }

    public void setToolBarMenuEnabled(boolean bl) {
        if (WidgetShop.isset(this.toolBarWindow)) {
            this.toolBarWindow.setSelection(bl);
        }
    }

    public void setUseBrowserForNewsText(boolean bl) {
        this.useBrowserForNewsText.setSelection(bl);
    }

    public void updateAccelerator(MenuItem menuItem, String string, boolean bl, boolean bl2) {
        this.updateAccelerator(menuItem, string, string, bl, bl2);
    }

    public void updateAccelerators() {
        this.updateAccelerators(false);
    }

    public void updateAccelerators(boolean bl) {
        this.updateAccelerator(this.newFavorite, "LABEL_FAVORITE", "MENU_NEW_FAVORITE", true, bl);
        this.updateAccelerator(this.open, "BUTTON_OPEN", true, bl);
        this.updateAccelerator(this.closeCurrentTab, "MENU_CLOSE", false, bl);
        this.updateAccelerator(this.closeAllTabs, "MENU_CLOSE_ALL", false, bl);
        this.updateAccelerator(this.saveNewsFeed, "MENU_SAVE", true, bl);
        if (GlobalSettings.useIText()) {
            this.updateAccelerator(this.exportPdf, "MENU_GENERATE_PDF", true, bl);
            this.updateAccelerator(this.exportRtf, "MENU_GENERATE_RTF", true, bl);
        }
        this.updateAccelerator(this.exportHtml, "MENU_GENERATE_HTML", true, bl);
        if (GlobalSettings.usePrinting()) {
            this.updateAccelerator(this.printNews, "TOOLTIP_PRINT", true, bl);
        }
        this.updateAccelerator(this.workOffline, "MENU_WORK_OFFLINE", false, bl);
        if (!GlobalSettings.isMac()) {
            this.updateAccelerator(this.exitItem, "MENU_EXIT", false, bl);
        }
        this.updateAccelerator(this.cut, "MENU_EDIT_CUT", false, bl);
        this.updateAccelerator(this.paste, "MENU_EDIT_PASTE", false, bl);
        this.updateAccelerator(this.selectAll, "MENU_EDIT_SELECT_ALL", false, bl);
        this.updateAccelerator(this.copy, "MENU_EDIT_COPY", false, bl);
        this.updateAccelerator(this.properties, "POP_PROPERTIES", false, bl);
        this.updateAccelerator(this.find, "BUTTON_SEARCH", true, bl);
        this.updateAccelerator(this.reload, "MENU_RELOAD", false, bl);
        this.updateAccelerator(this.addToFavorites, "BUTTON_ADDTO_FAVORITS", true, bl);
        this.updateAccelerator(this.mailLinkToFriend, "POP_MAIL_LINK", false, bl);
        this.updateAccelerator(this.blogNews, "POP_BLOG_NEWS", false, bl);
        this.updateAccelerator(this.copyUrlItem, "POP_COPY_NEWS_URL", false, bl);
        this.updateAccelerator(this.markUnreadItem, "POP_MARK_UNREAD", false, bl);
        this.updateAccelerator(this.markAllReadItem, "POP_MARK_ALL_READ", false, bl);
        this.updateAccelerator(this.markAllRead, "BUTTON_MARK_ALL_READ", false, bl);
        this.updateAccelerator(this.reloadAll, "BUTTON_RELOAD_ALL", false, bl);
        this.updateAccelerator(this.aggregateAll, "BUTTON_AGGREGATE_ALL", false, bl);
        this.updateAccelerator(this.searchAll, "BUTTON_SEARCH_ALL", false, bl);
        if (GlobalSettings.useInternalBrowser()) {
            this.updateAccelerator(this.useBrowserForNewsText, "MENU_BROWSER_FOR_NEWSTEXT", false, bl);
        }
        this.updateAccelerator(this.minimizeWindow, "MENU_MINIMIZE_RSSOWL", false, bl);
        this.updateAccelerator(this.toolBarWindow, "MENU_TOOLBAR", false, bl);
        this.updateAccelerator(this.quickviewWindow, "MENU_QUICKVIEW", false, bl);
        this.updateAccelerator(this.favoritesTreeWindow, "HEADER_RSS_FAVORITES", false, bl);
        if (GlobalSettings.useIText()) {
            this.updateAccelerator(this.readNewsInPDF, "MENU_DISPLAY_FEED_PDF", false, bl);
            this.updateAccelerator(this.readNewsInRTF, "MENU_DISPLAY_FEED_RTF", false, bl);
        }
        this.updateAccelerator(this.readNewsInHTML, "MENU_DISPLAY_FEED_HTML", false, bl);
        this.updateAccelerator(this.gotoPreviousTab, "MENU_PREVIOUS_TAB", false, bl);
        this.updateAccelerator(this.gotoNextTab, "MENU_NEXT_TAB", false, bl);
        this.updateAccelerator(this.gotoNextNews, "MENU_NEXT_NEWS", false, bl);
        this.updateAccelerator(this.gotoNextUnreadNews, "MENU_NEXT_UNREAD_NEWS", false, bl);
        this.updateAccelerator(this.rssSearch, "MENU_FEEDSEARCH", true, bl);
        this.updateAccelerator(this.feedDiscovery, "MENU_FEED_DISCOVERY", true, bl);
        this.updateAccelerator(this.validateFeed, "MENU_VALIDATE", true, bl);
        this.updateAccelerator(this.preferences, "MENU_PREFERENCES", true, bl);
    }

    @Override
    public void updateI18N() {
        this.file.setText(GUI.i18n.getTranslation("MENU_FILE"));
        this.newItem.setText(GUI.i18n.getTranslation("POP_NEW"));
        this.newCategory.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + "...");
        this.newSubCategory.setText(GUI.i18n.getTranslation("POP_SUB_CATEGORY") + "...");
        this.importMenu.setText(GUI.i18n.getTranslation("POP_IMPORT"));
        this.cascadeItemImportOPML.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
        this.cascadeItemImportBlogroll.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
        this.cascadeItemCreateOPML.setText(GUI.i18n.getTranslation("POP_EXPORT_OPML") + "...");
        this.export.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
        this.edit.setText(GUI.i18n.getTranslation("MENU_EDIT"));
        this.delete.setText(GUI.i18n.getTranslation("MENU_EDIT_DELETE") + "\t" + GUI.i18n.getTranslation("LABEL_KEY_DEL"));
        this.window.setText(GUI.i18n.getTranslation("MENU_WINDOW"));
        this.customizeToolBar.setText(GUI.i18n.getTranslation("POP_CUSTOMIZE_TOOLBAR") + "...");
        this.preferences.setText(GUI.i18n.getTranslation("MENU_PREFERENCES") + "...");
        this.mailingList.setText(GUI.i18n.getTranslation("MENU_MAILING_LIST"));
        this.welcome.setText(GUI.i18n.getTranslation("MENU_WELCOME"));
        this.tutorial.setText(GUI.i18n.getTranslation("MENU_TUTORIAL"));
        this.license.setText(GUI.i18n.getTranslation("MENU_LICENSE"));
        this.update.setText(GUI.i18n.getTranslation("MENU_UPDATE"));
        this.info.setText(GUI.i18n.getTranslation("MENU_INFO"));
        this.about.setText(GUI.i18n.getTranslation("MENU_ABOUT"));
        this.donate.setText(GUI.i18n.getTranslation("MENU_DONATE"));
        this.tools.setText(GUI.i18n.getTranslation("MENU_TOOLS"));
        this.gotoNews.setText(GUI.i18n.getTranslation("MENU_GOTO"));
        this.newsheader.setText(GUI.i18n.getTranslation("TABLE_HEADER_FEED"));
        this.homepage.setText(GUI.i18n.getTranslation("CHANNEL_INFO_HOMEPAGE"));
        this.tellMyFriends.setText(GUI.i18n.getTranslation("MENU_TELL_FRIENDS"));
        this.favorites.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        this.updateAccelerators();
        MenuManager.initMnemonics(this.menu.getItems());
    }

    public void updateOfflineModeItem() {
        if (GlobalSettings.isMac()) {
            this.workOffline.setSelection(GlobalSettings.workOffline);
        } else {
            this.workOffline.setImage(GlobalSettings.workOffline ? PaintShop.iconChecked : null);
        }
        this.shell.setText(WidgetShop.getShellTitle());
    }

    private void initComponents() {
        this.menu = new Menu(this.shell, 2);
        this.shell.setMenuBar(this.menu);
        this.file = new MenuItem(this.menu, 64);
        this.file.setText(GUI.i18n.getTranslation("MENU_FILE"));
        this.filemenu = new Menu(this.shell, 4);
        this.file.setMenu(this.filemenu);
        this.newItem = new MenuItem(this.filemenu, 64);
        if (!GlobalSettings.isMac()) {
            this.newItem.setImage(PaintShop.iconNew);
        }
        Menu menu = new Menu(this.shell, 4);
        this.newItem.setMenu(menu);
        this.newItem.setText(GUI.i18n.getTranslation("POP_NEW"));
        this.newFavorite = new MenuItem(menu, 8);
        if (!GlobalSettings.isMac()) {
            this.newFavorite.setImage(PaintShop.iconAddToFavorites);
        }
        this.newFavorite.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionNewFavorite();
            }
        });
        new MenuItem(menu, 2);
        this.newCategory = new MenuItem(menu, 8);
        this.newCategory.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + "...");
        if (!GlobalSettings.isMac()) {
            this.newCategory.setImage(PaintShop.iconAddCategory);
        }
        this.newCategory.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionNewCategory();
            }
        });
        this.newSubCategory = new MenuItem(menu, 8);
        this.newSubCategory.setText(GUI.i18n.getTranslation("POP_SUB_CATEGORY") + "...");
        if (!GlobalSettings.isMac()) {
            this.newSubCategory.setImage(PaintShop.iconSubCategory);
        }
        this.newSubCategory.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionNewCategory(true);
            }
        });
        MenuManager.registerNewItems(this.newCategory, this.newSubCategory);
        this.open = new MenuItem(this.filemenu, 8);
        this.open.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenFeed();
            }
        });
        new MenuItem(this.filemenu, 2);
        this.closeCurrentTab = new MenuItem(this.filemenu, 8);
        this.closeCurrentTab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionCloseCurrent();
            }
        });
        this.closeAllTabs = new MenuItem(this.filemenu, 8);
        this.closeAllTabs.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionCloseAll();
            }
        });
        MenuManager.registerCloseTab(this.closeCurrentTab, this.closeAllTabs);
        new MenuItem(this.filemenu, 2);
        this.saveNewsFeed = new MenuItem(this.filemenu, 8);
        if (!GlobalSettings.isMac()) {
            this.saveNewsFeed.setImage(PaintShop.loadImage("/img/icons/save_as.gif"));
            this.saveNewsFeed.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.saveNewsFeed.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.eventManager.actionSaveFeed();
            }
        });
        MenuManager.registerSaveRSS(this.saveNewsFeed);
        if (GlobalSettings.useIText()) {
            new MenuItem(this.filemenu, 2);
            this.exportPdf = new MenuItem(this.filemenu, 8);
            this.exportPdf.setText(GUI.i18n.getTranslation("MENU_GENERATE_PDF"));
            if (!GlobalSettings.isMac()) {
                this.exportPdf.setImage(PaintShop.iconPDF);
            }
            this.exportPdf.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    RSSOwlMenu.this.eventManager.actionExportFeed(0);
                }
            });
            this.exportRtf = new MenuItem(this.filemenu, 8);
            this.exportRtf.setText(GUI.i18n.getTranslation("MENU_GENERATE_RTF"));
            if (!GlobalSettings.isMac()) {
                this.exportRtf.setImage(PaintShop.iconRTF);
            }
            this.exportRtf.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    RSSOwlMenu.this.eventManager.actionExportFeed(2);
                }
            });
        }
        this.exportHtml = new MenuItem(this.filemenu, 8);
        this.exportHtml.setText(GUI.i18n.getTranslation("MENU_GENERATE_HTML"));
        if (!GlobalSettings.isMac()) {
            this.exportHtml.setImage(PaintShop.iconHTML);
        }
        this.exportHtml.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionExportFeed(1);
            }
        });
        MenuManager.registerExport(this.exportPdf, this.exportRtf, this.exportHtml);
        new MenuItem(this.filemenu, 2);
        if (GlobalSettings.usePrinting()) {
            this.printNews = new MenuItem(this.filemenu, 8);
            if (!GlobalSettings.isMac()) {
                this.printNews.setImage(PaintShop.iconPrint);
            }
            this.printNews.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    RSSOwlMenu.this.eventManager.actionPrintNews();
                }
            });
            MenuManager.regiserPrint(this.printNews);
            new MenuItem(this.filemenu, 2);
        }
        this.importMenu = new MenuItem(this.filemenu, 64);
        this.importMenu.setText(GUI.i18n.getTranslation("POP_IMPORT"));
        if (!GlobalSettings.isMac()) {
            this.importMenu.setImage(PaintShop.iconImport);
        }
        Menu menu2 = new Menu(this.shell, 4);
        this.importMenu.setMenu(menu2);
        this.cascadeItemImportOPML = new MenuItem(menu2, 8);
        this.cascadeItemImportOPML.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
        if (!GlobalSettings.isMac()) {
            this.cascadeItemImportOPML.setImage(PaintShop.iconImportOpml);
        }
        this.cascadeItemImportOPML.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionImportOPML();
            }
        });
        this.cascadeItemImportBlogroll = new MenuItem(menu2, 8);
        this.cascadeItemImportBlogroll.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
        if (!GlobalSettings.isMac()) {
            this.cascadeItemImportBlogroll.setImage(PaintShop.iconAddBlogroll);
        }
        this.cascadeItemImportBlogroll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionImportBlogroll();
            }
        });
        this.export = new MenuItem(this.filemenu, 64);
        this.export.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
        if (!GlobalSettings.isMac()) {
            this.export.setImage(PaintShop.iconExport);
        }
        MenuManager.registerExportMenuItem(this.export);
        Menu menu3 = new Menu(this.shell, 4);
        this.export.setMenu(menu3);
        this.cascadeItemCreateOPML = new MenuItem(menu3, 8);
        this.cascadeItemCreateOPML.setText(GUI.i18n.getTranslation("POP_EXPORT_OPML") + "...");
        if (!GlobalSettings.isMac()) {
            this.cascadeItemCreateOPML.setImage(PaintShop.iconExportOpml);
        }
        this.cascadeItemCreateOPML.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionCategoryToOPML(Category.getRootCategory(), "rssowl.opml");
            }
        });
        new MenuItem(this.filemenu, 2);
        this.workOffline = new MenuItem(this.filemenu, GlobalSettings.isMac() ? 32 : 8);
        this.updateOfflineModeItem();
        this.workOffline.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = GlobalSettings.workOffline = !GlobalSettings.workOffline;
                if (!GlobalSettings.isMac()) {
                    RSSOwlMenu.this.workOffline.setImage(GlobalSettings.workOffline ? PaintShop.iconChecked : null);
                }
                RSSOwlMenu.this.shell.setText(WidgetShop.getShellTitle());
            }
        });
        if (!GlobalSettings.isMac()) {
            new MenuItem(this.filemenu, 2);
            this.exitItem = new MenuItem(this.filemenu, 8);
            this.exitItem.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    RSSOwlMenu.this.eventManager.actionExit();
                }
            });
        }
        this.edit = new MenuItem(this.menu, 64);
        this.edit.setText(GUI.i18n.getTranslation("MENU_EDIT"));
        Menu menu4 = new Menu(this.shell, 4);
        this.edit.setMenu(menu4);
        menu4.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                MenuManager.handleEditMenuState();
            }
        });
        this.cut = new MenuItem(menu4, 8);
        if (!GlobalSettings.isMac()) {
            this.cut.setImage(PaintShop.loadImage("/img/icons/cut.gif"));
            this.cut.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.cut.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.handleEditAction(0);
            }
        });
        this.copy = new MenuItem(menu4, 8);
        if (!GlobalSettings.isMac()) {
            this.copy.setImage(PaintShop.iconCopy);
        }
        this.copy.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.handleEditAction(1);
            }
        });
        this.paste = new MenuItem(menu4, 8);
        if (!GlobalSettings.isMac()) {
            this.paste.setImage(PaintShop.loadImage("/img/icons/paste.gif"));
            this.paste.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.paste.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.handleEditAction(2);
            }
        });
        new MenuItem(menu4, 2);
        this.delete = new MenuItem(menu4, 8);
        this.delete.setText(GUI.i18n.getTranslation("MENU_EDIT_DELETE") + "\t" + GUI.i18n.getTranslation("LABEL_KEY_DEL"));
        if (!GlobalSettings.isMac()) {
            this.delete.setImage(PaintShop.iconDelete);
        }
        this.delete.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.handleEditAction(3);
            }
        });
        this.selectAll = new MenuItem(menu4, 8);
        this.selectAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.handleEditAction(4);
            }
        });
        new MenuItem(menu4, 2);
        this.properties = new MenuItem(menu4, 8);
        this.properties.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.handleEditAction(5);
            }
        });
        MenuManager.registerEditMenu(this.copy, this.paste, this.cut, this.selectAll, this.delete, this.properties);
        this.window = new MenuItem(this.menu, 64);
        this.window.setText(GUI.i18n.getTranslation("MENU_WINDOW"));
        this.windowmenu = new Menu(this.shell, 4);
        this.window.setMenu(this.windowmenu);
        if (GlobalSettings.useInternalBrowser()) {
            this.useBrowserForNewsText = new MenuItem(this.windowmenu, 32);
            this.useBrowserForNewsText.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    RSSOwlMenu.this.eventManager.actionSetBrowserView(RSSOwlMenu.this.useBrowserForNewsText.getSelection());
                }
            });
            new MenuItem(this.windowmenu, 2);
        }
        this.toolBarWindow = new MenuItem(this.windowmenu, 32);
        this.toolBarWindow.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.eventManager.actionShowToolBar(RSSOwlMenu.this.toolBarWindow.getSelection());
            }
        });
        this.quickviewWindow = new MenuItem(this.windowmenu, 32);
        this.quickviewWindow.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.eventManager.actionShowQuickview(RSSOwlMenu.this.quickviewWindow.getSelection());
            }
        });
        this.favoritesTreeWindow = new MenuItem(this.windowmenu, 32);
        this.favoritesTreeWindow.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.rssOwlGui.setFavoritesMinimized(!RSSOwlMenu.this.favoritesTreeWindow.getSelection(), true);
            }
        });
        new MenuItem(this.windowmenu, 2);
        this.customizeToolBar = new MenuItem(this.windowmenu, 0);
        this.customizeToolBar.setText(GUI.i18n.getTranslation("POP_CUSTOMIZE_TOOLBAR") + "...");
        this.customizeToolBar.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.eventManager.actionCustomizeToolBar();
            }
        });
        new MenuItem(this.windowmenu, 2);
        if (GlobalSettings.useIText()) {
            this.readNewsInPDF = new MenuItem(this.windowmenu, 0);
            this.readNewsInPDF.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    RSSOwlMenu.this.eventManager.actionViewFeedInDocument(0);
                }
            });
            this.readNewsInRTF = new MenuItem(this.windowmenu, 0);
            this.readNewsInRTF.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    RSSOwlMenu.this.eventManager.actionViewFeedInDocument(2);
                }
            });
        }
        this.readNewsInHTML = new MenuItem(this.windowmenu, 0);
        this.readNewsInHTML.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.eventManager.actionViewFeedInDocument(1);
            }
        });
        MenuManager.registerReadNewsInDocument(this.readNewsInPDF, this.readNewsInRTF, this.readNewsInHTML);
        new MenuItem(this.windowmenu, 2);
        this.minimizeWindow = new MenuItem(this.windowmenu, 0);
        this.minimizeWindow.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RSSOwlMenu.this.eventManager.actionMinimizeWindow();
            }
        });
        this.gotoNews = new MenuItem(this.menu, 64);
        this.gotoNews.setText(GUI.i18n.getTranslation("MENU_GOTO"));
        this.gotoNewsMenu = new Menu(this.shell, 4);
        this.gotoNews.setMenu(this.gotoNewsMenu);
        this.gotoPreviousTab = new MenuItem(this.gotoNewsMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.gotoPreviousTab.setImage(PaintShop.iconBackward);
        }
        this.gotoPreviousTab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionGotoPreviousTab();
            }
        });
        this.gotoNextTab = new MenuItem(this.gotoNewsMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.gotoNextTab.setImage(PaintShop.iconForward);
        }
        this.gotoNextTab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionGotoNextTab();
            }
        });
        MenuManager.registerGotoTab(this.gotoPreviousTab, this.gotoNextTab);
        new MenuItem(this.gotoNewsMenu, 2);
        this.gotoNextNews = new MenuItem(this.gotoNewsMenu, 0);
        this.gotoNextNews.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionGotoNextNews();
            }
        });
        this.gotoNextUnreadNews = new MenuItem(this.gotoNewsMenu, 0);
        this.gotoNextUnreadNews.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionGotoNextUnreadNews();
            }
        });
        this.newsheader = new MenuItem(this.menu, 64);
        this.newsheader.setText(GUI.i18n.getTranslation("TABLE_HEADER_FEED"));
        this.newsheaderMenu = new Menu(this.shell, 4);
        this.newsheader.setMenu(this.newsheaderMenu);
        this.markUnreadItem = new MenuItem(this.newsheaderMenu, 0);
        this.markUnreadItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionMarkNewsUnread();
            }
        });
        MenuManager.registerMarkUnreadItem(this.markUnreadItem);
        this.markAllReadItem = new MenuItem(this.newsheaderMenu, 0);
        this.markAllReadItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionMarkAllNewsRead();
            }
        });
        MenuManager.registerMarkAllReadItem(this.markAllReadItem);
        new MenuItem(this.newsheaderMenu, 2);
        this.reload = new MenuItem(this.newsheaderMenu, 8);
        if (!GlobalSettings.isMac()) {
            this.reload.setImage(PaintShop.iconReload);
        }
        this.reload.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionReload();
            }
        });
        MenuManager.registerReload(this.reload);
        new MenuItem(this.newsheaderMenu, 2);
        this.find = new MenuItem(this.newsheaderMenu, 8);
        if (!GlobalSettings.isMac()) {
            this.find.setImage(PaintShop.iconFind);
        }
        this.find.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionSearch();
            }
        });
        MenuManager.registerSearch(this.find);
        new MenuItem(this.newsheaderMenu, 2);
        this.mailLinkToFriend = new MenuItem(this.newsheaderMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.mailLinkToFriend.setImage(PaintShop.iconMail);
        }
        this.mailLinkToFriend.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionMailNewsTip();
            }
        });
        MenuManager.registerNewsTipMail(this.mailLinkToFriend);
        this.copyUrlItem = new MenuItem(this.newsheaderMenu, 0);
        this.copyUrlItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionCopyNewsUrl();
            }
        });
        MenuManager.registerCopyLink(this.copyUrlItem);
        new MenuItem(this.newsheaderMenu, 2);
        this.blogNews = new MenuItem(this.newsheaderMenu, 0);
        this.blogNews.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionBlogNews();
            }
        });
        MenuManager.regiserBlogNews(this.blogNews);
        this.favorites = new MenuItem(this.menu, 64);
        this.favorites.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        Menu menu5 = new Menu(this.shell, 4);
        this.favorites.setMenu(menu5);
        this.addToFavorites = new MenuItem(menu5, 8);
        this.addToFavorites.setText(GUI.i18n.getTranslation("BUTTON_ADDTO_FAVORITS"));
        if (!GlobalSettings.isMac()) {
            this.addToFavorites.setImage(PaintShop.iconAddToFavorites);
        }
        this.addToFavorites.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionAddToFavorites();
            }
        });
        MenuManager.registerAddFavoriteMenu(this.addToFavorites);
        new MenuItem(menu5, 2);
        this.aggregateAll = new MenuItem(menu5, 0);
        this.aggregateAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionAggregateAllCategories();
            }
        });
        this.reloadAll = new MenuItem(menu5, 0);
        this.reloadAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionReloadAllCategories();
            }
        });
        this.searchAll = new MenuItem(menu5, 0);
        this.searchAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionSearchInAllCategories();
            }
        });
        new MenuItem(menu5, 2);
        this.markAllRead = new MenuItem(menu5, 0);
        this.markAllRead.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionMarkAllCategoriesRead();
            }
        });
        this.tools = new MenuItem(this.menu, 64);
        this.tools.setText(GUI.i18n.getTranslation("MENU_TOOLS"));
        this.toolsMenu = new Menu(this.shell, 4);
        this.tools.setMenu(this.toolsMenu);
        this.rssSearch = new MenuItem(this.toolsMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.rssSearch.setImage(PaintShop.iconSearch);
        }
        this.rssSearch.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionSearchFeeds();
            }
        });
        this.feedDiscovery = new MenuItem(this.toolsMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.feedDiscovery.setImage(PaintShop.iconFeedDiscovery);
        }
        this.feedDiscovery.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionDiscoverFeeds();
            }
        });
        new MenuItem(this.toolsMenu, 2);
        this.validateFeed = new MenuItem(this.toolsMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.validateFeed.setImage(PaintShop.iconValidate);
        }
        this.validateFeed.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionValidateFeeds(false);
            }
        });
        new MenuItem(this.toolsMenu, 2);
        this.preferences = new MenuItem(this.toolsMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.preferences.setImage(PaintShop.loadImage("/img/icons/preferences.gif"));
            this.preferences.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.preferences.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenPreferences();
            }
        });
        this.info = new MenuItem(this.menu, 64);
        this.info.setText(GUI.i18n.getTranslation("MENU_INFO"));
        this.infomenu = new Menu(this.shell, 4);
        this.info.setMenu(this.infomenu);
        this.tutorial = new MenuItem(this.infomenu, 8);
        this.tutorial.setText(GUI.i18n.getTranslation("MENU_TUTORIAL"));
        if (!GlobalSettings.isMac()) {
            this.tutorial.setImage(PaintShop.loadImage("/img/icons/tutorial.gif"));
            this.tutorial.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.tutorial.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenTutorial();
            }
        });
        this.faq = new MenuItem(this.infomenu, 8);
        this.faq.setText("FAQ");
        if (!GlobalSettings.isMac()) {
            this.faq.setImage(PaintShop.loadImage("/img/icons/faq.gif"));
            this.faq.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.faq.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenFAQ();
            }
        });
        new MenuItem(this.infomenu, 2);
        this.welcome = new MenuItem(this.infomenu, 8);
        this.welcome.setText(GUI.i18n.getTranslation("MENU_WELCOME"));
        this.welcome.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionShowWelcome();
            }
        });
        this.license = new MenuItem(this.infomenu, 8);
        this.license.setText(GUI.i18n.getTranslation("MENU_LICENSE"));
        this.license.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionShowLicense();
            }
        });
        new MenuItem(this.infomenu, 2);
        this.homepage = new MenuItem(this.infomenu, 8);
        this.homepage.setText(GUI.i18n.getTranslation("CHANNEL_INFO_HOMEPAGE"));
        this.homepage.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenURL(URLShop.RSSOWL_WEBPAGE);
            }
        });
        this.mailingList = new MenuItem(this.infomenu, 8);
        this.mailingList.setText(GUI.i18n.getTranslation("MENU_MAILING_LIST"));
        this.mailingList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenURL(URLShop.RSSOWL_LIST);
            }
        });
        new MenuItem(this.infomenu, 2);
        this.update = new MenuItem(this.infomenu, 8);
        this.update.setText(GUI.i18n.getTranslation("MENU_UPDATE"));
        if (!GlobalSettings.isMac()) {
            this.update.setImage(PaintShop.loadImage("/img/icons/update.gif"));
            this.update.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.update.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionCheckUpdate();
            }
        });
        new MenuItem(this.infomenu, 2);
        this.donate = new MenuItem(this.infomenu, 8);
        this.donate.setText(GUI.i18n.getTranslation("MENU_DONATE"));
        this.donate.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenURL(URLShop.RSSOWL_DONATE);
            }
        });
        new MenuItem(this.infomenu, 2);
        this.tellMyFriends = new MenuItem(this.infomenu, 8);
        this.tellMyFriends.setText(GUI.i18n.getTranslation("MENU_TELL_FRIENDS"));
        this.tellMyFriends.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionTellFriends();
            }
        });
        new MenuItem(this.infomenu, 2);
        this.about = new MenuItem(this.infomenu, 8);
        this.about.setText(GUI.i18n.getTranslation("MENU_ABOUT"));
        if (!GlobalSettings.isMac()) {
            this.about.setImage(PaintShop.iconInfo);
        }
        this.about.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                RSSOwlMenu.this.eventManager.actionOpenAbout();
            }
        });
    }

    private void updateAccelerator(MenuItem menuItem, String string, String string2, boolean bl, boolean bl2) {
        boolean bl3;
        String string3 = bl ? "..." : "";
        int n = HotkeyShop.getHotkeyValue(string2);
        boolean bl4 = bl3 = bl2 && HotkeyShop.isPrintableAccelerator(n);
        if (n > 0 && !bl3) {
            menuItem.setAccelerator(n);
            if (this.isMac) {
                menuItem.setText(GUI.i18n.getTranslation(string) + string3);
            } else {
                menuItem.setText(GUI.i18n.getTranslation(string) + string3 + "\t" + HotkeyShop.getHotkeyName(string2));
            }
        } else if (bl3) {
            menuItem.setAccelerator(0);
        } else {
            menuItem.setAccelerator(0);
            menuItem.setText(GUI.i18n.getTranslation(string) + string3);
        }
    }

    static {
        if (GlobalSettings.isLinux()) {
            subMenuStructure = new String[][]{{"MENU_NEW_FAVORITE", "BUTTON_OPEN", "MENU_CLOSE", "MENU_CLOSE_ALL", "MENU_SAVE", "MENU_GENERATE_PDF", "MENU_GENERATE_RTF", "MENU_GENERATE_HTML", "MENU_WORK_OFFLINE", "MENU_EXIT"}, {"MENU_EDIT_CUT", "MENU_EDIT_COPY", "MENU_EDIT_PASTE", "MENU_EDIT_SELECT_ALL", "POP_PROPERTIES"}, {"MENU_BROWSER_FOR_NEWSTEXT", "MENU_TOOLBAR", "MENU_QUICKVIEW", "HEADER_RSS_FAVORITES", "MENU_DISPLAY_FEED_PDF", "MENU_DISPLAY_FEED_RTF", "MENU_DISPLAY_FEED_HTML", "MENU_MINIMIZE_RSSOWL"}, {"MENU_PREVIOUS_TAB", "MENU_NEXT_TAB", "MENU_NEXT_NEWS", "MENU_NEXT_UNREAD_NEWS"}, {"POP_MARK_UNREAD", "POP_MARK_ALL_READ", "MENU_RELOAD", "BUTTON_SEARCH", "POP_MAIL_LINK", "POP_COPY_NEWS_URL", "POP_BLOG_NEWS"}, {"BUTTON_ADDTO_FAVORITS", "BUTTON_AGGREGATE_ALL", "BUTTON_RELOAD_ALL", "BUTTON_SEARCH_ALL", "BUTTON_MARK_ALL_READ"}, {"MENU_FEEDSEARCH", "MENU_FEED_DISCOVERY", "MENU_VALIDATE", "MENU_PREFERENCES"}};
        } else if (GlobalSettings.isMac()) {
            subMenuStructure = new String[][]{{"MENU_NEW_FAVORITE", "BUTTON_OPEN", "MENU_CLOSE", "MENU_CLOSE_ALL", "MENU_SAVE", "MENU_GENERATE_HTML", "TOOLTIP_PRINT", "MENU_WORK_OFFLINE"}, {"MENU_EDIT_CUT", "MENU_EDIT_COPY", "MENU_EDIT_PASTE", "MENU_EDIT_SELECT_ALL", "POP_PROPERTIES"}, {"MENU_BROWSER_FOR_NEWSTEXT", "MENU_TOOLBAR", "MENU_QUICKVIEW", "HEADER_RSS_FAVORITES", "MENU_DISPLAY_FEED_HTML", "MENU_MINIMIZE_RSSOWL"}, {"MENU_PREVIOUS_TAB", "MENU_NEXT_TAB", "MENU_NEXT_NEWS", "MENU_NEXT_UNREAD_NEWS"}, {"POP_MARK_UNREAD", "POP_MARK_ALL_READ", "MENU_RELOAD", "BUTTON_SEARCH", "POP_MAIL_LINK", "POP_COPY_NEWS_URL", "POP_BLOG_NEWS"}, {"BUTTON_ADDTO_FAVORITS", "BUTTON_AGGREGATE_ALL", "BUTTON_RELOAD_ALL", "BUTTON_SEARCH_ALL", "BUTTON_MARK_ALL_READ"}, {"MENU_FEEDSEARCH", "MENU_FEED_DISCOVERY", "MENU_VALIDATE", "MENU_PREFERENCES"}};
        } else if (GlobalSettings.isSolaris()) {
            subMenuStructure = new String[][]{{"MENU_NEW_FAVORITE", "BUTTON_OPEN", "MENU_CLOSE", "MENU_CLOSE_ALL", "MENU_SAVE", "MENU_GENERATE_PDF", "MENU_GENERATE_RTF", "MENU_GENERATE_HTML", "TOOLTIP_PRINT", "MENU_WORK_OFFLINE", "MENU_EXIT"}, {"MENU_EDIT_CUT", "MENU_EDIT_COPY", "MENU_EDIT_PASTE", "MENU_EDIT_SELECT_ALL", "POP_PROPERTIES"}, {"MENU_TOOLBAR", "MENU_QUICKVIEW", "HEADER_RSS_FAVORITES", "MENU_DISPLAY_FEED_PDF", "MENU_DISPLAY_FEED_RTF", "MENU_DISPLAY_FEED_HTML", "MENU_MINIMIZE_RSSOWL"}, {"MENU_PREVIOUS_TAB", "MENU_NEXT_TAB", "MENU_NEXT_NEWS", "MENU_NEXT_UNREAD_NEWS"}, {"POP_MARK_UNREAD", "POP_MARK_ALL_READ", "MENU_RELOAD", "BUTTON_SEARCH", "POP_MAIL_LINK", "POP_COPY_NEWS_URL", "POP_BLOG_NEWS"}, {"BUTTON_ADDTO_FAVORITS", "BUTTON_AGGREGATE_ALL", "BUTTON_RELOAD_ALL", "BUTTON_SEARCH_ALL", "BUTTON_MARK_ALL_READ"}, {"MENU_FEEDSEARCH", "MENU_FEED_DISCOVERY", "MENU_VALIDATE", "MENU_PREFERENCES"}};
        }
    }
}

