/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.io.File;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.panel.BrowserPanel;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TutorialBrowser {
    private Display display;
    private String path;
    private GUI rssOwlGui;
    private Shell shell;

    public TutorialBrowser(Display display, Shell shell, GUI gUI) {
        this.display = display;
        this.shell = shell;
        this.rssOwlGui = gUI;
        this.path = new File(".").getAbsolutePath() + GlobalSettings.PATH_SEPARATOR + "doc" + GlobalSettings.PATH_SEPARATOR + "tutorial" + GlobalSettings.PATH_SEPARATOR + "en" + GlobalSettings.PATH_SEPARATOR + "index.html";
        if (!new File(this.path).exists()) {
            this.path = URLShop.RSSOWL_TUTORIAL;
        }
    }

    private void openTutorialShell() {
        Shell shell = new Shell(this.display);
        try {
            BrowserPanel browserPanel = new BrowserPanel(this.rssOwlGui, shell, true);
            browserPanel.openUrl(this.path);
            shell.setText("RSSOwl " + GUI.i18n.getTranslation("MENU_TUTORIAL"));
            shell.setLayout(new FillLayout());
            if (!GlobalSettings.isMac()) {
                shell.setImages(PaintShop.iconOwl);
            }
            browserPanel.getBrowserPanel().setFocus();
            shell.setMaximized(true);
            shell.open();
        }
        catch (SWTError sWTError) {
            GUI.logger.log("openTutorialShell", sWTError);
            if (WidgetShop.isset(shell)) {
                shell.dispose();
            }
            GlobalSettings.openBrowserExtern = true;
            MessageBoxFactory.showError(this.shell, BrowserShop.createBrowserError(sWTError));
            BrowserShop.openLink(this.path);
        }
    }

    void show() {
        if (GlobalSettings.useInternalBrowser() && !GlobalSettings.openBrowserExtern) {
            this.openTutorialShell();
        } else {
            BrowserShop.openLink(this.path);
        }
    }
}

