/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CategoryDialog
extends TitleAreaDialog {
    private static final int dialogMinWidth = 320;
    private String catName;
    private Text catTitle;
    private String dialogMessage;
    private boolean isEdit;
    private Button okButton;
    private Category parent;
    private String title;

    public CategoryDialog(Shell shell, String string, String string2, Category category) {
        this(shell, string, string2, "", category);
    }

    public CategoryDialog(Shell shell, String string, String string2, String string3, Category category) {
        super(shell);
        this.title = string;
        this.catName = string3;
        this.dialogMessage = string2;
        this.parent = category;
        this.isEdit = !string3.equals("");
    }

    @Override
    public boolean close() {
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    public String getCatName() {
        return this.catName;
    }

    @Override
    protected void buttonPressed(int n) {
        this.catName = n == 0 ? this.catTitle.getText() : null;
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.okButton.setFont(FontShop.dialogFont);
        this.catTitle.setFocus();
        if (this.catName != null) {
            this.catTitle.setText(this.catName);
            this.catTitle.selectAll();
        } else {
            this.okButton.setEnabled(false);
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 5, 20));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/newcat_big.gif"));
        this.setMessage(this.dialogMessage, 1);
        Label label = new Label(composite2, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_TITLE") + ": ");
        label.setLayoutData(new GridData(32));
        label.setFont(FontShop.dialogFont);
        this.catTitle = new Text(composite2, 2052);
        this.catTitle.setLayoutData(new GridData(768));
        this.catTitle.setFont(FontShop.dialogFont);
        this.catTitle.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                CategoryDialog.this.validateInput();
            }
        });
        WidgetShop.tweakTextWidget(this.catTitle);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label2 = new Label(composite3, 258);
        label2.setLayoutData(new GridData(768));
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | CategoryDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }

    protected void validateInput() {
        String string = null;
        if ((this.isEdit && !this.catName.equals(this.catTitle.getText()) || !this.isEdit) && this.parent.getSubCategories().containsKey(this.catTitle.getText())) {
            string = GUI.i18n.getTranslation("ERROR_CAT_EXISTS");
        }
        if (string != null) {
            this.setMessage(string, 3);
        } else {
            this.setMessage(this.dialogMessage, 1);
        }
        this.okButton.setEnabled(string == null && !this.catTitle.getText().equals(""));
    }
}

