/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ConfirmDeleteDialog
extends TitleAreaDialog {
    public static final int TYPE_BLOGROLL = 2;
    public static final int TYPE_CATEGORY = 1;
    public static final int TYPE_FAVORITE = 0;
    private static final int dialogMinWidth = 320;
    private String dialogHeaderMessage;
    private String dialogMessage;
    private Button neverAskAgainCheck;
    private String title;
    private int type;

    public ConfirmDeleteDialog(Shell shell, String string, String string2, String string3, int n) {
        super(shell);
        this.title = string;
        this.dialogMessage = string3;
        this.dialogHeaderMessage = string2;
        this.type = n;
    }

    @Override
    public boolean close() {
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0 && this.neverAskAgainCheck.getSelection()) {
            switch (this.type) {
                case 0: {
                    GlobalSettings.confirmFavoriteDeletion = false;
                    break;
                }
                case 1: {
                    GlobalSettings.confirmCategoryDeletion = false;
                    break;
                }
                case 2: {
                    GlobalSettings.confirmBlogrollDeletion = false;
                }
            }
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        ((GridLayout)composite.getLayout()).marginHeight = 10;
        ((GridLayout)composite.getLayout()).marginWidth = 10;
        if (GUI.display.getDismissalAlignment() == 131072) {
            Button button = this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false);
            button.setFont(FontShop.dialogFont);
            Button button2 = this.createButton(composite, 0, GUI.i18n.getTranslation("MENU_EDIT_DELETE"), true);
            button2.setFont(FontShop.dialogFont);
            button2.setFocus();
        } else {
            Button button = this.createButton(composite, 0, GUI.i18n.getTranslation("MENU_EDIT_DELETE"), true);
            button.setFont(FontShop.dialogFont);
            button.setFocus();
            Button button3 = this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false);
            button3.setFont(FontShop.dialogFont);
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(new GridLayout(1, false));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/trash_big.gif"));
        this.setMessage(this.dialogHeaderMessage, 1);
        Label label = new Label(composite2, 64);
        label.setText(this.dialogMessage);
        label.setLayoutData(new GridData(4, 1, true, false));
        label.setFont(FontShop.dialogFont);
        new Label(composite2, 0);
        this.neverAskAgainCheck = new Button(composite2, 32);
        this.neverAskAgainCheck.setFont(FontShop.dialogFont);
        this.neverAskAgainCheck.setText(GUI.i18n.getTranslation("BUTTON_NEVER_ASK_AGAIN"));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label2 = new Label(composite3, 258);
        label2.setLayoutData(new GridData(768));
        WidgetShop.initMnemonics(new Button[]{this.neverAskAgainCheck});
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | ConfirmDeleteDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }
}

