/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.EditFavoriteProperties;
import net.sourceforge.rssowl.controller.properties.ViewFavoriteProperties;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FavoriteDialog
extends Dialog {
    public static boolean isEditFavorite = false;
    private static final int dialogMinWidth = 400;
    private Favorite editedFavorite;
    private EditFavoriteProperties editFavProps;
    private TabItem infoItem;
    private TabItem settingsItem;
    private TabFolder tabFolder;
    private String title;

    public FavoriteDialog(Favorite favorite, Shell shell, String string) {
        super(shell);
        this.title = string;
        this.editedFavorite = new Favorite("", "", null);
        favorite.duplicate(this.editedFavorite);
    }

    public Favorite getUpdatedFavorite() {
        return this.editedFavorite;
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0) {
            String string = this.editedFavorite.getUrl() != null ? this.editedFavorite.getUrl() : "";
            this.editedFavorite = this.editFavProps.getUpdatedFavorite();
            if (this.editedFavorite.getUrl().equals("")) {
                this.editFavProps.setMessage(GUI.i18n.getTranslation("MESSAGEBOX_FILL_URL"), true);
                this.tabFolder.setSelection(0);
                return;
            }
            if (!StringShop.isset(this.editedFavorite.getCatPath())) {
                this.editFavProps.setMessage(GUI.i18n.getTranslation("MESSAGEBOX_SELECT_CAT"), true);
                this.tabFolder.setSelection(0);
                return;
            }
            if (!string.equals(this.editedFavorite.getUrl())) {
                this.editedFavorite.setUnreadNewsCount(0);
                this.editedFavorite.clearMetaData();
            }
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        shell.setLayout(LayoutShop.createGridLayout(1, 0, 5));
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
        shell.setSize(0, 0);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        ((GridLayout)composite.getLayout()).marginHeight = 5;
        ((GridLayout)composite.getLayout()).marginWidth = 10;
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
        } else {
            this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout(LayoutShop.createFillLayout(5, 5));
        composite2.setLayoutData(new GridData(4, 4, true, true));
        this.tabFolder = new TabFolder(composite2, 128);
        this.tabFolder.setFont(FontShop.dialogFont);
        this.settingsItem = new TabItem(this.tabFolder, 0);
        this.settingsItem.setText(GUI.i18n.getTranslation("POP_PROPERTIES"));
        Composite composite3 = new Composite(this.tabFolder, 0);
        composite3.setLayoutData(new GridData(4, 4, true, true));
        composite3.setLayout(LayoutShop.createGridLayout(1, 5, 0));
        this.editFavProps = new EditFavoriteProperties(composite3, this.editedFavorite);
        this.settingsItem.setControl(composite3);
        if (isEditFavorite) {
            this.infoItem = new TabItem(this.tabFolder, 0);
            this.infoItem.setText(GUI.i18n.getTranslation("MESSAGEBOX_TITLE_INFORMATION"));
            Composite composite4 = new Composite(this.tabFolder, 0);
            composite4.setLayoutData(new GridData(4, 4, true, true));
            composite4.setLayout(LayoutShop.createGridLayout(1, 5, 0));
            new ViewFavoriteProperties(composite4, this.editedFavorite);
            this.infoItem.setControl(composite4);
        }
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10830 | FavoriteDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        this.initializeBounds(true);
    }

    protected void initializeBounds(boolean bl) {
        Point point;
        super.initializeBounds();
        Point point2 = this.getShell().getSize();
        Point point3 = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(400), -1);
        Point point4 = point = bl ? this.getInitialLocation(point3) : this.getShell().getLocation();
        if (point3.y > point2.y) {
            this.getShell().setBounds(point.x, point.y, point3.x, point3.y);
        }
        this.getShell().setMinimumSize(point3.x, point3.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }
}

