/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.dialog.SelectCategoryDialog;
import net.sourceforge.rssowl.controller.thread.FeedDiscoveryManager;
import net.sourceforge.rssowl.dao.Exporter;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FeedDiscoveryDialog {
    private static final int DIALOG_HEIGHT = 300;
    private static final int DIALOG_WIDTH = 450;
    private Thread animator;
    private Composite composite;
    private Button importButton;
    private String message;
    private Shell parent;
    private String title;
    MenuItem addFeedToFav;
    Button clearButton;
    TableColumn columnFormat;
    TableColumn columnTitle;
    TableColumn columnUrl;
    MenuItem copyXmlLocation;
    Button exportToOpml;
    CLabel messageLabel;
    MenuItem openFeed;
    Hashtable results;
    Table resultTable;
    FeedDiscoveryManager rssOwlFeedDiscoveryManager;
    GUI rssOwlGui;
    Button searchButton;
    boolean searching;
    Text searchWebsite;
    Shell shell;
    DragSource tableDragSource;
    TextTransfer textTransfer;

    public FeedDiscoveryDialog(String string, String string2, GUI gUI) {
        this(null, string, string2, gUI);
    }

    public FeedDiscoveryDialog(String string, String string2, String string3, GUI gUI) {
        this.title = string2;
        this.rssOwlGui = gUI;
        this.searching = false;
        this.results = new Hashtable();
        this.parent = GUI.shell;
        this.message = string3;
        this.textTransfer = TextTransfer.getInstance();
        this.createDialogArea();
        if (StringShop.isset(string)) {
            this.searchWebsite.setText(string);
            this.performSearch(string);
        } else {
            TextTransfer textTransfer;
            Clipboard clipboard = GUI.rssOwlGui.getEventManager().getClipBoard();
            String string4 = (String)clipboard.getContents(textTransfer = TextTransfer.getInstance());
            String string5 = string4 = string4 != null ? string4.trim() : null;
            if (StringShop.isset(string4) && RegExShop.isValidURL(string4)) {
                this.searchWebsite.setText(string4);
                this.searchWebsite.selectAll();
            }
        }
    }

    public void addResultElement(String string, String string2, String string3) {
        if (!this.resultTable.isDisposed()) {
            if (!StringShop.isset(string2)) {
                string2 = GUI.i18n.getTranslation("NO_TITLE");
            }
            TableItem tableItem = new TableItem(this.resultTable, 0);
            tableItem.setText(0, string2);
            if (StringShop.isset(string)) {
                tableItem.setText(1, string);
            }
            if (StringShop.isset(string3)) {
                tableItem.setText(2, string3);
            }
            boolean bl = StringShop.isset(string) && !Category.linkExists(string);
            tableItem.setChecked(bl);
            if (!this.results.containsKey(string)) {
                this.results.put(string, string2);
            }
            this.setResultControlsEnabled(true);
        }
    }

    public Hashtable getResults() {
        return this.results;
    }

    public boolean isSearching() {
        return this.searching;
    }

    public void open() {
        ++WidgetShop.openDialogsCount;
        this.shell.open();
    }

    public void setButtonState(boolean bl) {
        if (GUI.isAlive() && !this.searchButton.isDisposed()) {
            this.searchButton.setText(GUI.i18n.getTranslation(bl ? "BUTTON_STOP_SEARCH" : "BUTTON_SEARCH"));
            this.searchButton.setData(bl ? "BUTTON_STOP_SEARCH" : "BUTTON_SEARCH");
        }
        if (GUI.isAlive() && !this.searchButton.isDisposed() && !this.searchButton.getParent().isDisposed()) {
            this.searchButton.update();
            this.searchButton.getParent().layout(true);
        }
    }

    public void setErrorMessage(String string) {
        if (!this.messageLabel.isDisposed()) {
            this.messageLabel.setImage(string == null ? null : PaintShop.iconError);
            this.messageLabel.setText(string == null ? "" : string);
        }
    }

    public void setMessage(String string) {
        if (!this.messageLabel.isDisposed()) {
            this.messageLabel.setText(string);
            this.messageLabel.setImage(PaintShop.iconFeedDiscovery);
        }
    }

    public void setSearching(boolean bl) {
        this.searching = bl;
    }

    public void stopStatusMessageAnimate() {
        if (this.animator != null && !this.animator.isInterrupted()) {
            this.animator.interrupt();
        }
    }

    private void createDialogArea() {
        this.shell = new Shell(this.parent, 1264);
        this.shell.setLayout(new FillLayout());
        if (!GlobalSettings.isMac()) {
            this.shell.setImage(PaintShop.iconFeedDiscovery);
        }
        this.shell.setText(this.title);
        this.shell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!FeedDiscoveryDialog.this.shell.getMinimized()) {
                    --WidgetShop.openDialogsCount;
                }
                if (FeedDiscoveryDialog.this.rssOwlFeedDiscoveryManager != null && FeedDiscoveryDialog.this.rssOwlFeedDiscoveryManager.isRunning()) {
                    FeedDiscoveryDialog.this.rssOwlFeedDiscoveryManager.stopSearch();
                }
                FeedDiscoveryDialog.this.stopStatusMessageAnimate();
                FeedDiscoveryDialog.this.setSearching(false);
            }
        });
        this.shell.addShellListener(new ShellAdapter(){

            @Override
            public void shellDeiconified(ShellEvent shellEvent) {
                ++WidgetShop.openDialogsCount;
            }

            @Override
            public void shellIconified(ShellEvent shellEvent) {
                --WidgetShop.openDialogsCount;
            }
        });
        this.composite = new Composite(this.shell, 0);
        this.composite.setLayout(LayoutShop.createGridLayout(2, 0, 5));
        Composite composite = new Composite(this.composite, 0);
        composite.setLayout(LayoutShop.createGridLayout(1, 5, 0));
        composite.setLayoutData(LayoutDataShop.createGridData(768, 2));
        Label label = new Label(composite, 64);
        label.setText(this.message + ":");
        label.setLayoutData(LayoutDataShop.createGridData(768, 1));
        label.setFont(FontShop.dialogFont);
        Composite composite2 = new Composite(this.composite, 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 5, 0));
        composite2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.searchWebsite = new Text(composite2, 2052);
        this.searchWebsite.setLayoutData(new GridData(768));
        this.searchWebsite.setFont(FontShop.dialogFont);
        this.searchWebsite.setFocus();
        this.searchWebsite.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r' && !FeedDiscoveryDialog.this.searchWebsite.getText().equals("") && FeedDiscoveryDialog.this.searchButton.getData().equals("BUTTON_SEARCH")) {
                    FeedDiscoveryDialog.this.performSearch(FeedDiscoveryDialog.this.searchWebsite.getText().trim());
                }
            }
        });
        this.searchWebsite.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                if (FeedDiscoveryDialog.this.searchButton.getData().equals("BUTTON_SEARCH")) {
                    FeedDiscoveryDialog.this.searchButton.setEnabled(!FeedDiscoveryDialog.this.searchWebsite.getText().trim().equals(""));
                }
            }
        });
        WidgetShop.setupDropSupport(this.searchWebsite, new Runnable(){

            @Override
            public void run() {
                if (StringShop.isset(FeedDiscoveryDialog.this.searchWebsite.getText()) && !FeedDiscoveryDialog.this.isSearching()) {
                    FeedDiscoveryDialog.this.performSearch(FeedDiscoveryDialog.this.searchWebsite.getText().trim());
                }
            }
        });
        WidgetShop.tweakTextWidget(this.searchWebsite);
        this.searchButton = new Button(composite2, 0);
        this.searchButton.setText(GUI.i18n.getTranslation("BUTTON_SEARCH"));
        this.searchButton.setLayoutData(new GridData(128));
        this.searchButton.setFont(FontShop.dialogFont);
        this.searchButton.setEnabled(false);
        this.searchButton.setData("BUTTON_SEARCH");
        this.searchButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (FeedDiscoveryDialog.this.searchButton.getData().equals("BUTTON_SEARCH")) {
                    FeedDiscoveryDialog.this.performSearch(FeedDiscoveryDialog.this.searchWebsite.getText().trim());
                } else {
                    FeedDiscoveryDialog.this.stopSearch();
                }
            }
        });
        this.shell.setDefaultButton(this.searchButton);
        Composite composite3 = new Composite(this.composite, 0);
        composite3.setLayout(LayoutShop.createFillLayout(5, 0));
        composite3.setLayoutData(LayoutDataShop.createGridData(1808, 2));
        final Composite composite4 = new Composite(composite3, 0);
        this.resultTable = new Table(composite4, 67618);
        this.resultTable.setLinesVisible(true);
        this.resultTable.setHeaderVisible(true);
        this.resultTable.setFont(FontShop.dialogFont);
        this.tableDragSource = new DragSource(this.resultTable, 3);
        this.tableDragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.tableDragSource.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragFinished(DragSourceEvent dragSourceEvent) {
                FeedDiscoveryDialog.this.rssOwlGui.getRSSOwlFavoritesTree().getRSSOwlFavoritesTreeDND().setDragSourceItem(null);
            }

            @Override
            public void dragSetData(DragSourceEvent dragSourceEvent) {
                TableItem tableItem = (TableItem)FeedDiscoveryDialog.this.rssOwlGui.getRSSOwlFavoritesTree().getRSSOwlFavoritesTreeDND().getDragSourceItem();
                if (WidgetShop.isset(tableItem)) {
                    dragSourceEvent.data = tableItem.getText(1) + System.getProperty("line.separator") + tableItem.getText(0);
                }
            }

            @Override
            public void dragStart(DragSourceEvent dragSourceEvent) {
                if (FeedDiscoveryDialog.this.resultTable.getSelectionCount() > 0) {
                    TableItem tableItem = FeedDiscoveryDialog.this.resultTable.getSelection()[0];
                    dragSourceEvent.doit = true;
                    FeedDiscoveryDialog.this.rssOwlGui.getRSSOwlFavoritesTree().getRSSOwlFavoritesTreeDND().setDragSourceItem(tableItem);
                } else {
                    dragSourceEvent.doit = false;
                }
            }
        });
        this.resultTable.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                FeedDiscoveryDialog.this.tableDragSource.dispose();
            }
        });
        this.resultTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!((keyEvent.stateMask & 0x40000) == 0 && (keyEvent.stateMask & 0x400000) == 0 || keyEvent.keyCode != 97 && keyEvent.keyCode != 65)) {
                    FeedDiscoveryDialog.this.resultTable.selectAll();
                } else if (keyEvent.keyCode == 127 || GlobalSettings.isMac() && keyEvent.keyCode == 8) {
                    TableItem[] tableItemArray = FeedDiscoveryDialog.this.resultTable.getSelection();
                    for (int i = 0; i < tableItemArray.length; ++i) {
                        tableItemArray[i].setChecked(false);
                    }
                }
            }
        });
        this.resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (FeedDiscoveryDialog.this.resultTable.getSelectionCount() > 0) {
                    FeedDiscoveryDialog.this.openFeed(FeedDiscoveryDialog.this.resultTable.getSelection()[0]);
                }
            }
        });
        this.columnTitle = new TableColumn(this.resultTable, 16384);
        this.columnTitle.setText(GUI.i18n.getTranslation("TABLE_HEADER_FEEDTITLE"));
        this.columnUrl = new TableColumn(this.resultTable, 16384);
        this.columnUrl.setText(GUI.i18n.getTranslation("TABLE_HEADER_FEEDURL"));
        this.columnFormat = new TableColumn(this.resultTable, 16384);
        this.columnFormat.setText(GUI.i18n.getTranslation("CHANNEL_INFO_RSSVERSION"));
        composite4.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = composite4.getClientArea();
                int n = rectangle.width - 2 * FeedDiscoveryDialog.this.resultTable.getBorderWidth() - FeedDiscoveryDialog.this.resultTable.getVerticalBar().getSize().x;
                if (GlobalSettings.isMac()) {
                    n -= 30;
                }
                Point point = FeedDiscoveryDialog.this.resultTable.getSize();
                if (point.x > rectangle.width) {
                    FeedDiscoveryDialog.this.columnTitle.setWidth(n / 6 * 3);
                    FeedDiscoveryDialog.this.columnUrl.setWidth(n / 6 * 2);
                    FeedDiscoveryDialog.this.columnFormat.setWidth(n / 6 * 1);
                    FeedDiscoveryDialog.this.resultTable.setSize(rectangle.width, rectangle.height);
                } else {
                    FeedDiscoveryDialog.this.resultTable.setSize(rectangle.width, rectangle.height);
                    FeedDiscoveryDialog.this.columnTitle.setWidth(n / 6 * 3);
                    FeedDiscoveryDialog.this.columnUrl.setWidth(n / 6 * 2);
                    FeedDiscoveryDialog.this.columnFormat.setWidth(n / 6 * 1);
                }
            }
        });
        Menu menu = new Menu(this.resultTable);
        menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                FeedDiscoveryDialog.this.addFeedToFav.setEnabled(FeedDiscoveryDialog.this.resultTable.getSelectionCount() > 0);
                FeedDiscoveryDialog.this.openFeed.setEnabled(FeedDiscoveryDialog.this.resultTable.getSelectionCount() > 0);
                FeedDiscoveryDialog.this.copyXmlLocation.setEnabled(FeedDiscoveryDialog.this.resultTable.getSelectionCount() > 0);
            }
        });
        this.addFeedToFav = new MenuItem(menu, 0);
        this.addFeedToFav.setText(GUI.i18n.getTranslation("BUTTON_ADDTO_FAVORITS") + "...");
        if (!GlobalSettings.isMac()) {
            this.addFeedToFav.setImage(PaintShop.iconAddToFavorites);
        }
        this.addFeedToFav.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = FeedDiscoveryDialog.this.resultTable.getSelection();
                for (int i = 0; i < tableItemArray.length; ++i) {
                    FeedDiscoveryDialog.this.rssOwlGui.getEventManager().actionAddToFavorites(tableItemArray[i].getText(0), tableItemArray[i].getText(1));
                }
            }
        });
        new MenuItem(menu, 2);
        this.openFeed = new MenuItem(menu, 0);
        this.openFeed.setText(GUI.i18n.getTranslation("BUTTON_OPEN"));
        this.openFeed.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = FeedDiscoveryDialog.this.resultTable.getSelection();
                for (int i = 0; i < tableItemArray.length; ++i) {
                    FeedDiscoveryDialog.this.openFeed(tableItemArray[i]);
                }
            }
        });
        new MenuItem(menu, 2);
        this.copyXmlLocation = new MenuItem(menu, 0);
        this.copyXmlLocation.setText(GUI.i18n.getTranslation("POP_COPY_NEWS_URL"));
        this.copyXmlLocation.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (FeedDiscoveryDialog.this.resultTable.getSelectionCount() > 0) {
                    FeedDiscoveryDialog.this.rssOwlGui.getEventManager().getClipBoard().setContents(new Object[]{FeedDiscoveryDialog.this.resultTable.getSelection()[0].getText(1)}, new Transfer[]{FeedDiscoveryDialog.this.textTransfer});
                }
            }
        });
        MenuManager.initMnemonics(menu);
        this.resultTable.setMenu(menu);
        Composite composite5 = new Composite(this.composite, 0);
        composite5.setLayout(LayoutShop.createGridLayout(1, 5, 0));
        composite5.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.messageLabel = new CLabel(composite5, 0);
        this.messageLabel.setFont(FontShop.dialogFont);
        this.messageLabel.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        Label label2 = new Label(this.composite, 258);
        label2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        Composite composite6 = new Composite(this.composite, 0);
        composite6.setLayout(LayoutShop.createGridLayout(3, 5, 5, 5, 5, false));
        composite6.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.importButton = new Button(composite6, 0);
        this.importButton.setFont(FontShop.dialogFont);
        this.importButton.setText(GUI.i18n.getTranslation("POP_IMPORT") + "...");
        this.importButton.setLayoutData(new GridData(1, 1, false, false));
        this.importButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FeedDiscoveryDialog.this.importResults();
            }
        });
        this.exportToOpml = new Button(composite6, 0);
        this.exportToOpml.setText(GUI.i18n.getTranslation("BUTTON_EXPORT_TO_OPML") + "...");
        this.exportToOpml.setFont(FontShop.dialogFont);
        this.exportToOpml.setLayoutData(new GridData(1, 1, false, false));
        this.exportToOpml.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FeedDiscoveryDialog.this.generateOpml();
            }
        });
        this.clearButton = new Button(composite6, 0);
        this.clearButton.setText(GUI.i18n.getTranslation("BUTTON_CLEAR_RESULTS"));
        this.clearButton.setFont(FontShop.dialogFont);
        this.clearButton.setLayoutData(new GridData(0x1000008, 1, true, false));
        this.clearButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FeedDiscoveryDialog.this.resultTable.removeAll();
                FeedDiscoveryDialog.this.results.clear();
                FeedDiscoveryDialog.this.setResultControlsEnabled(false);
            }
        });
        this.setResultControlsEnabled(false);
        GC gC = new GC(this.shell);
        gC.setFont(FontShop.dialogFont);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = Dialog.convertHorizontalDLUsToPixels(fontMetrics, 450);
        int n2 = Dialog.convertVerticalDLUsToPixels(fontMetrics, 300);
        this.shell.setSize(n, n2);
        gC.dispose();
        LayoutShop.positionShell(this.shell, false, WidgetShop.openDialogsCount);
        WidgetShop.initMnemonics(new Button[]{this.searchButton, this.importButton, this.exportToOpml, this.clearButton});
    }

    private void startStatusMessageAnimate() {
        this.animator = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    try {
                        for (int i = 1; i < 6; ++i) {
                            19.sleep(300L);
                            FeedDiscoveryDialog.this.setStatusPoints(i);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        this.animator.setName("Discovery Status Animator Thread");
        this.animator.setDaemon(true);
        this.animator.start();
    }

    void generateOpml() {
        TableItem[] tableItemArray = this.resultTable.getItems();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = this.searchWebsite.getText();
        if (string.equals("")) {
            string = GUI.i18n.getTranslation("NO_TITLE");
        }
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (!tableItemArray[i].getChecked()) continue;
            hashtable.put(tableItemArray[i].getText(1), tableItemArray[i].getText(0));
        }
        try {
            new Exporter().exportResultsToOPML(hashtable, string);
            FileShop.exportCategory(this.shell, string.replaceAll(" ", "_") + ".opml", new String[]{"*.opml", "*.xml", "*.*"});
        }
        catch (IOException iOException) {
            MessageBoxFactory.showError(this.shell, iOException);
        }
    }

    void importResults() {
        SelectCategoryDialog selectCategoryDialog = new SelectCategoryDialog(this.shell, GUI.i18n.getTranslation("MESSAGEBOX_SELECT_CAT"));
        if (selectCategoryDialog.open() != 0) {
            return;
        }
        String string = selectCategoryDialog.getCatPath();
        if (!StringShop.isset(string)) {
            return;
        }
        Category category = this.rssOwlGui.getRSSOwlFavoritesTree().getSelectedCat(string);
        TableItem[] tableItemArray = this.resultTable.getItems();
        boolean bl = false;
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (!tableItemArray[i].getChecked()) continue;
            bl = true;
            String string2 = tableItemArray[i].getText(1);
            String string3 = tableItemArray[i].getText(0);
            Favorite favorite = new Favorite(string2, string3, category);
            favorite.setCreationDate(System.currentTimeMillis());
            favorite.setLastVisitDate(0L);
            favorite.setUseProxy(ProxyShop.isUseProxy());
            Channel channel = this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(string2);
            if (channel != null) {
                favorite.syncMetaData(channel);
                favorite.setUnreadNewsCount(channel.getUnreadNewsCount());
            }
            if (category.getFavorites().containsKey(string2)) continue;
            this.rssOwlGui.getRSSOwlFavoritesTree().addFavorite(category, string2, string3, favorite);
        }
        if (bl) {
            this.rssOwlGui.getRSSOwlFavoritesTree().buildFavoritesTree();
        }
    }

    void openFeed(TableItem tableItem) {
        this.rssOwlGui.loadNewsFeed(tableItem.getText(1), SearchDefinition.NO_SEARCH, true, true, 0);
    }

    void performSearch(String string) {
        if (!string.equals("")) {
            this.setSearching(true);
            this.setButtonState(true);
            this.setErrorMessage(null);
            this.messageLabel.setText(GUI.i18n.getTranslation("LABEL_SEARCH_RUNNING"));
            this.messageLabel.setImage(PaintShop.iconFeedDiscovery);
            this.startStatusMessageAnimate();
            try {
                this.rssOwlFeedDiscoveryManager = new FeedDiscoveryManager(string, this);
                this.rssOwlFeedDiscoveryManager.startSearch();
            }
            catch (MalformedURLException malformedURLException) {
                this.setButtonState(false);
                this.stopStatusMessageAnimate();
                this.setErrorMessage(malformedURLException.getMessage());
            }
        }
    }

    void setResultControlsEnabled(boolean bl) {
        this.addFeedToFav.setEnabled(bl);
        this.openFeed.setEnabled(bl);
        this.copyXmlLocation.setEnabled(bl);
        this.clearButton.setEnabled(bl);
        this.exportToOpml.setEnabled(bl);
        this.importButton.setEnabled(bl);
    }

    void setStatusPoints(final int n) {
        if (GUI.isAlive()) {
            GUI.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    String string = "";
                    for (int i = 0; i < n; ++i) {
                        string = string + ".";
                    }
                    if (!FeedDiscoveryDialog.this.messageLabel.isDisposed() && !FeedDiscoveryDialog.this.messageLabel.getParent().isDisposed()) {
                        FeedDiscoveryDialog.this.messageLabel.setText(GUI.i18n.getTranslation("LABEL_SEARCH_RUNNING") + string);
                    }
                }
            });
        }
    }

    void stopSearch() {
        this.setSearching(false);
        if (this.rssOwlFeedDiscoveryManager != null) {
            this.rssOwlFeedDiscoveryManager.stopSearch();
        }
        this.stopStatusMessageAnimate();
        this.setButtonState(false);
        this.setMessage(GUI.i18n.getTranslation("LABEL_SEARCH_FINISHED"));
    }
}

