/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenFeedDialog
extends TitleAreaDialog {
    private static final int dialogMinWidth = 320;
    private String dialogMessage;
    private String dialogTitle;
    private String feedPath;
    Text feedPathInput;
    Button okButton;

    public OpenFeedDialog(Shell shell, String string, String string2) {
        super(shell);
        this.dialogTitle = string;
        this.dialogMessage = string2;
    }

    @Override
    public boolean close() {
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    public String getFeedPath() {
        return this.feedPath;
    }

    @Override
    protected void buttonPressed(int n) {
        this.feedPath = this.feedPathInput.getText().trim();
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.dialogTitle);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.feedPathInput.setFocus();
        this.okButton.setEnabled(false);
        this.okButton.setFont(FontShop.dialogFont);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(LayoutShop.createGridLayout(3, 5, 20));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/file_big.gif"));
        this.setMessage(this.dialogMessage, 1);
        Label label = new Label(composite2, 16384);
        label.setText(GUI.i18n.getTranslation("LABEL_ADDRESS"));
        label.setLayoutData(new GridData(32));
        label.setFont(FontShop.dialogFont);
        this.feedPathInput = new Text(composite2, 2052);
        this.feedPathInput.setLayoutData(new GridData(768));
        this.feedPathInput.setFont(FontShop.dialogFont);
        this.feedPathInput.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                OpenFeedDialog.this.okButton.setEnabled(!OpenFeedDialog.this.feedPathInput.getText().trim().equals(""));
            }
        });
        WidgetShop.tweakTextWidget(this.feedPathInput);
        Button button = new Button(composite2, 8);
        button.setText(GUI.i18n.getTranslation("BUTTON_FILE") + "...");
        button.setFont(FontShop.dialogFont);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FileShop.getFilePath(OpenFeedDialog.this.getShell(), null, null, 4096, null, GUI.i18n.getTranslation("BUTTON_OPEN"));
                if (string != null) {
                    OpenFeedDialog.this.feedPathInput.setText(string);
                }
            }
        });
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label2 = new Label(composite3, 258);
        label2.setLayoutData(new GridData(768));
        WidgetShop.initMnemonics(new Button[]{button});
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | OpenFeedDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }
}

