/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.util.ArrayList;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.SelectCategoryDialog;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog
extends Dialog {
    private static final int dialogMinWidth = 300;
    private static final ArrayList lastSearches = new ArrayList();
    private String dialogMessage;
    private CLabel errorMessageLabel;
    private Button matchCaseSensitive;
    private Combo scopeCombo;
    private SearchDefinition searchDefinition;
    private Button selectCategory;
    private String title;
    Category category;
    Button okButton;
    Button onlyWholeWords;
    Button regExSearch;
    Combo searchCombo;

    public SearchDialog(Shell shell, Category category, String string, String string2) {
        super(shell);
        this.title = string;
        this.dialogMessage = string2;
        this.category = category;
    }

    public SearchDialog(Shell shell, String string, String string2) {
        this(shell, null, string, string2);
    }

    public Category getCategory() {
        return this.category;
    }

    public SearchDefinition getValue() {
        return this.searchDefinition;
    }

    private void showSearch(SearchDefinition searchDefinition) {
        this.searchCombo.setText(searchDefinition.getPattern());
        this.searchCombo.setSelection(new Point(0, searchDefinition.getPattern().length()));
        this.scopeCombo.select(searchDefinition.getScope());
        this.matchCaseSensitive.setSelection(searchDefinition.isCaseSensitive());
        this.onlyWholeWords.setSelection(searchDefinition.isWholeWord());
        this.regExSearch.setSelection(searchDefinition.isPatternRegEx());
        this.onlyWholeWords.setEnabled(!this.regExSearch.getSelection());
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0) {
            String string;
            this.searchDefinition = new SearchDefinition(this.searchCombo.getText(), this.scopeCombo.getSelectionIndex());
            this.searchDefinition.setPatternIsRegEx(this.regExSearch.getSelection());
            this.searchDefinition.setIsWholeWord(this.onlyWholeWords.getSelection());
            this.searchDefinition.setIsCaseSensitive(this.matchCaseSensitive.getSelection());
            if (this.searchDefinition.isPatternRegEx() && !(string = RegExShop.compileRegEx(this.searchDefinition.getPattern())).equals("OK")) {
                this.setErrorMessage(string.split(System.getProperty("line.separator"))[0]);
                return;
            }
            if (lastSearches.contains(this.searchDefinition)) {
                lastSearches.remove(this.searchDefinition);
            }
            lastSearches.add(this.searchDefinition);
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.okButton.setFont(FontShop.dialogFont);
        this.okButton.setEnabled(lastSearches.size() > 0);
        if (lastSearches.size() > 0) {
            this.showSearch((SearchDefinition)lastSearches.get(lastSearches.size() - 1));
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Scrollable scrollable;
        Composite composite2;
        Composite composite3 = (Composite)super.createDialogArea(composite);
        composite3.setLayout(new GridLayout(2, false));
        Label label = new Label(composite3, 0);
        label.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_SEARCH_FOR") + ": ");
        label.setLayoutData(new GridData(1, 0x1000000, false, false));
        label.setFont(FontShop.dialogFont);
        this.searchCombo = new Combo(composite3, 4);
        this.searchCombo.setLayoutData(new GridData(4, 1, false, false));
        this.searchCombo.setFont(FontShop.dialogFont);
        this.searchCombo.setFocus();
        for (int i = lastSearches.size() - 1; i >= 0; --i) {
            this.searchCombo.add(((SearchDefinition)lastSearches.get(i)).getPattern());
        }
        this.searchCombo.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                SearchDialog.this.okButton.setEnabled(!SearchDialog.this.searchCombo.getText().equals(""));
            }
        });
        this.searchCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!((keyEvent.stateMask & 0x40000) == 0 && (keyEvent.stateMask & 0x400000) == 0 || keyEvent.keyCode != 97 && keyEvent.keyCode != 65)) {
                    SearchDialog.this.searchCombo.setSelection(new Point(0, SearchDialog.this.searchCombo.getText().length()));
                }
            }
        });
        Label label2 = new Label(composite3, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_SEARCH_IN") + ": ");
        label2.setLayoutData(new GridData(1, 0x1000000, false, false));
        label2.setFont(FontShop.dialogFont);
        this.scopeCombo = new Combo(composite3, 12);
        this.scopeCombo.setLayoutData(new GridData(4, 1, false, false));
        this.scopeCombo.setFont(FontShop.dialogFont);
        this.scopeCombo.setVisibleItemCount(SearchDefinition.SCOPE_NAMES.length);
        for (int i = 0; i < SearchDefinition.SCOPE_NAMES.length; ++i) {
            this.scopeCombo.add(GUI.i18n.getTranslation(SearchDefinition.SCOPE_NAMES[i]));
        }
        if (lastSearches.size() == 0) {
            this.scopeCombo.select(0);
        }
        if (this.category != null && !this.category.isRoot()) {
            Label label3 = new Label(composite3, 0);
            label3.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + ": ");
            label3.setLayoutData(new GridData(1, 0x1000000, false, false));
            label3.setFont(FontShop.dialogFont);
            composite2 = new Composite(composite3, 0);
            composite2.setLayoutData(LayoutDataShop.createGridData(768, 1));
            composite2.setLayout(LayoutShop.createGridLayout(2, 0, 0));
            scrollable = new Text(composite2, 2056);
            scrollable.setLayoutData(LayoutDataShop.createGridData(768, 1));
            scrollable.setFont(FontShop.dialogFont);
            ((Text)scrollable).setText(this.category.toCatPath(true));
            scrollable.setData(this.category.toCatPath());
            this.selectCategory = new Button(composite2, 0);
            this.selectCategory.setFont(FontShop.dialogFont);
            this.selectCategory.setText(GUI.i18n.getTranslation("BUTTON_CHANGE") + "...");
            this.selectCategory.setLayoutData(new GridData(128));
            this.selectCategory.addSelectionListener(new SelectionAdapter((Text)scrollable){
                final /* synthetic */ Text val$inputCategory;
                {
                    this.val$inputCategory = text;
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectCategoryDialog selectCategoryDialog = new SelectCategoryDialog(SearchDialog.this.getShell(), GUI.i18n.getTranslation("DIALOG_TITLE_CATEGORY"));
                    selectCategoryDialog.setReadonly(true);
                    selectCategoryDialog.setCatPath((String)this.val$inputCategory.getData());
                    if (selectCategoryDialog.open() == 0) {
                        this.val$inputCategory.setText(selectCategoryDialog.getCatPath() != null ? selectCategoryDialog.getCatPath().replaceAll("=;=", " | ") : "");
                        this.val$inputCategory.setData(selectCategoryDialog.getCatPath() != null ? selectCategoryDialog.getCatPath() : "");
                        SearchDialog.this.category = Category.fromPath(selectCategoryDialog.getCatPath());
                    }
                }
            });
        }
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout(LayoutShop.createGridLayout(1, 0, 10));
        composite4.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite2 = new Group(composite4, 0);
        composite2.setLayout(new GridLayout(1, true));
        ((Group)composite2).setText(GUI.i18n.getTranslation("LABEL_OPTIONS"));
        composite2.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite2.setFont(FontShop.dialogFont);
        scrollable = new Composite(composite2, 0);
        scrollable.setLayoutData(LayoutDataShop.createGridData(768, 1));
        ((Composite)scrollable).setLayout(LayoutShop.createGridLayout(1, 5, 1));
        this.onlyWholeWords = new Button((Composite)scrollable, 32);
        this.onlyWholeWords.setFont(FontShop.dialogFont);
        this.onlyWholeWords.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_EINTRE_WORDS"));
        Composite composite5 = new Composite(composite2, 0);
        composite5.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite5.setLayout(LayoutShop.createGridLayout(1, 5, 1));
        this.matchCaseSensitive = new Button(composite5, 32);
        this.matchCaseSensitive.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_CASESENSITIVE"));
        this.matchCaseSensitive.setFont(FontShop.dialogFont);
        Composite composite6 = new Composite(composite2, 0);
        composite6.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite6.setLayout(LayoutShop.createGridLayout(1, 5, 1));
        this.regExSearch = new Button(composite6, 32);
        this.regExSearch.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_REGEX"));
        this.regExSearch.setFont(FontShop.dialogFont);
        this.regExSearch.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchDialog.this.onlyWholeWords.setEnabled(!SearchDialog.this.regExSearch.getSelection());
            }
        });
        this.errorMessageLabel = new CLabel(composite3, 0);
        this.errorMessageLabel.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.errorMessageLabel.setFont(FontShop.dialogFont);
        this.errorMessageLabel.setImage(PaintShop.iconInfo);
        this.errorMessageLabel.setText(this.dialogMessage);
        Composite composite7 = new Composite(composite, 0);
        composite7.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite7.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label4 = new Label(composite7, 258);
        label4.setLayoutData(new GridData(768));
        if (WidgetShop.isset(this.selectCategory)) {
            WidgetShop.initMnemonics(new Button[]{this.selectCategory, this.onlyWholeWords, this.matchCaseSensitive, this.regExSearch});
        } else {
            WidgetShop.initMnemonics(new Button[]{this.onlyWholeWords, this.matchCaseSensitive, this.regExSearch});
        }
        return composite3;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | SearchDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(300), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }

    protected void setErrorMessage(String string) {
        this.errorMessageLabel.setImage(string == null ? null : PaintShop.iconError);
        this.errorMessageLabel.setText(string == null ? "" : string);
        this.errorMessageLabel.getParent().layout();
    }
}

